/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac.ast;

import com.intellij.openapi.util.AtomicClearableLazyValue;
import com.intellij.util.Consumer;
import com.intellij.util.SystemProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.tools.JavaCompiler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.java.JavaCompilingTool;
import org.jetbrains.jps.javac.DiagnosticOutputConsumer;
import org.jetbrains.jps.javac.JavaCompilerToolExtension;
import org.jetbrains.jps.javac.ast.JavacReferenceCollector;
import org.jetbrains.jps.javac.ast.api.JavacFileData;
import org.jetbrains.jps.javac.ast.api.JavacFileReferencesRegistrar;
import org.jetbrains.jps.service.JpsServiceManager;

public class RefCollectorCompilerToolExtension
extends JavaCompilerToolExtension {
    public static final String ID = "ASTReferenceCollector";
    private static final String ENABLED_PARAM = "jps.ref.collector.enabled";
    private static final String DIVIDE_IMPORTS_PARAM = "jps.divide.imports";
    private final AtomicClearableLazyValue<List<JavacFileReferencesRegistrar>> myRegistrars = new AtomicClearableLazyValue<List<JavacFileReferencesRegistrar>>(){

        @NotNull
        protected List<JavacFileReferencesRegistrar> compute() {
            ArrayList<JavacFileReferencesRegistrar> result = new ArrayList<JavacFileReferencesRegistrar>();
            for (JavacFileReferencesRegistrar registrar : JpsServiceManager.getInstance().getExtensions(JavacFileReferencesRegistrar.class)) {
                if (!registrar.isEnabled()) continue;
                registrar.initialize();
                result.add(registrar);
            }
            ArrayList<JavacFileReferencesRegistrar> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/javac/ast/RefCollectorCompilerToolExtension$1", "compute"));
            }
            return arrayList;
        }
    };

    @NotNull
    public String getId() {
        if (ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/javac/ast/RefCollectorCompilerToolExtension", "getId"));
        }
        return ID;
    }

    public void beforeCompileTaskExecution(@NotNull JavaCompilingTool compilingTool, @NotNull JavaCompiler.CompilationTask task, @NotNull Collection<String> options, final @NotNull DiagnosticOutputConsumer diagnosticConsumer) {
        if (compilingTool == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilingTool", "org/jetbrains/jps/javac/ast/RefCollectorCompilerToolExtension", "beforeCompileTaskExecution"));
        }
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/jps/javac/ast/RefCollectorCompilerToolExtension", "beforeCompileTaskExecution"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "org/jetbrains/jps/javac/ast/RefCollectorCompilerToolExtension", "beforeCompileTaskExecution"));
        }
        if (diagnosticConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnosticConsumer", "org/jetbrains/jps/javac/ast/RefCollectorCompilerToolExtension", "beforeCompileTaskExecution"));
        }
        if (RefCollectorCompilerToolExtension.isJavac(compilingTool)) {
            boolean divideImportsRefs;
            Object fileDataConsumer;
            String isEnabledProperty = System.getProperty(ENABLED_PARAM);
            if (isEnabledProperty == null) {
                RefCollectorOptions refCollectorOptions = new RefCollectorOptions();
                fileDataConsumer = refCollectorOptions.enabled ? new Consumer<JavacFileData>(){

                    public void consume(JavacFileData data) {
                        RefCollectorCompilerToolExtension.this.submitFileData(data);
                    }
                } : null;
                divideImportsRefs = refCollectorOptions.divideImportRefs;
            } else if (isEnabledProperty.equals("true")) {
                fileDataConsumer = new Consumer<JavacFileData>(){

                    public void consume(JavacFileData data) {
                        diagnosticConsumer.customOutputData(RefCollectorCompilerToolExtension.ID, "javac-refs", data.asBytes());
                    }
                };
                divideImportsRefs = SystemProperties.getBooleanProperty((String)DIVIDE_IMPORTS_PARAM, (boolean)false);
            } else {
                return;
            }
            if (fileDataConsumer != null) {
                JavacReferenceCollector.installOn(task, divideImportsRefs, fileDataConsumer);
            }
        }
    }

    public List<String> getExternalBuildProcessOptions(@NotNull JavaCompilingTool compilingTool) {
        if (compilingTool == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilingTool", "org/jetbrains/jps/javac/ast/RefCollectorCompilerToolExtension", "getExternalBuildProcessOptions"));
        }
        ArrayList<String> options = new ArrayList<String>(2);
        if (RefCollectorCompilerToolExtension.isJavac(compilingTool)) {
            RefCollectorOptions refCollectorOptions = new RefCollectorOptions();
            options.add("-Djps.ref.collector.enabled=" + refCollectorOptions.enabled);
            if (refCollectorOptions.enabled && refCollectorOptions.divideImportRefs) {
                options.add("-Djps.divide.imports=true");
            }
        } else {
            options.add("-Djps.ref.collector.enabled=false");
        }
        return options;
    }

    public void processData(String dataName, byte[] content) {
        this.submitFileData(JavacFileData.fromBytes(content));
    }

    private void submitFileData(@NotNull JavacFileData data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/jetbrains/jps/javac/ast/RefCollectorCompilerToolExtension", "submitFileData"));
        }
        for (JavacFileReferencesRegistrar registrar : (List)this.myRegistrars.getValue()) {
            registrar.registerFile(data.getFilePath(), registrar.onlyImports() ? data.getImportRefs() : data.getRefs(), data.getDefs());
        }
    }

    private static boolean isJavac(@NotNull JavaCompilingTool compilingTool) {
        if (compilingTool == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilingTool", "org/jetbrains/jps/javac/ast/RefCollectorCompilerToolExtension", "isJavac"));
        }
        return "Javac".equals(compilingTool.getId());
    }

    public void clearRegistrars() {
        this.myRegistrars.drop();
    }

    private static class RefCollectorOptions {
        private final boolean enabled;
        private final boolean divideImportRefs;

        private RefCollectorOptions() {
            boolean enabled = false;
            boolean divideImportRefs = false;
            for (JavacFileReferencesRegistrar listener : JpsServiceManager.getInstance().getExtensions(JavacFileReferencesRegistrar.class)) {
                if (!listener.isEnabled()) continue;
                enabled = true;
                if (!listener.onlyImports()) continue;
                divideImportRefs = true;
            }
            this.enabled = enabled;
            this.divideImportRefs = divideImportRefs;
        }
    }
}

