/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac.ast.api;

import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Modifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.javac.ast.api.JavacDef;
import org.jetbrains.jps.javac.ast.api.JavacRef;

public class JavacFileData {
    private final String myFilePath;
    private final Collection<JavacRef> myRefs;
    private final Collection<JavacRef> myImportRefs;
    private final List<JavacDef> myDefs;
    private static final DataExternalizer<JavacFileData> EXTERNALIZER = new DataExternalizer<JavacFileData>(){
        DataExternalizer<JavacRef> myRefSeqExternalizer = JavacFileData.access$000();
        DataExternalizer<JavacDef> myDefSeqExternalizer = JavacFileData.access$100();

        public void save(@NotNull DataOutput out, JavacFileData data) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "org/jetbrains/jps/javac/ast/api/JavacFileData$1", "save"));
            }
            EnumeratorStringDescriptor.INSTANCE.save(out, data.getFilePath());
            this.saveRefs(out, data.getRefs());
            this.saveRefs(out, data.getImportRefs());
            this.saveDefs(out, data.getDefs());
        }

        public JavacFileData read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "org/jetbrains/jps/javac/ast/api/JavacFileData$1", "read"));
            }
            return new JavacFileData(EnumeratorStringDescriptor.INSTANCE.read(in), this.readRefs(in), this.readRefs(in), this.readDefs(in));
        }

        private void saveRefs(final DataOutput out, Collection<JavacRef> refs) throws IOException {
            DataInputOutputUtil.writeSeq((DataOutput)out, refs, (ThrowableConsumer)new ThrowableConsumer<JavacRef, IOException>(){

                public void consume(JavacRef ref) throws IOException {
                    myRefSeqExternalizer.save(out, (Object)ref);
                }
            });
        }

        private Collection<JavacRef> readRefs(final DataInput in) throws IOException {
            return DataInputOutputUtil.readSeq((DataInput)in, (ThrowableComputable)new ThrowableComputable<JavacRef, IOException>(){

                public JavacRef compute() throws IOException {
                    return (JavacRef)myRefSeqExternalizer.read(in);
                }
            });
        }

        private void saveDefs(final DataOutput out, List<JavacDef> defs) throws IOException {
            DataInputOutputUtil.writeSeq((DataOutput)out, defs, (ThrowableConsumer)new ThrowableConsumer<JavacDef, IOException>(){

                public void consume(JavacDef def) throws IOException {
                    myDefSeqExternalizer.save(out, (Object)def);
                }
            });
        }

        private List<JavacDef> readDefs(final DataInput in) throws IOException {
            return DataInputOutputUtil.readSeq((DataInput)in, (ThrowableComputable)new ThrowableComputable<JavacDef, IOException>(){

                public JavacDef compute() throws IOException {
                    return (JavacDef)myDefSeqExternalizer.read(in);
                }
            });
        }
    };

    public JavacFileData(@NotNull String path, @NotNull Collection<JavacRef> refs, @NotNull Collection<JavacRef> importRefs, @NotNull List<JavacDef> defs) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/jps/javac/ast/api/JavacFileData", "<init>"));
        }
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "org/jetbrains/jps/javac/ast/api/JavacFileData", "<init>"));
        }
        if (importRefs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importRefs", "org/jetbrains/jps/javac/ast/api/JavacFileData", "<init>"));
        }
        if (defs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defs", "org/jetbrains/jps/javac/ast/api/JavacFileData", "<init>"));
        }
        this.myFilePath = path;
        this.myRefs = refs;
        this.myImportRefs = importRefs;
        this.myDefs = defs;
    }

    @NotNull
    public String getFilePath() {
        String string = this.myFilePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/javac/ast/api/JavacFileData", "getFilePath"));
        }
        return string;
    }

    @NotNull
    public Collection<JavacRef> getRefs() {
        Collection<JavacRef> collection = this.myRefs;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/javac/ast/api/JavacFileData", "getRefs"));
        }
        return collection;
    }

    @NotNull
    public Collection<JavacRef> getImportRefs() {
        Collection<JavacRef> collection = this.myImportRefs;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/javac/ast/api/JavacFileData", "getImportRefs"));
        }
        return collection;
    }

    @NotNull
    public List<JavacDef> getDefs() {
        List<JavacDef> list = this.myDefs;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/javac/ast/api/JavacFileData", "getDefs"));
        }
        return list;
    }

    @NotNull
    public byte[] asBytes() {
        BufferExposingByteArrayOutputStream os = new BufferExposingByteArrayOutputStream();
        DataOutputStream stream = new DataOutputStream((OutputStream)os);
        try {
            EXTERNALIZER.save((DataOutput)stream, (Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        byte[] byArray = os.toByteArray();
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/javac/ast/api/JavacFileData", "asBytes"));
        }
        return byArray;
    }

    @NotNull
    public static JavacFileData fromBytes(byte[] bytes) {
        JavacFileData javacFileData;
        UnsyncByteArrayInputStream is = new UnsyncByteArrayInputStream(bytes);
        try {
            javacFileData = (JavacFileData)EXTERNALIZER.read((DataInput)new DataInputStream((InputStream)is));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (javacFileData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/javac/ast/api/JavacFileData", "fromBytes"));
        }
        return javacFileData;
    }

    private static DataExternalizer<JavacDef> createDefExternalizer() {
        return new DataExternalizer<JavacDef>(){
            private static final byte CLASS_MARKER = 0;
            private static final byte FUN_EXPR_MARKER = 1;
            DataExternalizer<JavacRef> refExternalizer = JavacFileData.access$000();

            public void save(@NotNull DataOutput out, JavacDef def) throws IOException {
                if (out == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "org/jetbrains/jps/javac/ast/api/JavacFileData$2", "save"));
                }
                if (def instanceof JavacDef.JavacClassDef) {
                    out.writeByte(0);
                    JavacRef[] superClasses = ((JavacDef.JavacClassDef)def).getSuperClasses();
                    out.writeInt(superClasses.length);
                    for (JavacRef aClass : superClasses) {
                        this.refExternalizer.save(out, (Object)aClass);
                    }
                } else if (def instanceof JavacDef.JavacFunExprDef) {
                    out.writeByte(1);
                } else {
                    throw new IllegalStateException("unknown type: " + def.getClass());
                }
                this.refExternalizer.save(out, (Object)def.getDefinedElement());
            }

            public JavacDef read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "org/jetbrains/jps/javac/ast/api/JavacFileData$2", "read"));
                }
                byte marker = in.readByte();
                switch (marker) {
                    case 0: {
                        int supersSize = in.readInt();
                        JavacRef[] superClasses = new JavacRef[supersSize];
                        for (int i = 0; i < supersSize; ++i) {
                            superClasses[i] = (JavacRef)this.refExternalizer.read(in);
                        }
                        return new JavacDef.JavacClassDef((JavacRef)this.refExternalizer.read(in), superClasses);
                    }
                    case 1: {
                        return new JavacDef.JavacFunExprDef((JavacRef)this.refExternalizer.read(in));
                    }
                }
                throw new IllegalStateException("unknown marker " + marker);
            }
        };
    }

    private static DataExternalizer<JavacRef> createRefExternalizer() {
        return new DataExternalizer<JavacRef>(){
            private static final byte CLASS_MARKER = 0;
            private static final byte METHOD_MARKER = 1;
            private static final byte FIELD_MARKER = 2;

            public void save(@NotNull DataOutput out, JavacRef ref) throws IOException {
                if (out == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "org/jetbrains/jps/javac/ast/api/JavacFileData$3", "save"));
                }
                if (ref instanceof JavacRef.JavacClass) {
                    out.writeByte(0);
                    out.writeBoolean(((JavacRef.JavacClass)ref).isAnonymous());
                } else if (ref instanceof JavacRef.JavacField) {
                    out.writeByte(2);
                    IOUtil.writeUTF((DataOutput)out, (String)ref.getOwnerName());
                } else if (ref instanceof JavacRef.JavacMethod) {
                    out.writeByte(1);
                    IOUtil.writeUTF((DataOutput)out, (String)ref.getOwnerName());
                    out.write(((JavacRef.JavacMethod)ref).getParamCount());
                } else {
                    throw new IllegalStateException("unknown type: " + ref.getClass());
                }
                this.writeModifiers(out, ref.getModifiers());
                IOUtil.writeUTF((DataOutput)out, (String)ref.getName());
            }

            public JavacRef read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "org/jetbrains/jps/javac/ast/api/JavacFileData$3", "read"));
                }
                byte marker = in.readByte();
                switch (marker) {
                    case 0: {
                        return new JavacRef.JavacClassImpl(in.readBoolean(), this.readModifiers(in), IOUtil.readUTF((DataInput)in));
                    }
                    case 1: {
                        return new JavacRef.JavacMethodImpl(IOUtil.readUTF((DataInput)in), in.readByte(), this.readModifiers(in), IOUtil.readUTF((DataInput)in));
                    }
                    case 2: {
                        return new JavacRef.JavacFieldImpl(IOUtil.readUTF((DataInput)in), this.readModifiers(in), IOUtil.readUTF((DataInput)in));
                    }
                }
                throw new IllegalStateException("unknown marker " + marker);
            }

            private void writeModifiers(final DataOutput output, Set<Modifier> modifiers) throws IOException {
                DataInputOutputUtil.writeSeq((DataOutput)output, modifiers, (ThrowableConsumer)new ThrowableConsumer<Modifier, IOException>(){

                    public void consume(Modifier modifier) throws IOException {
                        IOUtil.writeUTF((DataOutput)output, (String)modifier.name());
                    }
                });
            }

            private Set<Modifier> readModifiers(final DataInput input) throws IOException {
                return EnumSet.copyOf(DataInputOutputUtil.readSeq((DataInput)input, (ThrowableComputable)new ThrowableComputable<Modifier, IOException>(){

                    public Modifier compute() throws IOException {
                        return Modifier.valueOf(IOUtil.readUTF((DataInput)input));
                    }
                }));
            }
        };
    }

    static /* synthetic */ DataExternalizer access$000() {
        return JavacFileData.createRefExternalizer();
    }

    static /* synthetic */ DataExternalizer access$100() {
        return JavacFileData.createDefExternalizer();
    }
}

