/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.tools.JavaCompiler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ExtensionsSupport;
import org.jetbrains.jps.builders.java.JavaCompilingTool;
import org.jetbrains.jps.javac.DiagnosticOutputConsumer;

public abstract class JavaCompilerToolExtension {
    private static final ExtensionsSupport<JavaCompilerToolExtension> ourExtSupport = new ExtensionsSupport<JavaCompilerToolExtension>(JavaCompilerToolExtension.class);

    @NotNull
    public abstract String getId();

    public void beforeCompileTaskExecution(@NotNull JavaCompilingTool compilingTool, @NotNull JavaCompiler.CompilationTask task, @NotNull Collection<String> options, @NotNull DiagnosticOutputConsumer diagnosticConsumer) {
        if (compilingTool == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilingTool", "org/jetbrains/jps/javac/JavaCompilerToolExtension", "beforeCompileTaskExecution"));
        }
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/jps/javac/JavaCompilerToolExtension", "beforeCompileTaskExecution"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "org/jetbrains/jps/javac/JavaCompilerToolExtension", "beforeCompileTaskExecution"));
        }
        if (diagnosticConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnosticConsumer", "org/jetbrains/jps/javac/JavaCompilerToolExtension", "beforeCompileTaskExecution"));
        }
    }

    public void processData(String dataName, byte[] content) {
    }

    public List<String> getExternalBuildProcessOptions(@NotNull JavaCompilingTool compilingTool) {
        if (compilingTool == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilingTool", "org/jetbrains/jps/javac/JavaCompilerToolExtension", "getExternalBuildProcessOptions"));
        }
        return Collections.emptyList();
    }

    @NotNull
    public static Collection<JavaCompilerToolExtension> getExtensions() {
        Collection<JavaCompilerToolExtension> collection = ourExtSupport.getExtensions();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/javac/JavaCompilerToolExtension", "getExtensions"));
        }
        return collection;
    }

    @Nullable
    public static JavaCompilerToolExtension getExtension(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "org/jetbrains/jps/javac/JavaCompilerToolExtension", "getExtension"));
        }
        for (JavaCompilerToolExtension extension : JavaCompilerToolExtension.getExtensions()) {
            if (!id.equals(extension.getId())) continue;
            return extension;
        }
        return null;
    }
}

