/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.artifact.impl.elements;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.artifact.JpsArtifactReference;
import org.jetbrains.jps.model.artifact.elements.JpsArchivePackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsArtifactOutputPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsArtifactRootElement;
import org.jetbrains.jps.model.artifact.elements.JpsCompositePackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsDirectoryCopyPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsDirectoryPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsExtractedDirectoryPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsFileCopyPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsLibraryFilesPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsPackagingElementFactory;
import org.jetbrains.jps.model.artifact.impl.elements.JpsArchivePackagingElementImpl;
import org.jetbrains.jps.model.artifact.impl.elements.JpsArtifactOutputPackagingElementImpl;
import org.jetbrains.jps.model.artifact.impl.elements.JpsArtifactRootElementImpl;
import org.jetbrains.jps.model.artifact.impl.elements.JpsDirectoryCopyPackagingElementImpl;
import org.jetbrains.jps.model.artifact.impl.elements.JpsDirectoryPackagingElementImpl;
import org.jetbrains.jps.model.artifact.impl.elements.JpsExtractedDirectoryPackagingElementImpl;
import org.jetbrains.jps.model.artifact.impl.elements.JpsFileCopyPackagingElementImpl;
import org.jetbrains.jps.model.artifact.impl.elements.JpsLibraryFilesPackagingElementImpl;
import org.jetbrains.jps.model.library.JpsLibraryReference;

public class JpsPackagingElementFactoryImpl
extends JpsPackagingElementFactory {
    @Override
    @NotNull
    public JpsDirectoryCopyPackagingElement createDirectoryCopy(@NotNull String directoryPath) {
        if (directoryPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directoryPath", "org/jetbrains/jps/model/artifact/impl/elements/JpsPackagingElementFactoryImpl", "createDirectoryCopy"));
        }
        JpsDirectoryCopyPackagingElementImpl jpsDirectoryCopyPackagingElementImpl = new JpsDirectoryCopyPackagingElementImpl(directoryPath);
        if (jpsDirectoryCopyPackagingElementImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/artifact/impl/elements/JpsPackagingElementFactoryImpl", "createDirectoryCopy"));
        }
        return jpsDirectoryCopyPackagingElementImpl;
    }

    @Override
    public JpsPackagingElement createParentDirectories(String relativeOutputPath, JpsPackagingElement element) {
        if ((relativeOutputPath = StringUtil.trimStart((String)relativeOutputPath, (String)"/")).length() == 0) {
            return element;
        }
        int slash = relativeOutputPath.indexOf(47);
        if (slash == -1) {
            slash = relativeOutputPath.length();
        }
        String rootName = relativeOutputPath.substring(0, slash);
        String pathTail = relativeOutputPath.substring(slash);
        JpsDirectoryPackagingElement root = this.createDirectory(rootName);
        JpsCompositePackagingElement last = this.getOrCreateDirectoryOrArchive(root, pathTail, true);
        last.addChild(element);
        return root;
    }

    @Override
    public JpsCompositePackagingElement getOrCreateDirectory(@NotNull JpsCompositePackagingElement root, @NotNull String path) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/jps/model/artifact/impl/elements/JpsPackagingElementFactoryImpl", "getOrCreateDirectory"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/jps/model/artifact/impl/elements/JpsPackagingElementFactoryImpl", "getOrCreateDirectory"));
        }
        return this.getOrCreateDirectoryOrArchive(root, path, true);
    }

    @Override
    public JpsCompositePackagingElement getOrCreateArchive(@NotNull JpsCompositePackagingElement root, @NotNull String path) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/jps/model/artifact/impl/elements/JpsPackagingElementFactoryImpl", "getOrCreateArchive"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/jps/model/artifact/impl/elements/JpsPackagingElementFactoryImpl", "getOrCreateArchive"));
        }
        return this.getOrCreateDirectoryOrArchive(root, path, false);
    }

    @NotNull
    private JpsCompositePackagingElement getOrCreateDirectoryOrArchive(@NotNull JpsCompositePackagingElement root, @NotNull @NonNls String path, boolean directory) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/jps/model/artifact/impl/elements/JpsPackagingElementFactoryImpl", "getOrCreateDirectoryOrArchive"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/jps/model/artifact/impl/elements/JpsPackagingElementFactoryImpl", "getOrCreateDirectoryOrArchive"));
        }
        if ((path = StringUtil.trimStart((String)StringUtil.trimEnd((String)path, (String)"/"), (String)"/")).length() == 0) {
            JpsCompositePackagingElement jpsCompositePackagingElement = root;
            if (jpsCompositePackagingElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/artifact/impl/elements/JpsPackagingElementFactoryImpl", "getOrCreateDirectoryOrArchive"));
            }
            return jpsCompositePackagingElement;
        }
        int index = path.lastIndexOf(47);
        String lastName = path.substring(index + 1);
        String parentPath = index != -1 ? path.substring(0, index) : "";
        JpsCompositePackagingElement parent = this.getOrCreateDirectoryOrArchive(root, parentPath, true);
        JpsCompositePackagingElement last = directory ? this.createDirectory(lastName) : this.createArchive(lastName);
        JpsCompositePackagingElement jpsCompositePackagingElement = parent.addChild(last);
        if (jpsCompositePackagingElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/artifact/impl/elements/JpsPackagingElementFactoryImpl", "getOrCreateDirectoryOrArchive"));
        }
        return jpsCompositePackagingElement;
    }

    @Override
    @NotNull
    public JpsFileCopyPackagingElement createFileCopy(@NotNull String filePath, @Nullable String outputFileName) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "org/jetbrains/jps/model/artifact/impl/elements/JpsPackagingElementFactoryImpl", "createFileCopy"));
        }
        JpsFileCopyPackagingElementImpl jpsFileCopyPackagingElementImpl = new JpsFileCopyPackagingElementImpl(filePath, outputFileName);
        if (jpsFileCopyPackagingElementImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/artifact/impl/elements/JpsPackagingElementFactoryImpl", "createFileCopy"));
        }
        return jpsFileCopyPackagingElementImpl;
    }

    @Override
    @NotNull
    public JpsExtractedDirectoryPackagingElement createExtractedDirectory(@NotNull String jarPath, @NotNull String pathInJar) {
        if (jarPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jarPath", "org/jetbrains/jps/model/artifact/impl/elements/JpsPackagingElementFactoryImpl", "createExtractedDirectory"));
        }
        if (pathInJar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathInJar", "org/jetbrains/jps/model/artifact/impl/elements/JpsPackagingElementFactoryImpl", "createExtractedDirectory"));
        }
        JpsExtractedDirectoryPackagingElementImpl jpsExtractedDirectoryPackagingElementImpl = new JpsExtractedDirectoryPackagingElementImpl(jarPath, pathInJar);
        if (jpsExtractedDirectoryPackagingElementImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/artifact/impl/elements/JpsPackagingElementFactoryImpl", "createExtractedDirectory"));
        }
        return jpsExtractedDirectoryPackagingElementImpl;
    }

    @Override
    @NotNull
    public JpsDirectoryPackagingElement createDirectory(@NotNull String directoryName) {
        if (directoryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directoryName", "org/jetbrains/jps/model/artifact/impl/elements/JpsPackagingElementFactoryImpl", "createDirectory"));
        }
        JpsDirectoryPackagingElementImpl jpsDirectoryPackagingElementImpl = new JpsDirectoryPackagingElementImpl(directoryName);
        if (jpsDirectoryPackagingElementImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/artifact/impl/elements/JpsPackagingElementFactoryImpl", "createDirectory"));
        }
        return jpsDirectoryPackagingElementImpl;
    }

    @Override
    @NotNull
    public JpsArchivePackagingElement createArchive(@NotNull String archiveName) {
        if (archiveName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "archiveName", "org/jetbrains/jps/model/artifact/impl/elements/JpsPackagingElementFactoryImpl", "createArchive"));
        }
        JpsArchivePackagingElementImpl jpsArchivePackagingElementImpl = new JpsArchivePackagingElementImpl(archiveName);
        if (jpsArchivePackagingElementImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/artifact/impl/elements/JpsPackagingElementFactoryImpl", "createArchive"));
        }
        return jpsArchivePackagingElementImpl;
    }

    @Override
    @NotNull
    public JpsArtifactRootElement createArtifactRoot() {
        JpsArtifactRootElementImpl jpsArtifactRootElementImpl = new JpsArtifactRootElementImpl();
        if (jpsArtifactRootElementImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/artifact/impl/elements/JpsPackagingElementFactoryImpl", "createArtifactRoot"));
        }
        return jpsArtifactRootElementImpl;
    }

    @Override
    @NotNull
    public JpsLibraryFilesPackagingElement createLibraryElement(@NotNull JpsLibraryReference reference) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "org/jetbrains/jps/model/artifact/impl/elements/JpsPackagingElementFactoryImpl", "createLibraryElement"));
        }
        JpsLibraryFilesPackagingElementImpl jpsLibraryFilesPackagingElementImpl = new JpsLibraryFilesPackagingElementImpl(reference);
        if (jpsLibraryFilesPackagingElementImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/artifact/impl/elements/JpsPackagingElementFactoryImpl", "createLibraryElement"));
        }
        return jpsLibraryFilesPackagingElementImpl;
    }

    @Override
    @NotNull
    public JpsArtifactOutputPackagingElement createArtifactOutput(@NotNull JpsArtifactReference reference) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "org/jetbrains/jps/model/artifact/impl/elements/JpsPackagingElementFactoryImpl", "createArtifactOutput"));
        }
        JpsArtifactOutputPackagingElementImpl jpsArtifactOutputPackagingElementImpl = new JpsArtifactOutputPackagingElementImpl(reference);
        if (jpsArtifactOutputPackagingElementImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/artifact/impl/elements/JpsPackagingElementFactoryImpl", "createArtifactOutput"));
        }
        return jpsArtifactOutputPackagingElementImpl;
    }
}

