/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.indexing.impl.ForwardIndex;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class MapInputKeyIterator<Key, Value>
implements ForwardIndex.InputKeyIterator<Key, Value> {
    private final Map<Key, Value> myMap;
    private Iterator<Map.Entry<Key, Value>> myIterator;
    private Value myCurrentValue;

    public MapInputKeyIterator(Map<Key, Value> map) {
        this.myMap = map;
    }

    @Override
    public boolean isAssociatedValueEqual(@Nullable Value value) {
        return Comparing.equal(this.myCurrentValue, value);
    }

    @Override
    public boolean hasNext() {
        this.init();
        return this.myIterator.hasNext();
    }

    @Override
    public Key next() {
        Map.Entry<Key, Value> entry = this.myIterator.next();
        this.myCurrentValue = entry.getValue();
        return entry.getKey();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void init() {
        if (this.myIterator == null) {
            this.myIterator = (this.myMap == null ? Collections.emptyMap() : this.myMap).entrySet().iterator();
        }
    }
}

