/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.backwardRefs;

import com.intellij.openapi.util.Factory;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.jps.backwardRefs.BackwardReferenceIndexWriter;
import org.jetbrains.jps.backwardRefs.LightRef;
import org.jetbrains.jps.backwardRefs.index.CompiledFileData;
import org.jetbrains.jps.javac.ast.api.JavacDef;
import org.jetbrains.jps.javac.ast.api.JavacRef;

public class BackwardReferenceIndexUtil {
    static void registerFile(String filePath, Collection<? extends JavacRef> refs, List<JavacDef> defs, BackwardReferenceIndexWriter writer) {
        int fileId = writer.enumeratePath(filePath);
        int funExprId = 0;
        HashMap<LightRef, Void> definitions = new HashMap<LightRef, Void>(defs.size());
        HashMap<LightRef, Collection<LightRef>> backwardHierarchyMap = new HashMap<LightRef, Collection<LightRef>>();
        for (JavacDef def : defs) {
            if (def instanceof JavacDef.JavacClassDef) {
                JavacRef[] superClasses;
                JavacRef.JavacClass javacClass = (JavacRef.JavacClass)def.getDefinedElement();
                LightRef.JavaLightClassRef aClass = writer.asClassUsage((JavacRef)javacClass);
                definitions.put(aClass, null);
                for (JavacRef superClass : superClasses = ((JavacDef.JavacClassDef)def).getSuperClasses()) {
                    LightRef.JavaLightClassRef superClassRef = writer.asClassUsage(superClass);
                    Collection children = (Collection)backwardHierarchyMap.get(superClassRef);
                    if (children == null) {
                        children = new SmartList();
                        backwardHierarchyMap.put(superClassRef, children);
                    }
                    children.add(aClass);
                }
                continue;
            }
            if (!(def instanceof JavacDef.JavacFunExprDef)) continue;
            LightRef.JavaLightClassRef javaLightClassRef = writer.asClassUsage(def.getDefinedElement());
            int id = funExprId++;
            LightRef.JavaLightFunExprDef result = new LightRef.JavaLightFunExprDef(id);
            definitions.put(result, null);
            ((Collection)ContainerUtil.getOrCreate(backwardHierarchyMap, (Object)javaLightClassRef, (Factory)new Factory<Collection<LightRef>>(){

                public Collection<LightRef> create() {
                    return new SmartList();
                }
            })).add(result);
        }
        HashMap<LightRef, Void> convertedRefs = new HashMap<LightRef, Void>(refs.size());
        for (JavacRef javacRef : refs) {
            LightRef key = writer.enumerateNames(javacRef);
            if (key == null) continue;
            convertedRefs.put(key, null);
        }
        writer.writeData(fileId, new CompiledFileData(backwardHierarchyMap, convertedRefs, definitions));
    }
}

