/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.backwardRefs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.InvertedIndex;
import com.intellij.util.indexing.impl.ForwardIndex;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.InputIndexDataExternalizer;
import com.intellij.util.indexing.impl.MapBasedForwardIndex;
import com.intellij.util.indexing.impl.MapIndexStorage;
import com.intellij.util.indexing.impl.MapReduceIndex;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.PersistentStringEnumerator;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.backwardRefs.LightRef;
import org.jetbrains.jps.backwardRefs.NameEnumerator;
import org.jetbrains.jps.backwardRefs.index.CompiledFileData;
import org.jetbrains.jps.backwardRefs.index.CompilerIndices;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;

public class CompilerBackwardReferenceIndex {
    private static final Logger LOG = Logger.getInstance(CompilerBackwardReferenceIndex.class);
    private static final String FILE_ENUM_TAB = "file.path.enum.tab";
    private static final String NAME_ENUM_TAB = "name.tab";
    private static final String VERSION_FILE = "version";
    private final Map<ID<?, ?>, InvertedIndex<?, ?, CompiledFileData>> myIndices;
    private final NameEnumerator myNameEnumerator;
    private final PersistentStringEnumerator myFilePathEnumerator;
    private final File myIndicesDir;
    private final LowMemoryWatcher myLowMemoryWatcher = LowMemoryWatcher.register((Runnable)new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            NameEnumerator nameEnumerator = CompilerBackwardReferenceIndex.this.myNameEnumerator;
            synchronized (nameEnumerator) {
                if (!CompilerBackwardReferenceIndex.this.myNameEnumerator.isClosed()) {
                    CompilerBackwardReferenceIndex.this.myNameEnumerator.force();
                }
            }
            nameEnumerator = CompilerBackwardReferenceIndex.this.myFilePathEnumerator;
            synchronized (nameEnumerator) {
                if (!CompilerBackwardReferenceIndex.this.myFilePathEnumerator.isClosed()) {
                    CompilerBackwardReferenceIndex.this.myFilePathEnumerator.force();
                }
            }
        }
    });
    private volatile boolean myRebuildRequired;

    public CompilerBackwardReferenceIndex(File buildDir) {
        this.myIndicesDir = CompilerBackwardReferenceIndex.getIndexDir(buildDir);
        if (!this.myIndicesDir.exists() && !this.myIndicesDir.mkdirs()) {
            throw new RuntimeException("Can't create dir: " + buildDir.getAbsolutePath());
        }
        try {
            if (CompilerBackwardReferenceIndex.versionDiffers(buildDir)) {
                this.saveVersion(buildDir);
            }
            this.myFilePathEnumerator = new PersistentStringEnumerator(new File(this.myIndicesDir, FILE_ENUM_TAB)){

                public int enumerate(@Nullable String value) throws IOException {
                    return super.enumerate(SystemInfo.isFileSystemCaseSensitive ? value : value.toLowerCase(Locale.ROOT));
                }
            };
            this.myIndices = new HashMap();
            for (IndexExtension<LightRef, ?, CompiledFileData> indexExtension : CompilerIndices.getIndices()) {
                this.myIndices.put((ID<?, ?>)indexExtension.getName(), (InvertedIndex<?, ?, CompiledFileData>)new CompilerMapReduceIndex(indexExtension, this.myIndicesDir));
            }
            this.myNameEnumerator = new NameEnumerator(new File(this.myIndicesDir, NAME_ENUM_TAB));
        }
        catch (IOException e) {
            CompilerBackwardReferenceIndex.removeIndexFiles(this.myIndicesDir);
            throw new BuildDataCorruptedException(e);
        }
    }

    Collection<InvertedIndex<?, ?, CompiledFileData>> getIndices() {
        return this.myIndices.values();
    }

    public <K, V> InvertedIndex<K, V, CompiledFileData> get(ID<K, V> key) {
        return this.myIndices.get(key);
    }

    @NotNull
    public NameEnumerator getByteSeqEum() {
        NameEnumerator nameEnumerator = this.myNameEnumerator;
        if (nameEnumerator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/backwardRefs/CompilerBackwardReferenceIndex", "getByteSeqEum"));
        }
        return nameEnumerator;
    }

    @NotNull
    public PersistentStringEnumerator getFilePathEnumerator() {
        PersistentStringEnumerator persistentStringEnumerator = this.myFilePathEnumerator;
        if (persistentStringEnumerator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/backwardRefs/CompilerBackwardReferenceIndex", "getFilePathEnumerator"));
        }
        return persistentStringEnumerator;
    }

    public void close() {
        this.myLowMemoryWatcher.stop();
        CommonProcessors.FindFirstProcessor exceptionProc = new CommonProcessors.FindFirstProcessor();
        CompilerBackwardReferenceIndex.close((Closeable)this.myFilePathEnumerator, (Processor<BuildDataCorruptedException>)exceptionProc);
        CompilerBackwardReferenceIndex.close((Closeable)((Object)this.myNameEnumerator), (Processor<BuildDataCorruptedException>)exceptionProc);
        for (InvertedIndex<?, ?, CompiledFileData> index : this.myIndices.values()) {
            CompilerBackwardReferenceIndex.close(index, (CommonProcessors.FindFirstProcessor<BuildDataCorruptedException>)exceptionProc);
        }
        BuildDataCorruptedException exception = (BuildDataCorruptedException)exceptionProc.getFoundValue();
        if (exception != null) {
            CompilerBackwardReferenceIndex.removeIndexFiles(this.myIndicesDir);
            throw exception;
        }
        if (this.myRebuildRequired) {
            CompilerBackwardReferenceIndex.removeIndexFiles(this.myIndicesDir);
        }
    }

    public static void removeIndexFiles(File buildDir) {
        File indexDir = CompilerBackwardReferenceIndex.getIndexDir(buildDir);
        if (indexDir.exists()) {
            FileUtil.delete((File)indexDir);
        }
    }

    private static File getIndexDir(@NotNull File buildDir) {
        if (buildDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildDir", "org/jetbrains/jps/backwardRefs/CompilerBackwardReferenceIndex", "getIndexDir"));
        }
        return new File(buildDir, "backward-refs");
    }

    public static boolean exist(@NotNull File buildDir) {
        if (buildDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildDir", "org/jetbrains/jps/backwardRefs/CompilerBackwardReferenceIndex", "exist"));
        }
        return CompilerBackwardReferenceIndex.getIndexDir(buildDir).exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean versionDiffers(@NotNull File buildDir) {
        boolean bl;
        if (buildDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildDir", "org/jetbrains/jps/backwardRefs/CompilerBackwardReferenceIndex", "versionDiffers"));
        }
        File versionFile = new File(CompilerBackwardReferenceIndex.getIndexDir(buildDir), VERSION_FILE);
        DataInputStream is = new DataInputStream(new FileInputStream(versionFile));
        try {
            bl = is.readInt() != 1;
        }
        catch (Throwable throwable) {
            try {
                is.close();
                throw throwable;
            }
            catch (IOException ex) {
                LOG.info((Throwable)ex);
                return true;
            }
        }
        is.close();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveVersion(@NotNull File buildDir) {
        if (buildDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildDir", "org/jetbrains/jps/backwardRefs/CompilerBackwardReferenceIndex", "saveVersion"));
        }
        File versionFile = new File(CompilerBackwardReferenceIndex.getIndexDir(buildDir), VERSION_FILE);
        try {
            FileUtil.createIfDoesntExist((File)versionFile);
            DataOutputStream os = new DataOutputStream(new FileOutputStream(versionFile));
            try {
                os.writeInt(1);
            }
            finally {
                os.close();
            }
        }
        catch (IOException ex) {
            LOG.error((Throwable)ex);
            throw new BuildDataCorruptedException(ex);
        }
    }

    private static void close(InvertedIndex<?, ?, CompiledFileData> index, CommonProcessors.FindFirstProcessor<BuildDataCorruptedException> exceptionProcessor) {
        try {
            index.dispose();
        }
        catch (BuildDataCorruptedException e) {
            exceptionProcessor.process((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void close(Closeable closeable, Processor<BuildDataCorruptedException> exceptionProcessor) {
        Closeable closeable2 = closeable;
        synchronized (closeable2) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                exceptionProcessor.process((Object)new BuildDataCorruptedException(e));
            }
        }
    }

    private static <Key, Value> IndexStorage<Key, Value> createIndexStorage(@NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer, @NotNull ID<Key, Value> indexId, @NotNull File indexDir) throws IOException {
        if (keyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyDescriptor", "org/jetbrains/jps/backwardRefs/CompilerBackwardReferenceIndex", "createIndexStorage"));
        }
        if (valueExternalizer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueExternalizer", "org/jetbrains/jps/backwardRefs/CompilerBackwardReferenceIndex", "createIndexStorage"));
        }
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexId", "org/jetbrains/jps/backwardRefs/CompilerBackwardReferenceIndex", "createIndexStorage"));
        }
        if (indexDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexDir", "org/jetbrains/jps/backwardRefs/CompilerBackwardReferenceIndex", "createIndexStorage"));
        }
        return new MapIndexStorage<Key, Value>(new File(indexDir, indexId.toString()), keyDescriptor, valueExternalizer, 16384, false){

            public void checkCanceled() {
            }
        };
    }

    class CompilerMapReduceIndex<Key, Value>
    extends MapReduceIndex<Key, Value, CompiledFileData> {
        public CompilerMapReduceIndex(final @NotNull IndexExtension<Key, Value, CompiledFileData> extension, final File indexDir) throws IOException {
            if (extension == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "org/jetbrains/jps/backwardRefs/CompilerBackwardReferenceIndex$CompilerMapReduceIndex", "<init>"));
            }
            if (indexDir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexDir", "org/jetbrains/jps/backwardRefs/CompilerBackwardReferenceIndex$CompilerMapReduceIndex", "<init>"));
            }
            super(extension, CompilerBackwardReferenceIndex.createIndexStorage(extension.getKeyDescriptor(), extension.getValueExternalizer(), extension.getName(), indexDir), (ForwardIndex)new MapBasedForwardIndex<Key, Value>(extension){

                @NotNull
                public PersistentHashMap<Integer, Collection<Key>> createMap() throws IOException {
                    ID id = extension.getName();
                    PersistentHashMap persistentHashMap = new PersistentHashMap(new File(indexDir, id + ".inputs"), (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)new InputIndexDataExternalizer(extension.getKeyDescriptor(), id));
                    if (persistentHashMap == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/backwardRefs/CompilerBackwardReferenceIndex$CompilerMapReduceIndex$1", "createMap"));
                    }
                    return persistentHashMap;
                }
            });
        }

        public void checkCanceled() {
        }

        protected void requestRebuild(Exception e) {
            CompilerBackwardReferenceIndex.this.myRebuildRequired = true;
            throw new BuildDataCorruptedException(e);
        }
    }
}

