/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.backwardRefs.index;

import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.VoidDataExternalizer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.backwardRefs.LightRef;
import org.jetbrains.jps.backwardRefs.LightRefDescriptor;
import org.jetbrains.jps.backwardRefs.index.CompiledFileData;

public class CompilerIndices {
    public static final int VERSION = 1;
    public static final ID<LightRef, Void> BACK_USAGES = ID.create((String)"back.refs");
    public static final ID<LightRef, Collection<LightRef>> BACK_HIERARCHY = ID.create((String)"back.hierarchy");
    public static final ID<LightRef, Void> BACK_CLASS_DEF = ID.create((String)"back.class.def");

    public static List<IndexExtension<LightRef, ?, CompiledFileData>> getIndices() {
        return ContainerUtil.list((Object[])new IndexExtension[]{CompilerIndices.createBackwardClassDefinitionExtension(), CompilerIndices.createBackwardUsagesExtension(), CompilerIndices.createBackwardHierarchyExtension()});
    }

    private static IndexExtension<LightRef, Void, CompiledFileData> createBackwardUsagesExtension() {
        return new IndexExtension<LightRef, Void, CompiledFileData>(){

            public int getVersion() {
                return 1;
            }

            @NotNull
            public ID<LightRef, Void> getName() {
                ID<LightRef, Void> iD = BACK_USAGES;
                if (iD == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/backwardRefs/index/CompilerIndices$1", "getName"));
                }
                return iD;
            }

            @NotNull
            public DataIndexer<LightRef, Void, CompiledFileData> getIndexer() {
                DataIndexer<LightRef, Void, CompiledFileData> dataIndexer = new DataIndexer<LightRef, Void, CompiledFileData>(){

                    @NotNull
                    public Map<LightRef, Void> map(@NotNull CompiledFileData inputData) {
                        if (inputData == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "org/jetbrains/jps/backwardRefs/index/CompilerIndices$1$1", "map"));
                        }
                        Map<LightRef, Void> map = inputData.getReferences();
                        if (map == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/backwardRefs/index/CompilerIndices$1$1", "map"));
                        }
                        return map;
                    }
                };
                if (dataIndexer == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/backwardRefs/index/CompilerIndices$1", "getIndexer"));
                }
                return dataIndexer;
            }

            @NotNull
            public KeyDescriptor<LightRef> getKeyDescriptor() {
                LightRefDescriptor lightRefDescriptor = LightRefDescriptor.INSTANCE;
                if (lightRefDescriptor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/backwardRefs/index/CompilerIndices$1", "getKeyDescriptor"));
                }
                return lightRefDescriptor;
            }

            @NotNull
            public DataExternalizer<Void> getValueExternalizer() {
                VoidDataExternalizer voidDataExternalizer = VoidDataExternalizer.INSTANCE;
                if (voidDataExternalizer == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/backwardRefs/index/CompilerIndices$1", "getValueExternalizer"));
                }
                return voidDataExternalizer;
            }
        };
    }

    private static IndexExtension<LightRef, Collection<LightRef>, CompiledFileData> createBackwardHierarchyExtension() {
        return new IndexExtension<LightRef, Collection<LightRef>, CompiledFileData>(){

            public int getVersion() {
                return 1;
            }

            @NotNull
            public ID<LightRef, Collection<LightRef>> getName() {
                ID<LightRef, Collection<LightRef>> iD = BACK_HIERARCHY;
                if (iD == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/backwardRefs/index/CompilerIndices$2", "getName"));
                }
                return iD;
            }

            @NotNull
            public DataIndexer<LightRef, Collection<LightRef>, CompiledFileData> getIndexer() {
                DataIndexer<LightRef, Collection<LightRef>, CompiledFileData> dataIndexer = new DataIndexer<LightRef, Collection<LightRef>, CompiledFileData>(){

                    @NotNull
                    public Map<LightRef, Collection<LightRef>> map(@NotNull CompiledFileData inputData) {
                        if (inputData == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "org/jetbrains/jps/backwardRefs/index/CompilerIndices$2$1", "map"));
                        }
                        Map<LightRef, Collection<LightRef>> map = inputData.getBackwardHierarchy();
                        if (map == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/backwardRefs/index/CompilerIndices$2$1", "map"));
                        }
                        return map;
                    }
                };
                if (dataIndexer == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/backwardRefs/index/CompilerIndices$2", "getIndexer"));
                }
                return dataIndexer;
            }

            @NotNull
            public KeyDescriptor<LightRef> getKeyDescriptor() {
                LightRefDescriptor lightRefDescriptor = LightRefDescriptor.INSTANCE;
                if (lightRefDescriptor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/backwardRefs/index/CompilerIndices$2", "getKeyDescriptor"));
                }
                return lightRefDescriptor;
            }

            @NotNull
            public DataExternalizer<Collection<LightRef>> getValueExternalizer() {
                DataExternalizer<Collection<LightRef>> dataExternalizer = new DataExternalizer<Collection<LightRef>>(){

                    public void save(final @NotNull DataOutput out, Collection<LightRef> value) throws IOException {
                        if (out == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "org/jetbrains/jps/backwardRefs/index/CompilerIndices$2$2", "save"));
                        }
                        DataInputOutputUtil.writeSeq((DataOutput)out, value, (ThrowableConsumer)new ThrowableConsumer<LightRef, IOException>(){

                            public void consume(LightRef lightRef) throws IOException {
                                LightRefDescriptor.INSTANCE.save(out, lightRef);
                            }
                        });
                    }

                    public Collection<LightRef> read(final @NotNull DataInput in) throws IOException {
                        if (in == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "org/jetbrains/jps/backwardRefs/index/CompilerIndices$2$2", "read"));
                        }
                        return DataInputOutputUtil.readSeq((DataInput)in, (ThrowableComputable)new ThrowableComputable<LightRef, IOException>(){

                            public LightRef compute() throws IOException {
                                return LightRefDescriptor.INSTANCE.read(in);
                            }
                        });
                    }
                };
                if (dataExternalizer == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/backwardRefs/index/CompilerIndices$2", "getValueExternalizer"));
                }
                return dataExternalizer;
            }
        };
    }

    private static IndexExtension<LightRef, Void, CompiledFileData> createBackwardClassDefinitionExtension() {
        return new IndexExtension<LightRef, Void, CompiledFileData>(){

            public int getVersion() {
                return 1;
            }

            @NotNull
            public ID<LightRef, Void> getName() {
                ID<LightRef, Void> iD = BACK_CLASS_DEF;
                if (iD == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/backwardRefs/index/CompilerIndices$3", "getName"));
                }
                return iD;
            }

            @NotNull
            public DataIndexer<LightRef, Void, CompiledFileData> getIndexer() {
                DataIndexer<LightRef, Void, CompiledFileData> dataIndexer = new DataIndexer<LightRef, Void, CompiledFileData>(){

                    @NotNull
                    public Map<LightRef, Void> map(@NotNull CompiledFileData inputData) {
                        if (inputData == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "org/jetbrains/jps/backwardRefs/index/CompilerIndices$3$1", "map"));
                        }
                        Map<LightRef, Void> map = inputData.getDefinitions();
                        if (map == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/backwardRefs/index/CompilerIndices$3$1", "map"));
                        }
                        return map;
                    }
                };
                if (dataIndexer == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/backwardRefs/index/CompilerIndices$3", "getIndexer"));
                }
                return dataIndexer;
            }

            @NotNull
            public KeyDescriptor<LightRef> getKeyDescriptor() {
                LightRefDescriptor lightRefDescriptor = LightRefDescriptor.INSTANCE;
                if (lightRefDescriptor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/backwardRefs/index/CompilerIndices$3", "getKeyDescriptor"));
                }
                return lightRefDescriptor;
            }

            @NotNull
            public DataExternalizer<Void> getValueExternalizer() {
                VoidDataExternalizer voidDataExternalizer = VoidDataExternalizer.INSTANCE;
                if (voidDataExternalizer == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/backwardRefs/index/CompilerIndices$3", "getValueExternalizer"));
                }
                return voidDataExternalizer;
            }
        };
    }
}

