/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.util.NamedJDOMExternalizable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.URLUtil;
import com.sun.jna.TypeMapper;
import com.sun.jna.platform.FileUtils;
import gnu.trove.THashSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Appender;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.xerces.util.SecurityManager;
import org.intellij.lang.annotations.Flow;
import org.iq80.snappy.Snappy;
import org.jdom.Document;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathManager {
    public static final String PROPERTIES_FILE = "idea.properties.file";
    public static final String PROPERTIES_FILE_NAME = "idea.properties";
    public static final String PROPERTY_HOME_PATH = "idea.home.path";
    public static final String PROPERTY_CONFIG_PATH = "idea.config.path";
    public static final String PROPERTY_SYSTEM_PATH = "idea.system.path";
    public static final String PROPERTY_SCRATCH_PATH = "idea.scratch.path";
    public static final String PROPERTY_PLUGINS_PATH = "idea.plugins.path";
    public static final String PROPERTY_LOG_PATH = "idea.log.path";
    public static final String PROPERTY_PATHS_SELECTOR = "idea.paths.selector";
    public static final String DEFAULT_OPTIONS_FILE_NAME = "other";
    private static final String PROPERTY_HOME = "idea.home";
    private static final String LIB_FOLDER = "lib";
    private static final String PLUGINS_FOLDER = "plugins";
    private static final String BIN_FOLDER = "bin";
    private static final String LOG_DIRECTORY = "log";
    private static final String CONFIG_FOLDER = "config";
    private static final String OPTIONS_FOLDER = "options";
    private static final String SYSTEM_FOLDER = "system";
    private static final String PATHS_SELECTOR = System.getProperty("idea.paths.selector");
    private static final Pattern PROPERTY_REF = Pattern.compile("\\$\\{(.+?)}");
    private static String ourHomePath;
    private static String ourConfigPath;
    private static String ourSystemPath;
    private static String ourScratchPath;
    private static String ourPluginsPath;
    private static String ourLogPath;

    @NotNull
    public static String getHomePath() {
        if (ourHomePath != null) {
            String string = ourHomePath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getHomePath"));
            }
            return string;
        }
        String fromProperty = System.getProperty(PROPERTY_HOME_PATH, System.getProperty(PROPERTY_HOME));
        if (fromProperty != null) {
            ourHomePath = PathManager.getAbsolutePath(fromProperty);
            if (!new File(ourHomePath).isDirectory()) {
                throw new RuntimeException("Invalid home path '" + ourHomePath + "'");
            }
        } else {
            ourHomePath = PathManager.getHomePathFor(PathManager.class);
            if (ourHomePath == null) {
                String advice = SystemInfo.isMac ? "reinstall the software." : "make sure bin/idea.properties is present in the installation directory.";
                throw new RuntimeException("Could not find installation home path. Please " + advice);
            }
        }
        if (SystemInfo.isWindows) {
            try {
                ourHomePath = new File(ourHomePath).getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        String string = ourHomePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getHomePath"));
        }
        return string;
    }

    @Nullable
    public static String getHomePathFor(@NotNull Class aClass) {
        String parent;
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/openapi/application/PathManager", "getHomePathFor"));
        }
        String rootPath = PathManager.getResourceRoot(aClass, "/" + aClass.getName().replace('.', '/') + ".class");
        if (rootPath == null) {
            return null;
        }
        File root = new File(rootPath).getAbsoluteFile();
        do {
            if ((parent = root.getParent()) != null) continue;
            return null;
        } while (!PathManager.isIdeaHome(root = new File(parent).getAbsoluteFile()));
        return root.getAbsolutePath();
    }

    private static boolean isIdeaHome(File root) {
        return new File(root, FileUtil.toSystemDependentName("bin/idea.properties")).exists() || new File(root, FileUtil.toSystemDependentName("bin/" + PathManager.getOSSpecificBinSubdir() + "/" + PROPERTIES_FILE_NAME)).exists() || new File(root, FileUtil.toSystemDependentName("community/bin/idea.properties")).exists();
    }

    @NotNull
    public static String getBinPath() {
        String string = PathManager.getHomePath() + File.separator + BIN_FOLDER;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getBinPath"));
        }
        return string;
    }

    private static String getOSSpecificBinSubdir() {
        if (SystemInfo.isWindows) {
            return "win";
        }
        if (SystemInfo.isMac) {
            return "mac";
        }
        return "linux";
    }

    @NotNull
    public static String getLibPath() {
        String string = PathManager.getHomePath() + File.separator + LIB_FOLDER;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getLibPath"));
        }
        return string;
    }

    @NotNull
    public static String getPreInstalledPluginsPath() {
        String string = PathManager.getHomePath() + File.separatorChar + PLUGINS_FOLDER;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getPreInstalledPluginsPath"));
        }
        return string;
    }

    @Nullable
    public static String getPathsSelector() {
        return PATHS_SELECTOR;
    }

    @NotNull
    public static String getConfigPath() {
        if (ourConfigPath != null) {
            String string = ourConfigPath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getConfigPath"));
            }
            return string;
        }
        ourConfigPath = System.getProperty(PROPERTY_CONFIG_PATH) != null ? PathManager.getAbsolutePath(PathManager.trimPathQuotes(System.getProperty(PROPERTY_CONFIG_PATH))) : (PATHS_SELECTOR != null ? PathManager.getDefaultConfigPathFor(PATHS_SELECTOR) : PathManager.getHomePath() + File.separator + CONFIG_FOLDER);
        String string = ourConfigPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getConfigPath"));
        }
        return string;
    }

    @NotNull
    public static String getScratchPath() {
        if (ourScratchPath != null) {
            String string = ourScratchPath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getScratchPath"));
            }
            return string;
        }
        ourScratchPath = System.getProperty(PROPERTY_SCRATCH_PATH) != null ? PathManager.getAbsolutePath(PathManager.trimPathQuotes(System.getProperty(PROPERTY_SCRATCH_PATH))) : PathManager.getConfigPath();
        String string = ourScratchPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getScratchPath"));
        }
        return string;
    }

    @NotNull
    public static String getDefaultConfigPathFor(@NotNull String selector) {
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "com/intellij/openapi/application/PathManager", "getDefaultConfigPathFor"));
        }
        String string = PathManager.platformPath(selector, "Library/Preferences", CONFIG_FOLDER);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getDefaultConfigPathFor"));
        }
        return string;
    }

    public static void ensureConfigFolderExists() {
        FileUtil.createDirectory(new File(PathManager.getConfigPath()));
    }

    @NotNull
    public static String getOptionsPath() {
        String string = PathManager.getConfigPath() + File.separator + OPTIONS_FOLDER;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getOptionsPath"));
        }
        return string;
    }

    @NotNull
    public static File getOptionsFile(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/application/PathManager", "getOptionsFile"));
        }
        File file = new File(PathManager.getOptionsPath(), fileName + ".xml");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getOptionsFile"));
        }
        return file;
    }

    @NotNull
    public static String getPluginsPath() {
        if (ourPluginsPath != null) {
            String string = ourPluginsPath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getPluginsPath"));
            }
            return string;
        }
        ourPluginsPath = System.getProperty(PROPERTY_PLUGINS_PATH) != null ? PathManager.getAbsolutePath(PathManager.trimPathQuotes(System.getProperty(PROPERTY_PLUGINS_PATH))) : (SystemInfo.isMac && PATHS_SELECTOR != null ? SystemProperties.getUserHome() + File.separator + "Library/Application Support" + File.separator + PATHS_SELECTOR : PathManager.getConfigPath() + File.separatorChar + PLUGINS_FOLDER);
        String string = ourPluginsPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getPluginsPath"));
        }
        return string;
    }

    @NotNull
    public static String getDefaultPluginPathFor(@NotNull String selector) {
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "com/intellij/openapi/application/PathManager", "getDefaultPluginPathFor"));
        }
        String string = PathManager.platformPath(selector, "Library/Application Support", PLUGINS_FOLDER);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getDefaultPluginPathFor"));
        }
        return string;
    }

    @Nullable
    public static String getCustomOptionsDirectory() {
        return PATHS_SELECTOR != null ? PathManager.platformPath(PATHS_SELECTOR, "Library/Preferences", "") : null;
    }

    @NotNull
    public static String getSystemPath() {
        if (ourSystemPath != null) {
            String string = ourSystemPath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getSystemPath"));
            }
            return string;
        }
        ourSystemPath = System.getProperty(PROPERTY_SYSTEM_PATH) != null ? PathManager.getAbsolutePath(PathManager.trimPathQuotes(System.getProperty(PROPERTY_SYSTEM_PATH))) : (PATHS_SELECTOR != null ? PathManager.platformPath(PATHS_SELECTOR, "Library/Caches", SYSTEM_FOLDER) : PathManager.getHomePath() + File.separator + SYSTEM_FOLDER);
        FileUtil.createDirectory(new File(ourSystemPath));
        String string = ourSystemPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getSystemPath"));
        }
        return string;
    }

    @NotNull
    public static String getTempPath() {
        String string = PathManager.getSystemPath() + File.separator + "tmp";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getTempPath"));
        }
        return string;
    }

    @NotNull
    public static File getIndexRoot() {
        File indexRoot = new File(System.getProperty("index_root_path", PathManager.getSystemPath() + "/index"));
        FileUtil.createDirectory(indexRoot);
        File file = indexRoot;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getIndexRoot"));
        }
        return file;
    }

    @NotNull
    public static String getLogPath() {
        if (ourLogPath != null) {
            String string = ourLogPath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getLogPath"));
            }
            return string;
        }
        ourLogPath = System.getProperty(PROPERTY_LOG_PATH) != null ? PathManager.getAbsolutePath(PathManager.trimPathQuotes(System.getProperty(PROPERTY_LOG_PATH))) : (SystemInfo.isMac && PATHS_SELECTOR != null ? SystemProperties.getUserHome() + File.separator + "Library/Logs" + File.separator + PATHS_SELECTOR : PathManager.getSystemPath() + File.separatorChar + LOG_DIRECTORY);
        String string = ourLogPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getLogPath"));
        }
        return string;
    }

    @NotNull
    public static String getPluginTempPath() {
        String string = PathManager.getSystemPath() + File.separator + PLUGINS_FOLDER;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getPluginTempPath"));
        }
        return string;
    }

    @Nullable
    public static String getResourceRoot(@NotNull Class context, String path) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/application/PathManager", "getResourceRoot"));
        }
        URL url = context.getResource(path);
        if (url == null) {
            url = ClassLoader.getSystemResource(path.substring(1));
        }
        return url != null ? PathManager.extractRoot(url, path) : null;
    }

    @Nullable
    private static String extractRoot(URL resourceURL, String resourcePath) {
        Pair<String, String> paths;
        if (!StringUtil.startsWithChar(resourcePath, '/') && !StringUtil.startsWithChar(resourcePath, '\\')) {
            PathManager.log("precondition failed: " + resourcePath);
            return null;
        }
        String resultPath = null;
        String protocol = resourceURL.getProtocol();
        if ("file".equals(protocol)) {
            String testResourcePath;
            String path = URLUtil.urlToFile(resourceURL).getPath();
            String testPath = path.replace('\\', '/');
            if (StringUtil.endsWithIgnoreCase(testPath, testResourcePath = resourcePath.replace('\\', '/'))) {
                resultPath = path.substring(0, path.length() - resourcePath.length());
            }
        } else if ("jar".equals(protocol) && (paths = URLUtil.splitJarUrl(resourceURL.getFile())) != null) {
            resultPath = (String)paths.first;
        }
        if (resultPath == null) {
            PathManager.log("cannot extract: " + resourcePath + " from " + resourceURL);
            return null;
        }
        return StringUtil.trimEnd(resultPath, File.separator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadProperties() {
        String[] propFiles;
        for (String path : propFiles = new String[]{System.getProperty(PROPERTIES_FILE), PathManager.getCustomPropertiesFile(), SystemProperties.getUserHome() + "/" + PROPERTIES_FILE_NAME, PathManager.getHomePath() + "/bin/" + PROPERTIES_FILE_NAME, PathManager.getHomePath() + "/bin/" + PathManager.getOSSpecificBinSubdir() + "/" + PROPERTIES_FILE_NAME, PathManager.getHomePath() + "/community/bin/" + PROPERTIES_FILE_NAME}) {
            File propFile;
            if (path == null || !(propFile = new File(path)).exists()) continue;
            try {
                BufferedReader fis = new BufferedReader(new FileReader(propFile));
                try {
                    Map<String, String> properties = FileUtil.loadProperties(fis);
                    Properties sysProperties = System.getProperties();
                    for (String key : properties.keySet()) {
                        if (PROPERTY_HOME_PATH.equals(key) || PROPERTY_HOME.equals(key)) {
                            PathManager.log(propFile.getPath() + ": '" + PROPERTY_HOME_PATH + "' and '" + PROPERTY_HOME + "' properties cannot be redefined");
                            continue;
                        }
                        if (sysProperties.getProperty(key, null) != null) {
                            PathManager.log(propFile.getPath() + ": '" + key + "' already defined");
                            continue;
                        }
                        String value = PathManager.substituteVars(properties.get(key));
                        sysProperties.setProperty(key, value);
                    }
                }
                finally {
                    ((Reader)fis).close();
                }
            }
            catch (IOException e) {
                PathManager.log("Problem reading from property file: " + propFile.getPath());
            }
        }
    }

    public static void patchProperties() {
        if (SystemProperties.isTrueSmoothScrollingEnabled()) {
            System.setProperty("swing.bufferPerWindow", "true");
        }
    }

    private static String getCustomPropertiesFile() {
        String configPath = PathManager.getCustomOptionsDirectory();
        return configPath != null ? configPath + File.separator + PROPERTIES_FILE_NAME : null;
    }

    @Contract(value="null -> null")
    public static String substituteVars(String s) {
        return PathManager.substituteVars(s, PathManager.getHomePath());
    }

    @Contract(value="null, _ -> null")
    public static String substituteVars(String s, String ideaHomePath) {
        if (s == null) {
            return null;
        }
        if (s.startsWith("..")) {
            s = ideaHomePath + File.separatorChar + BIN_FOLDER + File.separatorChar + s;
        }
        Matcher m = PROPERTY_REF.matcher(s);
        while (m.find()) {
            String key = m.group(1);
            String value = System.getProperty(key);
            if (value == null) {
                if (PROPERTY_HOME_PATH.equals(key) || PROPERTY_HOME.equals(key)) {
                    value = ideaHomePath;
                } else if (PROPERTY_CONFIG_PATH.equals(key)) {
                    value = PathManager.getConfigPath();
                } else if (PROPERTY_SYSTEM_PATH.equals(key)) {
                    value = PathManager.getSystemPath();
                }
            }
            if (value == null) {
                PathManager.log("Unknown property: " + key);
                value = "";
            }
            s = StringUtil.replace(s, m.group(), value);
            m = PROPERTY_REF.matcher(s);
        }
        return s;
    }

    @NotNull
    public static File findFileInLibDirectory(@NotNull String relativePath) {
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/intellij/openapi/application/PathManager", "findFileInLibDirectory"));
        }
        File file = new File(PathManager.getLibPath() + File.separator + relativePath);
        File file2 = file.exists() ? file : new File(PathManager.getHomePath(), "community" + File.separator + LIB_FOLDER + File.separator + relativePath);
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "findFileInLibDirectory"));
        }
        return file2;
    }

    @Nullable
    public static String getJarPathForClass(@NotNull Class aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/openapi/application/PathManager", "getJarPathForClass"));
        }
        String resourceRoot = PathManager.getResourceRoot(aClass, "/" + aClass.getName().replace('.', '/') + ".class");
        return resourceRoot != null ? new File(resourceRoot).getAbsolutePath() : null;
    }

    @NotNull
    public static Collection<String> getUtilClassPath() {
        String resourceRoot;
        File notNullRoot;
        Class[] classes = new Class[]{PathManager.class, Flow.class, SystemInfoRt.class, Document.class, Appender.class, THashSet.class, TypeMapper.class, FileUtils.class, PatternMatcher.class, Snappy.class, SecurityManager.class};
        HashSet<String> classPath = new HashSet<String>();
        for (Class aClass : classes) {
            String path = PathManager.getJarPathForClass(aClass);
            if (path == null) continue;
            classPath.add(path);
        }
        String annotationsRoot = PathManager.getJarPathForClass(Flow.class);
        if (annotationsRoot != null && !annotationsRoot.endsWith(".jar") && (notNullRoot = new File(new File(annotationsRoot).getParentFile(), "annotations")).exists()) {
            classPath.add(notNullRoot.getAbsolutePath());
        }
        if ((resourceRoot = PathManager.getResourceRoot(PathManager.class, "/messages/CommonBundle.properties")) != null) {
            classPath.add(new File(resourceRoot).getAbsolutePath());
        }
        Collection<String> collection = Collections.unmodifiableCollection(classPath);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PathManager", "getUtilClassPath"));
        }
        return collection;
    }

    private static void log(String x) {
        System.err.println(x);
    }

    public static String getAbsolutePath(String path) {
        path = FileUtil.expandUserHome(path);
        return FileUtil.toCanonicalPath(new File(path).getAbsolutePath());
    }

    private static String trimPathQuotes(String path) {
        if (path != null && path.length() >= 3 && StringUtil.startsWithChar(path, '\"') && StringUtil.endsWithChar(path, '\"')) {
            path = path.substring(1, path.length() - 1);
        }
        return path;
    }

    private static String platformPath(@NotNull String selector, @Nullable String macPart, @NotNull String fallback) {
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "com/intellij/openapi/application/PathManager", "platformPath"));
        }
        if (fallback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fallback", "com/intellij/openapi/application/PathManager", "platformPath"));
        }
        return PathManager.platformPath(selector, macPart, null, null, null, fallback);
    }

    private static String platformPath(@NotNull String selector, @Nullable String macPart, @Nullable String winVar, @Nullable String xdgVar, @Nullable String xdgDir, @NotNull String fallback) {
        String dir;
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "com/intellij/openapi/application/PathManager", "platformPath"));
        }
        if (fallback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fallback", "com/intellij/openapi/application/PathManager", "platformPath"));
        }
        if (macPart != null && SystemInfo.isMac) {
            return SystemProperties.getUserHome() + File.separator + macPart + File.separator + selector;
        }
        if (winVar != null && SystemInfo.isWindows && (dir = System.getenv(winVar)) != null) {
            return dir + File.separator + selector;
        }
        if (xdgVar != null && xdgDir != null && SystemInfo.hasXdgOpen()) {
            dir = System.getenv(xdgVar);
            if (dir == null) {
                dir = SystemProperties.getUserHome() + File.separator + xdgDir;
            }
            return dir + File.separator + selector;
        }
        return SystemProperties.getUserHome() + File.separator + "." + selector + (!fallback.isEmpty() ? File.separator + fallback : "");
    }

    public static File getOptionsFile(@NotNull NamedJDOMExternalizable externalizable) {
        if (externalizable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalizable", "com/intellij/openapi/application/PathManager", "getOptionsFile"));
        }
        return PathManager.getOptionsFile(externalizable.getExternalFileName());
    }
}

