/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.execution.process.UnixProcessManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.ArrayUtil;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.FixedFuture;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseOutputReader;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnvironmentUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.EnvironmentUtil");
    private static final int SHELL_ENV_READING_TIMEOUT = 20000;
    private static final String LANG = "LANG";
    private static final String LC_ALL = "LC_ALL";
    private static final String LC_CTYPE = "LC_CTYPE";
    private static final Future<Map<String, String>> ourEnvGetter = SystemInfo.isMac && "unlocked".equals(System.getProperty("__idea.mac.env.lock")) && Registry.is("idea.fix.mac.env") ? AppExecutorUtil.getAppExecutorService().submit(new Callable<Map<String, String>>(){

        @Override
        public Map<String, String> call() throws Exception {
            return Collections.unmodifiableMap(EnvironmentUtil.setCharsetVar(EnvironmentUtil.getShellEnv()));
        }
    }) : new FixedFuture<Map<String, String>>(EnvironmentUtil.getSystemEnv());
    private static final NotNullLazyValue<Map<String, String>> ourEnvironment = new AtomicNotNullLazyValue<Map<String, String>>(){

        @Override
        @NotNull
        protected Map<String, String> compute() {
            Map map;
            try {
                map = (Map)ourEnvGetter.get();
            }
            catch (Throwable t) {
                LOG.warn("can't get shell environment", t);
                Map map2 = EnvironmentUtil.getSystemEnv();
                if (map2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/EnvironmentUtil$2", "compute"));
                }
                return map2;
            }
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/EnvironmentUtil$2", "compute"));
            }
            return map;
        }
    };
    private static final String DISABLE_OMZ_AUTO_UPDATE = "DISABLE_AUTO_UPDATE";

    private static Map<String, String> getSystemEnv() {
        if (SystemInfo.isWindows) {
            return Collections.unmodifiableMap(new THashMap(System.getenv(), (TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE));
        }
        return System.getenv();
    }

    private EnvironmentUtil() {
    }

    public static boolean isEnvironmentReady() {
        return ourEnvGetter.isDone();
    }

    @NotNull
    public static Map<String, String> getEnvironmentMap() {
        Map<String, String> map = ourEnvironment.getValue();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/EnvironmentUtil", "getEnvironmentMap"));
        }
        return map;
    }

    @Nullable
    public static String getValue(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/EnvironmentUtil", "getValue"));
        }
        return EnvironmentUtil.getEnvironmentMap().get(name);
    }

    public static String[] getEnvironment() {
        return EnvironmentUtil.flattenEnvironment(EnvironmentUtil.getEnvironmentMap());
    }

    public static String[] flattenEnvironment(@NotNull Map<String, String> environment) {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/util/EnvironmentUtil", "flattenEnvironment"));
        }
        String[] array = new String[environment.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : environment.entrySet()) {
            array[i++] = entry.getKey() + "=" + entry.getValue();
        }
        return array;
    }

    private static Map<String, String> getShellEnv() throws Exception {
        return new ShellEnvReader().readShellEnv();
    }

    @NotNull
    private static Map<String, String> parseEnv(String text, String lineSeparator) throws Exception {
        String[] lines;
        HashSet<String> toIgnore = new HashSet<String>(Arrays.asList("_", "PWD", "SHLVL", DISABLE_OMZ_AUTO_UPDATE));
        Map<String, String> env = System.getenv();
        HashMap<String, String> newEnv = new HashMap<String, String>();
        for (String line : lines = text.split(lineSeparator)) {
            int pos = line.indexOf(61);
            if (pos <= 0) {
                throw new Exception("malformed:" + line);
            }
            String name = line.substring(0, pos);
            if (!toIgnore.contains(name)) {
                newEnv.put(name, line.substring(pos + 1));
                continue;
            }
            if (!env.containsKey(name)) continue;
            newEnv.put(name, env.get(name));
        }
        LOG.info("shell environment loaded (" + newEnv.size() + " vars)");
        HashMap<String, String> hashMap = newEnv;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/EnvironmentUtil", "parseEnv"));
        }
        return hashMap;
    }

    private static int waitAndTerminateAfter(@NotNull Process process, int timeoutMillis) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/util/EnvironmentUtil", "waitAndTerminateAfter"));
        }
        Integer exitCode = EnvironmentUtil.waitFor(process, timeoutMillis);
        if (exitCode != null) {
            return exitCode;
        }
        LOG.warn("shell env loader is timed out");
        UnixProcessManager.sendSigIntToProcessTree(process);
        exitCode = EnvironmentUtil.waitFor(process, 1000);
        if (exitCode != null) {
            return exitCode;
        }
        LOG.warn("failed to terminate shell env loader process gracefully, terminating forcibly");
        UnixProcessManager.sendSigKillToProcessTree(process);
        exitCode = EnvironmentUtil.waitFor(process, 1000);
        if (exitCode != null) {
            return exitCode;
        }
        LOG.warn("failed to kill shell env loader");
        return -1;
    }

    @Nullable
    private static Integer waitFor(@NotNull Process process, int timeoutMillis) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/util/EnvironmentUtil", "waitFor"));
        }
        long stop = System.currentTimeMillis() + (long)timeoutMillis;
        while (System.currentTimeMillis() < stop) {
            TimeoutUtil.sleep(100L);
            try {
                return process.exitValue();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
            }
        }
        return null;
    }

    private static Map<String, String> setCharsetVar(@NotNull Map<String, String> env) {
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/util/EnvironmentUtil", "setCharsetVar"));
        }
        if (!EnvironmentUtil.isCharsetVarDefined(env)) {
            Locale locale = Locale.getDefault();
            Charset charset = CharsetToolkit.getDefaultSystemCharset();
            String language = locale.getLanguage();
            String country = locale.getCountry();
            String value = (language.isEmpty() || country.isEmpty() ? "en_US" : language + '_' + country) + '.' + charset.name();
            env.put(LC_CTYPE, value);
            LOG.info("LC_CTYPE=" + value);
        }
        return env;
    }

    private static boolean isCharsetVarDefined(@NotNull Map<String, String> env) {
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/util/EnvironmentUtil", "isCharsetVarDefined"));
        }
        return !env.isEmpty() && (env.containsKey(LANG) || env.containsKey(LC_ALL) || env.containsKey(LC_CTYPE));
    }

    public static void inlineParentOccurrences(@NotNull Map<String, String> envs) {
        if (envs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "envs", "com/intellij/util/EnvironmentUtil", "inlineParentOccurrences"));
        }
        HashMap<String, String> parentParams = new HashMap<String, String>(System.getenv());
        for (Map.Entry<String, String> entry : envs.entrySet()) {
            String parentVal;
            String key = entry.getKey();
            String value = entry.getValue();
            if (value == null || (parentVal = (String)parentParams.get(key)) == null || !EnvironmentUtil.containsEnvKeySubstitution(key, value)) continue;
            envs.put(key, value.replace("$" + key + "$", parentVal));
        }
    }

    private static boolean containsEnvKeySubstitution(String envKey, String val) {
        return ArrayUtil.find(val.split(File.pathSeparator), "$" + envKey + "$") != -1;
    }

    static Map<String, String> testLoader() {
        try {
            return EnvironmentUtil.getShellEnv();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static Map<String, String> testParser(@NotNull String lines) {
        if (lines == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines", "com/intellij/util/EnvironmentUtil", "testParser"));
        }
        try {
            return EnvironmentUtil.parseEnv(lines, "\u0000");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class StreamGobbler
    extends BaseOutputReader {
        private static final BaseOutputReader.Options OPTIONS = new BaseOutputReader.Options(){

            @Override
            public BaseDataReader.SleepingPolicy policy() {
                return BaseDataReader.SleepingPolicy.BLOCKING;
            }

            @Override
            public boolean splitToLines() {
                return false;
            }
        };
        private final StringBuffer myBuffer;

        public StreamGobbler(@NotNull InputStream stream) {
            if (stream == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/util/EnvironmentUtil$StreamGobbler", "<init>"));
            }
            super(stream, CharsetToolkit.getDefaultSystemCharset(), OPTIONS);
            this.myBuffer = new StringBuffer();
            this.start("stdout/stderr streams of shell env loading process");
        }

        @Override
        @NotNull
        protected Future<?> executeOnPooledThread(@NotNull Runnable runnable) {
            if (runnable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/util/EnvironmentUtil$StreamGobbler", "executeOnPooledThread"));
            }
            Future<?> future = AppExecutorUtil.getAppExecutorService().submit(runnable);
            if (future == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/EnvironmentUtil$StreamGobbler", "executeOnPooledThread"));
            }
            return future;
        }

        @Override
        protected void onTextAvailable(@NotNull String text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/util/EnvironmentUtil$StreamGobbler", "onTextAvailable"));
            }
            this.myBuffer.append(text);
        }

        @NotNull
        public String getText() {
            String string = this.myBuffer.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/EnvironmentUtil$StreamGobbler", "getText"));
            }
            return string;
        }
    }

    public static class ShellEnvReader {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<String, String> readShellEnv() throws Exception {
            String os = SystemInfo.isLinux ? "linux" : "mac";
            File reader = FileUtil.findFirstThatExist(PathManager.getBinPath() + "/printenv.py", PathManager.getHomePath() + "/ultimate/community/bin/" + os + "/printenv.py", PathManager.getHomePath() + "/community/bin/" + os + "/printenv.py", PathManager.getHomePath() + "/bin/" + os + "/printenv.py");
            if (reader == null) {
                throw new Exception("bin:" + PathManager.getBinPath());
            }
            File envFile = FileUtil.createTempFile("intellij-shell-env.", ".tmp", false);
            try {
                List<String> command = this.getShellProcessCommand();
                int idx = command.indexOf("-c");
                if (idx >= 0) {
                    command.set(idx + 1, command.get(idx + 1) + ";'" + reader.getAbsolutePath() + "' '" + envFile.getAbsolutePath() + "'");
                } else {
                    command.add("-c");
                    command.add("'" + reader.getAbsolutePath() + "' '" + envFile.getAbsolutePath() + "'");
                }
                LOG.info("loading shell env: " + StringUtil.join(command, " "));
                Map<String, String> map = ShellEnvReader.runProcessAndReadEnvs(command, envFile, "\u0000");
                return map;
            }
            finally {
                FileUtil.delete(envFile);
            }
        }

        @NotNull
        protected static Map<String, String> runProcessAndReadEnvs(@NotNull List<String> command, @NotNull File envFile, String lineSeparator) throws Exception {
            if (command == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/util/EnvironmentUtil$ShellEnvReader", "runProcessAndReadEnvs"));
            }
            if (envFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "envFile", "com/intellij/util/EnvironmentUtil$ShellEnvReader", "runProcessAndReadEnvs"));
            }
            ProcessBuilder builder = new ProcessBuilder(command).redirectErrorStream(true);
            builder.environment().put(EnvironmentUtil.DISABLE_OMZ_AUTO_UPDATE, "true");
            Process process = builder.start();
            StreamGobbler gobbler = new StreamGobbler(process.getInputStream());
            int rv = EnvironmentUtil.waitAndTerminateAfter(process, 20000);
            gobbler.stop();
            String lines = FileUtil.loadFile(envFile);
            if (rv != 0 || lines.isEmpty()) {
                throw new Exception("rv:" + rv + " text:" + lines.length() + " out:" + StringUtil.trimEnd(gobbler.getText(), '\n'));
            }
            Map map = EnvironmentUtil.parseEnv(lines, lineSeparator);
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/EnvironmentUtil$ShellEnvReader", "runProcessAndReadEnvs"));
            }
            return map;
        }

        protected List<String> getShellProcessCommand() throws Exception {
            String shell = this.getShell();
            if (shell == null || !new File(shell).canExecute()) {
                throw new Exception("shell:" + shell);
            }
            return new ArrayList<String>(Arrays.asList(shell, "-l", "-i"));
        }

        @Nullable
        protected String getShell() throws Exception {
            return System.getenv("SHELL");
        }
    }
}

