/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java.dependencyView;

import com.intellij.openapi.util.Ref;
import com.intellij.util.Processor;
import com.intellij.util.containers.SLRUCache;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntObjectProcedure;
import gnu.trove.TIntProcedure;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.java.dependencyView.IntIntMultiMaplet;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;

public class IntIntPersistentMultiMaplet
extends IntIntMultiMaplet {
    private static final TIntHashSet NULL_COLLECTION = new TIntHashSet();
    private static final int CACHE_SIZE = 128;
    private final PersistentHashMap<Integer, TIntHashSet> myMap;
    private final SLRUCache<Integer, TIntHashSet> myCache;

    public IntIntPersistentMultiMaplet(File file, KeyDescriptor<Integer> keyExternalizer) throws IOException {
        this.myMap = new PersistentHashMap(file, keyExternalizer, (DataExternalizer)new IntSetExternalizer());
        this.myCache = new SLRUCache<Integer, TIntHashSet>(128, 128){

            @NotNull
            public TIntHashSet createValue(Integer key) {
                TIntHashSet tIntHashSet;
                try {
                    TIntHashSet collection = (TIntHashSet)IntIntPersistentMultiMaplet.this.myMap.get((Object)key);
                    tIntHashSet = collection == null ? NULL_COLLECTION : collection;
                }
                catch (IOException e) {
                    throw new BuildDataCorruptedException(e);
                }
                if (tIntHashSet == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/java/dependencyView/IntIntPersistentMultiMaplet$1", "createValue"));
                }
                return tIntHashSet;
            }
        };
    }

    @Override
    public boolean containsKey(int key) {
        try {
            return this.myMap.containsMapping((Object)key);
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public TIntHashSet get(int key) {
        TIntHashSet collection = (TIntHashSet)this.myCache.get((Object)key);
        return collection == NULL_COLLECTION ? null : collection;
    }

    @Override
    public void replace(int key, TIntHashSet value) {
        try {
            this.myCache.remove((Object)key);
            if (value == null || value.isEmpty()) {
                this.myMap.remove((Object)key);
            } else {
                this.myMap.put((Object)key, (Object)value);
            }
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void put(int key, final TIntHashSet value) {
        try {
            this.myCache.remove((Object)key);
            this.myMap.appendData((Object)key, new PersistentHashMap.ValueDataAppender(){

                public void append(final DataOutput out) throws IOException {
                    final Ref exRef = new Ref();
                    value.forEach(new TIntProcedure(){

                        public boolean execute(int value) {
                            try {
                                DataInputOutputUtil.writeINT((DataOutput)out, (int)value);
                            }
                            catch (IOException e) {
                                exRef.set((Object)e);
                                return false;
                            }
                            return true;
                        }
                    });
                    IOException exception = (IOException)exRef.get();
                    if (exception != null) {
                        throw exception;
                    }
                }
            });
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void put(int key, final int value) {
        try {
            this.myCache.remove((Object)key);
            this.myMap.appendData((Object)key, new PersistentHashMap.ValueDataAppender(){

                public void append(DataOutput out) throws IOException {
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)value);
                }
            });
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void removeAll(int key, TIntHashSet values) {
        try {
            TIntHashSet collection = (TIntHashSet)this.myCache.get((Object)key);
            if (collection != NULL_COLLECTION && collection.removeAll(values.toArray())) {
                this.myCache.remove((Object)key);
                if (collection.isEmpty()) {
                    this.myMap.remove((Object)key);
                } else {
                    this.myMap.put((Object)key, (Object)collection);
                }
            }
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void removeFrom(int key, int value) {
        try {
            TIntHashSet collection = (TIntHashSet)this.myCache.get((Object)key);
            if (collection != NULL_COLLECTION && collection.remove(value)) {
                this.myCache.remove((Object)key);
                if (collection.isEmpty()) {
                    this.myMap.remove((Object)key);
                } else {
                    this.myMap.put((Object)key, (Object)collection);
                }
            }
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void remove(int key) {
        try {
            this.myCache.remove((Object)key);
            this.myMap.remove((Object)key);
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void putAll(IntIntMultiMaplet m) {
        m.forEachEntry(new TIntObjectProcedure<TIntHashSet>(){

            public boolean execute(int key, TIntHashSet value) {
                IntIntPersistentMultiMaplet.this.put(key, value);
                return true;
            }
        });
    }

    @Override
    public void replaceAll(IntIntMultiMaplet m) {
        m.forEachEntry(new TIntObjectProcedure<TIntHashSet>(){

            public boolean execute(int key, TIntHashSet value) {
                IntIntPersistentMultiMaplet.this.replace(key, value);
                return true;
            }
        });
    }

    @Override
    public void close() {
        try {
            this.myCache.clear();
            this.myMap.close();
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void flush(boolean memoryCachesOnly) {
        if (memoryCachesOnly) {
            if (this.myMap.isDirty()) {
                this.myMap.dropMemoryCaches();
            }
        } else {
            this.myMap.force();
        }
    }

    @Override
    public void forEachEntry(final TIntObjectProcedure<TIntHashSet> procedure) {
        try {
            this.myMap.processKeysWithExistingMapping((Processor)new Processor<Integer>(){

                public boolean process(Integer key) {
                    try {
                        return procedure.execute(key.intValue(), IntIntPersistentMultiMaplet.this.myMap.get((Object)key));
                    }
                    catch (IOException e) {
                        throw new BuildDataCorruptedException(e);
                    }
                }
            });
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    private static class IntSetExternalizer
    implements DataExternalizer<TIntHashSet> {
        private IntSetExternalizer() {
        }

        public void save(final @NotNull DataOutput out, TIntHashSet value) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "org/jetbrains/jps/builders/java/dependencyView/IntIntPersistentMultiMaplet$IntSetExternalizer", "save"));
            }
            final Ref exRef = new Ref(null);
            value.forEach(new TIntProcedure(){

                public boolean execute(int elem) {
                    try {
                        DataInputOutputUtil.writeINT((DataOutput)out, (int)elem);
                    }
                    catch (IOException e) {
                        exRef.set((Object)e);
                        return false;
                    }
                    return true;
                }
            });
            IOException exception = (IOException)exRef.get();
            if (exception != null) {
                throw exception;
            }
        }

        public TIntHashSet read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "org/jetbrains/jps/builders/java/dependencyView/IntIntPersistentMultiMaplet$IntSetExternalizer", "read"));
            }
            TIntHashSet result = new TIntHashSet();
            DataInputStream stream = (DataInputStream)in;
            while (stream.available() > 0) {
                result.add(DataInputOutputUtil.readINT((DataInput)in));
            }
            return result;
        }
    }
}

