/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.backwardRefs;

import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.backwardRefs.BackwardReferenceIndexWriter;
import org.jetbrains.jps.builders.BuildTargetIndex;
import org.jetbrains.jps.builders.BuildTargetRegistry;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.ModuleBasedTarget;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.incremental.BuilderCategory;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.java.JavaBuilder;
import org.jetbrains.jps.incremental.messages.CustomBuilderMessage;
import org.jetbrains.jps.model.module.JpsModule;

public class BackwardReferenceIndexBuilder
extends ModuleLevelBuilder {
    public static final String BUILDER_ID = "compiler.ref.index";
    private static final String MESSAGE_TYPE = "processed module";
    private final Set<ModuleBuildTarget> myCompiledTargets = ContainerUtil.newConcurrentSet();

    public BackwardReferenceIndexBuilder() {
        super(BuilderCategory.CLASS_POST_PROCESSOR);
    }

    @Override
    @NotNull
    public String getPresentableName() {
        if ("backward-references indexer" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/backwardRefs/BackwardReferenceIndexBuilder", "getPresentableName"));
        }
        return "backward-references indexer";
    }

    @Override
    public void buildStarted(CompileContext context) {
        BackwardReferenceIndexWriter.initialize(context);
    }

    @Override
    public void buildFinished(CompileContext context) {
        if (((Boolean)JavaBuilder.IS_ENABLED.get((UserDataHolder)context, (Object)Boolean.TRUE)).booleanValue()) {
            BuildTargetIndex targetIndex = context.getProjectDescriptor().getBuildTargetIndex();
            for (JpsModule module : context.getProjectDescriptor().getProject().getModules()) {
                boolean allAreDummyOrCompiled = true;
                for (ModuleBasedTarget<?> target : targetIndex.getModuleBasedTargets(module, BuildTargetRegistry.ModuleTargetSelector.ALL)) {
                    if (!(target instanceof ModuleBuildTarget) || this.myCompiledTargets.contains(target) || targetIndex.isDummy(target)) continue;
                    allAreDummyOrCompiled = false;
                }
                if (!allAreDummyOrCompiled) continue;
                context.processMessage(new CustomBuilderMessage(BUILDER_ID, MESSAGE_TYPE, module.getName()));
            }
            this.myCompiledTargets.clear();
        }
        BackwardReferenceIndexWriter.closeIfNeed();
    }

    @Override
    public List<String> getCompilableFileExtensions() {
        return Collections.emptyList();
    }

    @Override
    public ModuleLevelBuilder.ExitCode build(CompileContext context, ModuleChunk chunk, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, ModuleLevelBuilder.OutputConsumer outputConsumer) throws ProjectBuildException, IOException {
        BackwardReferenceIndexWriter writer;
        if (dirtyFilesHolder.hasRemovedFiles() && (writer = BackwardReferenceIndexWriter.getInstance()) != null) {
            for (ModuleBuildTarget target : chunk.getTargets()) {
                Collection<String> files = dirtyFilesHolder.getRemovedFiles(target);
                writer.processDeletedFiles(files);
            }
        }
        if (((Boolean)JavaBuilder.IS_ENABLED.get((UserDataHolder)context, (Object)Boolean.TRUE)).booleanValue()) {
            for (ModuleBuildTarget target : chunk.getTargets()) {
                if (!context.getScope().isWholeTargetAffected(target)) continue;
                this.myCompiledTargets.add(target);
            }
        }
        return null;
    }
}

