/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class Queue<T> {
    private Object[] myArray;
    private int myFirst;
    private int myLast;
    private boolean isWrapped;

    public Queue(int initialCapacity) {
        this.myArray = initialCapacity > 0 ? new Object[initialCapacity] : ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public void addLast(T object) {
        int currentSize = this.size();
        if (currentSize == this.myArray.length) {
            this.myArray = this.normalize(Math.max(currentSize * 2, 5));
            this.myFirst = 0;
            this.myLast = currentSize;
            this.isWrapped = false;
        }
        this.myArray[this.myLast] = object;
        ++this.myLast;
        if (this.myLast == this.myArray.length) {
            this.isWrapped = !this.isWrapped;
            this.myLast = 0;
        }
    }

    public T removeLast() {
        if (this.myLast == 0) {
            this.isWrapped = !this.isWrapped;
            this.myLast = this.myArray.length;
        }
        --this.myLast;
        Object result = this.myArray[this.myLast];
        this.myArray[this.myLast] = null;
        return (T)result;
    }

    public T peekLast() {
        int last = this.myLast;
        if (last == 0) {
            last = this.myArray.length;
        }
        Object result = this.myArray[last - 1];
        return (T)result;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        return this.isWrapped ? this.myArray.length - this.myFirst + this.myLast : this.myLast - this.myFirst;
    }

    @NotNull
    public List<T> toList() {
        List<T> list = Arrays.asList(this.normalize(this.size()));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/Queue", "toList"));
        }
        return list;
    }

    @NotNull
    public Object[] toArray() {
        Object[] objectArray = this.normalize(this.size());
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/Queue", "toArray"));
        }
        return objectArray;
    }

    @NotNull
    public T[] toArray(T[] array) {
        if (array.length < this.size()) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), this.size());
        }
        T[] TArray = this.normalize(array);
        if (TArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/Queue", "toArray"));
        }
        return TArray;
    }

    public T pullFirst() {
        T result = this.peekFirst();
        this.myArray[this.myFirst] = null;
        ++this.myFirst;
        if (this.myFirst == this.myArray.length) {
            this.myFirst = 0;
            this.isWrapped = !this.isWrapped;
        }
        return result;
    }

    public T peekFirst() {
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException("queue is empty");
        }
        Object t = this.myArray[this.myFirst];
        return (T)t;
    }

    private int copyFromTo(int first, int last, Object[] result, int destinationPos) {
        int length = last - first;
        System.arraycopy(this.myArray, first, result, destinationPos, length);
        return length;
    }

    @NotNull
    private T[] normalize(int capacity) {
        Object[] result = new Object[capacity];
        Object[] objectArray = this.normalize(result);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/Queue", "normalize"));
        }
        return objectArray;
    }

    private T[] normalize(T[] result) {
        if (this.isWrapped) {
            int tailLength = this.copyFromTo(this.myFirst, this.myArray.length, result, 0);
            this.copyFromTo(0, this.myLast, result, tailLength);
        } else {
            this.copyFromTo(this.myFirst, this.myLast, result, 0);
        }
        return result;
    }

    public void clear() {
        Arrays.fill(this.myArray, null);
        this.myLast = 0;
        this.myFirst = 0;
        this.isWrapped = false;
    }

    public T set(int index, T value) {
        int arrayIndex = this.myFirst + index;
        if (this.isWrapped && arrayIndex >= this.myArray.length) {
            arrayIndex -= this.myArray.length;
        }
        Object old = this.myArray[arrayIndex];
        this.myArray[arrayIndex] = value;
        Object t = old;
        return (T)t;
    }

    public boolean process(@NotNull Processor<T> processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/util/containers/Queue", "process"));
        }
        if (this.isWrapped) {
            Object t;
            int i;
            for (i = this.myFirst; i < this.myArray.length; ++i) {
                t = this.myArray[i];
                if (processor.process(t)) continue;
                return false;
            }
            for (i = 0; i < this.myLast; ++i) {
                t = this.myArray[i];
                if (processor.process(t)) continue;
                return false;
            }
        } else {
            for (int i = this.myFirst; i < this.myLast; ++i) {
                Object t = this.myArray[i];
                if (processor.process(t)) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "<empty>";
        }
        return this.isWrapped ? "[ " + this.sub(this.myFirst, this.myArray.length) + " ||| " + this.sub(0, this.myLast) + " ]" : "[ " + this.sub(this.myFirst, this.myLast) + " ]";
    }

    private Object sub(int start, int end) {
        if (start == end) {
            return "";
        }
        return Arrays.asList(this.myArray).subList(start, end);
    }
}

