/*
 * Decompiled with CFR 0.152.
 */
package biz.aQute.resolve;

import aQute.bnd.osgi.resource.CapReqBuilder;
import aQute.bnd.osgi.resource.FilterParser;
import aQute.bnd.osgi.resource.ResourceUtils;
import aQute.lib.converter.Converter;
import biz.aQute.resolve.AbstractResolveContext;
import biz.aQute.resolve.BndResolver;
import biz.aQute.resolve.ResolverLogger;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;
import org.osgi.service.repository.Repository;

public class DebugReporter {
    PrintStream out;
    private AbstractResolveContext context;
    private int level;
    static FilterParser fp = new FilterParser();

    DebugReporter(PrintStream out, AbstractResolveContext context, int level) {
        this.out = out;
        this.context = context;
        this.level = level;
    }

    void report() {
        this.doRepos();
        this.doBlackList();
        this.doSystemResource();
        this.doAllMembers();
    }

    private void doAllMembers() {
        this.header("RESOURCES");
        Requirement r = CapReqBuilder.createBundleRequirement((String)"*", null).buildSyntheticRequirement();
        List<Capability> providers = this.context.findProviders(r);
        Set resources = ResourceUtils.getResources(providers);
        for (Resource resource : resources) {
            this.resource(resource);
        }
        this.resource(this.context.getSystemResource());
        this.nl();
    }

    private void doSystemResource() {
        this.header("SYSTEM RESOURCE");
        this.resource(this.context.getSystemResource());
        this.nl();
    }

    private void doRepos() {
        this.header("OSGi REPOSITORIES");
        for (Repository repo : this.context.getRepositories()) {
            this.out.printf("%s%n", repo.toString());
        }
        this.nl();
    }

    private void doBlackList() {
        this.header("BLACKLISTED RESOURCES");
        for (Resource r : this.context.getBlackList()) {
            this.resource(r);
        }
        this.nl();
    }

    private void nl() {
        this.out.println();
    }

    private void resource(Resource r) {
        String s;
        ResourceUtils.IdentityCapability id = ResourceUtils.getIdentityCapability((Resource)r);
        String resolveError = null;
        if (!this.context.isSystemResource(r) && this.level >= 3 && id != null) {
            try {
                String v = id.version() == null ? null : id.version().toString();
                Requirement req = CapReqBuilder.createBundleRequirement((String)id.osgi_identity(), (String)v).buildSyntheticRequirement();
                this.context.setInputRequirements(req);
                BndResolver resolver = new BndResolver(new ResolverLogger(4));
                Map<Resource, List<Wire>> resolved = resolver.resolve(this.context);
            }
            catch (Exception e) {
                resolveError = e.toString();
            }
        }
        String string = s = resolveError == null ? " " : "!";
        if (id == null) {
            this.out.printf("%s %s%n", s, r);
        } else {
            this.out.printf("%s %-50s %-20s %s%n", s, id.osgi_identity(), this.noNull(id.version()), id.description(""));
        }
        if (this.level >= 2) {
            for (Capability c : r.getCapabilities(null)) {
                this.capability("   ", c);
            }
            for (Requirement rq : r.getRequirements(null)) {
                this.requirement("  ", rq);
            }
        }
    }

    private void capability(String prefix, Capability c) {
        HashMap attributes = new HashMap(c.getAttributes());
        String name = (String)attributes.remove(c.getNamespace());
        String ns = c.getNamespace();
        switch (c.getNamespace()) {
            case "osgi.identity": {
                ns = "ID";
                break;
            }
            case "osgi.wiring.package": {
                ns = "E-P";
                break;
            }
            case "osgi.wiring.bundle": {
                ns = "R-B";
                break;
            }
            case "osgi.content": {
                ns = "Content";
                break;
            }
            case "osgi.service": {
                ns = "Service";
                try {
                    name = Converter.cnv(String.class, attributes.remove("objectClass"));
                    break;
                }
                catch (Exception e) {
                    name = attributes.remove("objectClass") + "";
                }
            }
        }
        this.out.printf("%sc: %-16s %-60s %s || %s%n", prefix, ns, name, attributes, c.getDirectives());
    }

    private void requirement(String prefix, Requirement c) {
        HashMap directives = new HashMap(c.getDirectives());
        String namespace = c.getNamespace();
        String filter = (String)directives.remove("filter");
        if (filter != null) {
            filter = fp.parse(filter).toString();
            this.out.printf("%sr: %-20s %s || %s%n", prefix, filter, c.getAttributes(), c.getDirectives());
        } else {
            this.out.printf("%sr: %-20s %s || %s%n", prefix, namespace, c.getAttributes(), directives);
        }
    }

    private String noNull(Object v) {
        if (v != null) {
            return v.toString();
        }
        return "";
    }

    public void header(String name) {
        this.hr();
        this.out.printf("%s%n", name);
        this.hr();
        this.out.println();
    }

    public void hr() {
        this.out.println("-------------------------------------------");
    }
}

