/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.android.AndroidJpsProjectUtil;
import org.jetbrains.jps.builders.AdditionalRootsProviderService;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.ModuleBuildTarget;

public class AndroidAdditionalRootProviderService
extends AdditionalRootsProviderService<JavaSourceRootDescriptor> {
    public AndroidAdditionalRootProviderService() {
        super(Collections.singletonList(JavaModuleBuildTargetType.PRODUCTION));
    }

    @NotNull
    public List<JavaSourceRootDescriptor> getAdditionalRoots(@NotNull BuildTarget<JavaSourceRootDescriptor> target, BuildDataPaths dataPaths) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/jps/android/AndroidAdditionalRootProviderService", "getAdditionalRoots"));
        }
        ModuleBuildTarget buildTarget = (ModuleBuildTarget)target;
        File generatedSourcesRoot = AndroidJpsProjectUtil.getGeneratedSourcesStorage(buildTarget.getModule(), dataPaths);
        ArrayList<JavaSourceRootDescriptor> result = new ArrayList<JavaSourceRootDescriptor>();
        AndroidAdditionalRootProviderService.addRoot(result, buildTarget, new File(generatedSourcesRoot, "aapt"));
        AndroidAdditionalRootProviderService.addRoot(result, buildTarget, new File(generatedSourcesRoot, "aidl"));
        AndroidAdditionalRootProviderService.addRoot(result, buildTarget, new File(generatedSourcesRoot, "rs"));
        AndroidAdditionalRootProviderService.addRoot(result, buildTarget, new File(generatedSourcesRoot, "build_config"));
        AndroidAdditionalRootProviderService.addRoot(result, buildTarget, AndroidJpsProjectUtil.getCopiedSourcesStorage(buildTarget.getModule(), dataPaths));
        ArrayList<JavaSourceRootDescriptor> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/AndroidAdditionalRootProviderService", "getAdditionalRoots"));
        }
        return arrayList;
    }

    private static void addRoot(List<JavaSourceRootDescriptor> result, ModuleBuildTarget buildTarget, File file) {
        result.add(new JavaSourceRootDescriptor(file, buildTarget, true, false, "", Collections.emptySet()));
    }
}

