/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetIndex;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.java.JavaCompilingTool;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.builders.java.dependencyView.Callbacks;
import org.jetbrains.jps.builders.java.dependencyView.Mappings;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.CompileScope;
import org.jetbrains.jps.incremental.FSOperations;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.StopBuildException;
import org.jetbrains.jps.incremental.Utils;
import org.jetbrains.jps.incremental.fs.CompilationRound;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.jps.model.JpsDummyElement;
import org.jetbrains.jps.model.java.JpsJavaSdkType;
import org.jetbrains.jps.model.library.JpsTypedLibrary;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.library.sdk.JpsSdkReference;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.service.JpsServiceManager;

public class JavaBuilderUtil {
    public static final Key<Callbacks.ConstantAffectionResolver> CONSTANT_SEARCH_SERVICE = Key.create((String)"_constant_search_service_");
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.incremental.Builder");
    private static final Key<Set<File>> ALL_AFFECTED_FILES_KEY = Key.create((String)"_all_affected_files_");
    private static final Key<Set<File>> ALL_COMPILED_FILES_KEY = Key.create((String)"_all_compiled_files_");
    private static final Key<Set<File>> FILES_TO_COMPILE_KEY = Key.create((String)"_files_to_compile_");
    private static final Key<Set<File>> COMPILED_WITH_ERRORS_KEY = Key.create((String)"_compiled_with_errors_");
    private static final Key<Set<File>> SUCCESSFULLY_COMPILED_FILES_KEY = Key.create((String)"_successfully_compiled_files_");
    private static final Key<List<FileFilter>> SKIP_MARKING_DIRTY_FILTERS_KEY = Key.create((String)"_skip_marking_dirty_filters_");
    private static final Key<Pair<Mappings, Callbacks.Backend>> MAPPINGS_DELTA_KEY = Key.create((String)"_mappings_delta_");

    public static void registerFileToCompile(CompileContext context, File file) {
        JavaBuilderUtil.registerFilesToCompile(context, Collections.singleton(file));
    }

    public static void registerFilesToCompile(CompileContext context, Collection<File> files) {
        JavaBuilderUtil.getFilesContainer(context, FILES_TO_COMPILE_KEY).addAll(files);
    }

    public static void registerFilesWithErrors(CompileContext context, Collection<File> files) {
        JavaBuilderUtil.getFilesContainer(context, COMPILED_WITH_ERRORS_KEY).addAll(files);
    }

    public static void registerSuccessfullyCompiled(CompileContext context, File file) {
        JavaBuilderUtil.registerSuccessfullyCompiled(context, Collections.singleton(file));
    }

    public static void registerSuccessfullyCompiled(CompileContext context, Collection<File> files) {
        JavaBuilderUtil.getFilesContainer(context, SUCCESSFULLY_COMPILED_FILES_KEY).addAll(files);
    }

    public static void registerFilterToSkipMarkingAffectedFileDirty(@NotNull CompileContext context, @NotNull FileFilter filter) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jps/builders/java/JavaBuilderUtil", "registerFilterToSkipMarkingAffectedFileDirty"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "org/jetbrains/jps/builders/java/JavaBuilderUtil", "registerFilterToSkipMarkingAffectedFileDirty"));
        }
        ArrayList<FileFilter> filters = (ArrayList<FileFilter>)SKIP_MARKING_DIRTY_FILTERS_KEY.get((UserDataHolder)context);
        if (filters == null) {
            filters = new ArrayList<FileFilter>();
            SKIP_MARKING_DIRTY_FILTERS_KEY.set((UserDataHolder)context, filters);
        }
        filters.add(filter);
    }

    @NotNull
    public static Callbacks.Backend getDependenciesRegistrar(CompileContext context) {
        Pair pair = (Pair)MAPPINGS_DELTA_KEY.get((UserDataHolder)context);
        if (pair == null) {
            Mappings delta = context.getProjectDescriptor().dataManager.getMappings().createDelta();
            pair = Pair.create((Object)delta, (Object)delta.getCallback());
            MAPPINGS_DELTA_KEY.set((UserDataHolder)context, (Object)pair);
        }
        Callbacks.Backend backend = (Callbacks.Backend)pair.second;
        if (backend == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/java/JavaBuilderUtil", "getDependenciesRegistrar"));
        }
        return backend;
    }

    public static boolean updateMappingsOnRoundCompletion(CompileContext context, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, ModuleChunk chunk) throws IOException {
        Mappings delta = null;
        Pair pair = (Pair)MAPPINGS_DELTA_KEY.get((UserDataHolder)context);
        if (pair != null) {
            MAPPINGS_DELTA_KEY.set((UserDataHolder)context, null);
            delta = (Mappings)pair.getFirst();
        }
        if (delta == null) {
            return false;
        }
        Set<File> compiledFiles = JavaBuilderUtil.getFilesContainer(context, FILES_TO_COMPILE_KEY);
        FILES_TO_COMPILE_KEY.set((UserDataHolder)context, null);
        Set<File> successfullyCompiled = JavaBuilderUtil.getFilesContainer(context, SUCCESSFULLY_COMPILED_FILES_KEY);
        SUCCESSFULLY_COMPILED_FILES_KEY.set((UserDataHolder)context, null);
        FileFilter filter = JavaBuilderUtil.createOrFilter((List)SKIP_MARKING_DIRTY_FILTERS_KEY.get((UserDataHolder)context));
        SKIP_MARKING_DIRTY_FILTERS_KEY.set((UserDataHolder)context, null);
        return JavaBuilderUtil.updateMappings(context, delta, dirtyFilesHolder, chunk, compiledFiles, successfullyCompiled, CompilationRound.NEXT, filter);
    }

    public static boolean updateMappings(CompileContext context, Mappings delta, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, ModuleChunk chunk, Collection<File> filesToCompile, Collection<File> successfullyCompiled) throws IOException {
        return JavaBuilderUtil.updateMappings(context, delta, dirtyFilesHolder, chunk, filesToCompile, successfullyCompiled, CompilationRound.NEXT, null);
    }

    public static void markDirtyDependenciesForInitialRound(CompileContext context, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dfh, ModuleChunk chunk) throws IOException {
        if (JavaBuilderUtil.hasRemovedPaths(chunk, dfh)) {
            Mappings delta = context.getProjectDescriptor().dataManager.getMappings().createDelta();
            Set<File> empty = Collections.emptySet();
            JavaBuilderUtil.updateMappings(context, delta, dfh, chunk, empty, empty, CompilationRound.CURRENT, null);
        }
    }

    private static boolean updateMappings(CompileContext context, Mappings delta, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, ModuleChunk chunk, Collection<File> filesToCompile, Collection<File> successfullyCompiled, CompilationRound markDirtyRound, @Nullable FileFilter skipMarkingDirtyFilter) throws IOException {
        try {
            boolean performIntegrate = true;
            boolean additionalPassRequired = false;
            Set<String> removedPaths = JavaBuilderUtil.getRemovedPaths(chunk, dirtyFilesHolder);
            Mappings globalMappings = context.getProjectDescriptor().dataManager.getMappings();
            boolean errorsDetected = Utils.errorsDetected(context);
            if (!JavaBuilderUtil.isForcedRecompilationAllJavaModules(context)) {
                if (context.shouldDifferentiate(chunk)) {
                    context.processMessage(new ProgressMessage("Checking dependencies... [" + chunk.getPresentableShortName() + "]"));
                    Set<File> allCompiledFiles = JavaBuilderUtil.getFilesContainer(context, ALL_COMPILED_FILES_KEY);
                    Set<File> allAffectedFiles = JavaBuilderUtil.getFilesContainer(context, ALL_AFFECTED_FILES_KEY);
                    allAffectedFiles.addAll(filesToCompile);
                    allCompiledFiles.addAll(successfullyCompiled);
                    allAffectedFiles.removeAll(successfullyCompiled);
                    THashSet affectedBeforeDif = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
                    affectedBeforeDif.addAll(allAffectedFiles);
                    Set<File> compiledWithErrors = JavaBuilderUtil.getFilesContainer(context, COMPILED_WITH_ERRORS_KEY);
                    COMPILED_WITH_ERRORS_KEY.set((UserDataHolder)context, null);
                    ModulesBasedFileFilter moduleBasedFilter = new ModulesBasedFileFilter(context, chunk);
                    boolean incremental = globalMappings.differentiateOnIncrementalMake(delta, removedPaths, filesToCompile, compiledWithErrors, allCompiledFiles, allAffectedFiles, moduleBasedFilter, (Callbacks.ConstantAffectionResolver)CONSTANT_SEARCH_SERVICE.get((UserDataHolder)context));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Differentiate Results:");
                        LOG.debug("   Compiled Files:");
                        for (File c : allCompiledFiles) {
                            LOG.debug("      " + c.getAbsolutePath());
                        }
                        LOG.debug("   Affected Files:");
                        for (File c : allAffectedFiles) {
                            LOG.debug("      " + c.getAbsolutePath());
                        }
                        LOG.debug("End Of Differentiate Results.");
                    }
                    if (incremental) {
                        HashSet<File> newlyAffectedFiles = new HashSet<File>(allAffectedFiles);
                        newlyAffectedFiles.removeAll((Collection<?>)affectedBeforeDif);
                        String infoMessage = "Dependency analysis found " + newlyAffectedFiles.size() + " affected files";
                        LOG.info(infoMessage);
                        context.processMessage(new ProgressMessage(infoMessage));
                        JavaBuilderUtil.removeFilesAcceptedByFilter(newlyAffectedFiles, skipMarkingDirtyFilter);
                        if (!newlyAffectedFiles.isEmpty()) {
                            if (LOG.isDebugEnabled()) {
                                for (File file : newlyAffectedFiles) {
                                    LOG.debug("affected file: " + file.getPath());
                                }
                                List<Pair<File, JpsModule>> wrongFiles = JavaBuilderUtil.checkAffectedFilesInCorrectModules(context, newlyAffectedFiles, moduleBasedFilter);
                                if (!wrongFiles.isEmpty()) {
                                    LOG.debug("Wrong affected files for module chunk " + chunk.getName() + ": ");
                                    for (Pair pair : wrongFiles) {
                                        String name = pair.second != null ? ((JpsModule)pair.second).getName() : "null";
                                        LOG.debug("\t[" + name + "] " + ((File)pair.first).getPath());
                                    }
                                }
                            }
                            for (File file : newlyAffectedFiles) {
                                FSOperations.markDirtyIfNotDeleted(context, markDirtyRound, file);
                            }
                            additionalPassRequired = JavaBuilderUtil.isCompileJavaIncrementally(context) && JavaBuilderUtil.chunkContainsAffectedFiles(context, chunk, newlyAffectedFiles);
                        }
                    } else {
                        String messageText = "Marking " + chunk.getPresentableShortName() + " and direct dependants for recompilation";
                        LOG.info("Non-incremental mode: " + messageText);
                        context.processMessage(new ProgressMessage(messageText));
                        boolean alreadyMarkedDirty = FSOperations.isMarkedDirty(context, chunk);
                        boolean bl = additionalPassRequired = JavaBuilderUtil.isCompileJavaIncrementally(context) && !alreadyMarkedDirty;
                        if (alreadyMarkedDirty) {
                            globalMappings.differentiateOnNonIncrementalMake(delta, removedPaths, filesToCompile);
                        } else {
                            performIntegrate = false;
                        }
                        NegationFileFilter toBeMarkedFilter = skipMarkingDirtyFilter == null ? null : new NegationFileFilter(skipMarkingDirtyFilter);
                        FSOperations.markDirtyRecursively(context, markDirtyRound, chunk, toBeMarkedFilter);
                    }
                } else if (!errorsDetected) {
                    globalMappings.differentiateOnNonIncrementalMake(delta, removedPaths, filesToCompile);
                }
            } else if (!errorsDetected) {
                globalMappings.differentiateOnRebuild(delta);
            }
            if (errorsDetected) {
                boolean bl = false;
                return bl;
            }
            if (performIntegrate) {
                context.processMessage(new ProgressMessage("Updating dependency information... [" + chunk.getPresentableShortName() + "]"));
                globalMappings.integrate(delta);
            }
            boolean bl = additionalPassRequired;
            return bl;
        }
        catch (BuildDataCorruptedException e) {
            throw e.getCause();
        }
        finally {
            context.processMessage(new ProgressMessage(""));
        }
    }

    private static FileFilter createOrFilter(final List<FileFilter> filters) {
        if (filters == null || filters.isEmpty()) {
            return null;
        }
        return new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                for (FileFilter filter : filters) {
                    if (!filter.accept(pathname)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private static void removeFilesAcceptedByFilter(@NotNull Set<File> files, @Nullable FileFilter filter) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/jps/builders/java/JavaBuilderUtil", "removeFilesAcceptedByFilter"));
        }
        if (filter == null) {
            return;
        }
        Iterator<File> iterator = files.iterator();
        while (iterator.hasNext()) {
            File next = iterator.next();
            if (!filter.accept(next)) continue;
            iterator.remove();
        }
    }

    public static boolean isForcedRecompilationAllJavaModules(CompileContext context) {
        CompileScope scope = context.getScope();
        return scope.isBuildForcedForAllTargets(JavaModuleBuildTargetType.PRODUCTION) && scope.isBuildForcedForAllTargets(JavaModuleBuildTargetType.TEST);
    }

    public static boolean isCompileJavaIncrementally(CompileContext context) {
        CompileScope scope = context.getScope();
        return scope.isBuildIncrementally(JavaModuleBuildTargetType.PRODUCTION) || scope.isBuildIncrementally(JavaModuleBuildTargetType.TEST);
    }

    private static List<Pair<File, JpsModule>> checkAffectedFilesInCorrectModules(CompileContext context, Collection<File> affected, ModulesBasedFileFilter moduleBasedFilter) {
        if (affected.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Pair<File, JpsModule>> result = new ArrayList<Pair<File, JpsModule>>();
        for (File file : affected) {
            if (moduleBasedFilter.accept(file)) continue;
            JavaSourceRootDescriptor moduleAndRoot = context.getProjectDescriptor().getBuildRootIndex().findJavaRootDescriptor(context, file);
            result.add((Pair<File, JpsModule>)Pair.create((Object)file, moduleAndRoot != null ? moduleAndRoot.target.getModule() : null));
        }
        return result;
    }

    private static boolean chunkContainsAffectedFiles(CompileContext context, ModuleChunk chunk, Set<File> affected) throws IOException {
        Set<JpsModule> chunkModules = chunk.getModules();
        if (!chunkModules.isEmpty()) {
            for (File file : affected) {
                JavaSourceRootDescriptor moduleAndRoot = context.getProjectDescriptor().getBuildRootIndex().findJavaRootDescriptor(context, file);
                if (moduleAndRoot == null || !chunkModules.contains(moduleAndRoot.target.getModule())) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    private static Set<File> getFilesContainer(CompileContext context, Key<Set<File>> dataKey) {
        Set files = (Set)dataKey.get((UserDataHolder)context);
        if (files == null) {
            files = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
            dataKey.set((UserDataHolder)context, (Object)files);
        }
        Set set = files;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/java/JavaBuilderUtil", "getFilesContainer"));
        }
        return set;
    }

    private static Set<String> getRemovedPaths(ModuleChunk chunk, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder) {
        if (!dirtyFilesHolder.hasRemovedFiles()) {
            return Collections.emptySet();
        }
        THashSet removed = new THashSet(FileUtil.PATH_HASHING_STRATEGY);
        for (ModuleBuildTarget target : chunk.getTargets()) {
            removed.addAll(dirtyFilesHolder.getRemovedFiles(target));
        }
        return removed;
    }

    private static boolean hasRemovedPaths(ModuleChunk chunk, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder) {
        if (dirtyFilesHolder.hasRemovedFiles()) {
            for (ModuleBuildTarget target : chunk.getTargets()) {
                if (dirtyFilesHolder.getRemovedFiles(target).isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public static void cleanupChunkResources(CompileContext context) {
        ALL_AFFECTED_FILES_KEY.set((UserDataHolder)context, null);
        ALL_COMPILED_FILES_KEY.set((UserDataHolder)context, null);
    }

    @NotNull
    public static JpsSdk<JpsDummyElement> ensureModuleHasJdk(JpsModule module, CompileContext context, String compilerName) throws ProjectBuildException {
        JpsSdkReference reference = module.getSdkReference((JpsSdkType)JpsJavaSdkType.INSTANCE);
        if (reference == null) {
            context.processMessage(new CompilerMessage(compilerName, BuildMessage.Kind.ERROR, "JDK isn't specified for module '" + module.getName() + "'"));
            throw new StopBuildException();
        }
        JpsTypedLibrary sdkLibrary = (JpsTypedLibrary)reference.resolve();
        if (sdkLibrary == null) {
            context.processMessage(new CompilerMessage(compilerName, BuildMessage.Kind.ERROR, "Cannot find JDK '" + reference.getSdkName() + "' for module '" + module.getName() + "'"));
            throw new StopBuildException();
        }
        JpsSdk jpsSdk = (JpsSdk)sdkLibrary.getProperties();
        if (jpsSdk == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/java/JavaBuilderUtil", "ensureModuleHasJdk"));
        }
        return jpsSdk;
    }

    @Nullable
    public static JavaCompilingTool findCompilingTool(@NotNull String compilerId) {
        if (compilerId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilerId", "org/jetbrains/jps/builders/java/JavaBuilderUtil", "findCompilingTool"));
        }
        for (JavaCompilingTool tool : JpsServiceManager.getInstance().getExtensions(JavaCompilingTool.class)) {
            if (!compilerId.equals(tool.getId()) && !compilerId.equals(tool.getAlternativeId())) continue;
            return tool;
        }
        return null;
    }

    private static class NegationFileFilter
    implements FileFilter {
        private final FileFilter myFilter;

        public NegationFileFilter(FileFilter filter) {
            this.myFilter = filter;
        }

        @Override
        public boolean accept(File pathname) {
            return !this.myFilter.accept(pathname);
        }
    }

    private static class ModulesBasedFileFilter
    implements Mappings.DependentFilesFilter {
        private final CompileContext myContext;
        private final Set<? extends BuildTarget<?>> myChunkTargets;
        private final Map<BuildTarget<?>, Set<BuildTarget<?>>> myCache = new HashMap();
        private final BuildRootIndex myBuildRootIndex;
        private final BuildTargetIndex myBuildTargetIndex;

        private ModulesBasedFileFilter(CompileContext context, ModuleChunk chunk) {
            this.myContext = context;
            this.myChunkTargets = chunk.getTargets();
            this.myBuildRootIndex = context.getProjectDescriptor().getBuildRootIndex();
            this.myBuildTargetIndex = context.getProjectDescriptor().getBuildTargetIndex();
        }

        @Override
        public boolean accept(File file) {
            JavaSourceRootDescriptor rd = this.myBuildRootIndex.findJavaRootDescriptor(this.myContext, file);
            if (rd == null) {
                return true;
            }
            ModuleBuildTarget targetOfFile = rd.target;
            if (this.myChunkTargets.contains(targetOfFile)) {
                return true;
            }
            Set<BuildTarget<?>> targetOfFileWithDependencies = this.myCache.get(targetOfFile);
            if (targetOfFileWithDependencies == null) {
                targetOfFileWithDependencies = this.myBuildTargetIndex.getDependenciesRecursively(targetOfFile, this.myContext);
                this.myCache.put(targetOfFile, targetOfFileWithDependencies);
            }
            return ContainerUtil.intersects(targetOfFileWithDependencies, this.myChunkTargets);
        }

        @Override
        public boolean belongsToCurrentTargetChunk(File file) {
            JavaSourceRootDescriptor rd = this.myBuildRootIndex.findJavaRootDescriptor(this.myContext, file);
            return rd != null && this.myChunkTargets.contains(rd.target);
        }
    }
}

