/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.impl;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsCompositeElement;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.JpsElementCollection;
import org.jetbrains.jps.model.JpsElementReference;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.JpsNamedElement;
import org.jetbrains.jps.model.ex.JpsCompositeElementBase;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;

public abstract class JpsNamedElementReferenceBase<S extends JpsNamedElement, T extends JpsNamedElement, Self extends JpsNamedElementReferenceBase<S, T, Self>>
extends JpsCompositeElementBase<Self>
implements JpsElementReference<T> {
    private static final JpsElementChildRole<JpsElementReference<? extends JpsCompositeElement>> PARENT_REFERENCE_ROLE = JpsElementChildRoleBase.create("parent");
    protected final String myElementName;

    protected JpsNamedElementReferenceBase(@NotNull String elementName, @NotNull JpsElementReference<? extends JpsCompositeElement> parentReference) {
        if (elementName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementName", "org/jetbrains/jps/model/impl/JpsNamedElementReferenceBase", "<init>"));
        }
        if (parentReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentReference", "org/jetbrains/jps/model/impl/JpsNamedElementReferenceBase", "<init>"));
        }
        this.myElementName = elementName;
        this.myContainer.setChild(PARENT_REFERENCE_ROLE, parentReference);
    }

    protected JpsNamedElementReferenceBase(JpsNamedElementReferenceBase<S, T, Self> original) {
        super(original);
        this.myElementName = original.myElementName;
    }

    @Override
    public T resolve() {
        JpsCompositeElement parent = this.getParentReference().resolve();
        if (parent == null) {
            return null;
        }
        JpsElementCollection<S> collection = this.getCollection(parent);
        if (collection == null) {
            return null;
        }
        List<S> elements = collection.getElements();
        for (JpsNamedElement element : elements) {
            T resolved;
            if (!element.getName().equals(this.myElementName) || (resolved = this.resolve(element)) == null) continue;
            return resolved;
        }
        return null;
    }

    @Nullable
    protected abstract JpsElementCollection<? extends S> getCollection(@NotNull JpsCompositeElement var1);

    @Nullable
    protected abstract T resolve(S var1);

    public JpsElementReference<? extends JpsCompositeElement> getParentReference() {
        return this.myContainer.getChild(PARENT_REFERENCE_ROLE);
    }

    @Override
    public JpsElementReference<T> asExternal(@NotNull JpsModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "org/jetbrains/jps/model/impl/JpsNamedElementReferenceBase", "asExternal"));
        }
        model.registerExternalReference(this);
        return this;
    }
}

