/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.RetinaImage;
import com.intellij.util.SVGLoader;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageFilter;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import javax.swing.Icon;
import org.imgscalr.Scalr;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImageLoader
implements Serializable {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.ImageLoader");
    private static final ConcurrentMap<String, Image> ourCache = ContainerUtil.createConcurrentSoftValueMap();
    public static final Component ourComponent = new Component(){};

    private static boolean waitForImage(Image image) {
        if (image == null) {
            return false;
        }
        if (image.getWidth(null) > 0) {
            return true;
        }
        MediaTracker mediatracker = new MediaTracker(ourComponent);
        mediatracker.addImage(image, 1);
        try {
            mediatracker.waitForID(1, 5000L);
        }
        catch (InterruptedException ex) {
            LOG.info(ex);
        }
        return !mediatracker.isErrorID(1);
    }

    @Nullable
    public static Image loadFromUrl(@NotNull URL url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/util/ImageLoader", "loadFromUrl"));
        }
        return ImageLoader.loadFromUrl(url, true);
    }

    @Nullable
    public static Image loadFromUrl(@NotNull URL url, boolean allowFloatScaling) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/util/ImageLoader", "loadFromUrl"));
        }
        return ImageLoader.loadFromUrl(url, allowFloatScaling, null);
    }

    @Nullable
    public static Image loadFromUrl(@NotNull URL url, boolean allowFloatScaling, ImageFilter filter) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/util/ImageLoader", "loadFromUrl"));
        }
        return ImageLoader.loadFromUrl(url, allowFloatScaling, new ImageFilter[]{filter}, JBUI.pixScale());
    }

    @Nullable
    public static Image loadFromUrl(@NotNull URL url, boolean allowFloatScaling, ImageFilter[] filters, float pixScale) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/util/ImageLoader", "loadFromUrl"));
        }
        final float scaleFactor = ImageLoader.adjustScaleFactor(allowFloatScaling, pixScale);
        final boolean scaleImages = scaleFactor > 1.0f && !UIUtil.isJDKManagedHiDPI();
        boolean loadRetinaImages = JBUI.isHiDPI(scaleFactor);
        return ImageDescList.create(url.toString(), null, UIUtil.isUnderDarcula(), loadRetinaImages, allowFloatScaling, pixScale).load(ImageConverterChain.create().withFilter(filters).withRetina().with(new ImageConverter(){

            @Override
            public Image convert(Image source, ImageDesc desc) {
                if (source != null && scaleImages && desc.type != ImageDesc.Type.SVG) {
                    if (desc.path.contains("@2x")) {
                        return ImageLoader.scaleImage(source, scaleFactor / 2.0f);
                    }
                    return ImageLoader.scaleImage(source, scaleFactor);
                }
                return source;
            }
        }));
    }

    private static float adjustScaleFactor(boolean allowFloatScaling, float scale) {
        return allowFloatScaling ? scale : (JBUI.isHiDPI(scale) ? 2.0f : 1.0f);
    }

    @NotNull
    public static Image scaleImage(Image image, float scale) {
        if ((double)scale == 1.0) {
            Image image2 = image;
            if (image2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ImageLoader", "scaleImage"));
            }
            return image2;
        }
        if (image instanceof JBHiDPIScaledImage) {
            JBHiDPIScaledImage jBHiDPIScaledImage = ((JBHiDPIScaledImage)image).scale(scale);
            if (jBHiDPIScaledImage == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ImageLoader", "scaleImage"));
            }
            return jBHiDPIScaledImage;
        }
        int w = image.getWidth(null);
        int h = image.getHeight(null);
        if (w <= 0 || h <= 0) {
            Image image3 = image;
            if (image3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ImageLoader", "scaleImage"));
            }
            return image3;
        }
        int width = (int)(scale * (float)w);
        int height = (int)(scale * (float)h);
        BufferedImage bufferedImage = Scalr.resize((BufferedImage)ImageUtil.toBufferedImage(image), (Scalr.Method)Scalr.Method.QUALITY, (int)width, (int)height, (BufferedImageOp[])new BufferedImageOp[0]);
        if (bufferedImage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ImageLoader", "scaleImage"));
        }
        return bufferedImage;
    }

    @Nullable
    public static Image loadFromUrl(URL url, boolean dark, boolean retina) {
        return ImageLoader.loadFromUrl(url, dark, retina, (ImageFilter[])null);
    }

    @Nullable
    public static Image loadFromUrl(URL url, boolean dark, boolean retina, ImageFilter filter) {
        return ImageLoader.loadFromUrl(url, dark, retina, new ImageFilter[]{filter});
    }

    @Nullable
    public static Image loadFromUrl(URL url, boolean dark, boolean retina, ImageFilter[] filters) {
        return ImageDescList.create(url.toString(), null, dark, retina, true).load(ImageConverterChain.create().withFilter(filters).withRetina());
    }

    @Nullable
    public static Image loadFromResource(@NonNls @NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/util/ImageLoader", "loadFromResource"));
        }
        Class callerClass = ReflectionUtil.getGrandCallerClass();
        if (callerClass == null) {
            return null;
        }
        return ImageLoader.loadFromResource(s, callerClass);
    }

    @Nullable
    public static Image loadFromResource(@NonNls @NotNull String path, @NotNull Class aClass) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/util/ImageLoader", "loadFromResource"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/ImageLoader", "loadFromResource"));
        }
        return ImageDescList.create(path, aClass, UIUtil.isUnderDarcula(), JBUI.isHiDPI(JBUI.pixScale()), true).load(ImageConverterChain.create().withRetina());
    }

    public static Image loadFromStream(@NotNull InputStream inputStream) {
        if (inputStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputStream", "com/intellij/util/ImageLoader", "loadFromStream"));
        }
        return ImageLoader.loadFromStream(inputStream, 1);
    }

    public static Image loadFromStream(@NotNull InputStream inputStream, int scale) {
        if (inputStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputStream", "com/intellij/util/ImageLoader", "loadFromStream"));
        }
        return ImageLoader.loadFromStream(inputStream, scale, null);
    }

    public static Image loadFromStream(@NotNull InputStream inputStream, int scale, ImageFilter filter) {
        if (inputStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputStream", "com/intellij/util/ImageLoader", "loadFromStream"));
        }
        Image image = ImageLoader.load(inputStream, scale);
        ImageDesc desc = new ImageDesc("", null, scale, ImageDesc.Type.UNDEFINED);
        return ImageConverterChain.create().withFilter(filter).withRetina().convert(image, desc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Image load(@NotNull InputStream inputStream, int scale) {
        if (inputStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputStream", "com/intellij/util/ImageLoader", "load"));
        }
        if (scale <= 0) {
            throw new IllegalArgumentException("Scale must be 1 or greater");
        }
        try {
            BufferExposingByteArrayOutputStream outputStream = new BufferExposingByteArrayOutputStream();
            try {
                int n;
                byte[] buffer = new byte[1024];
                while ((n = inputStream.read(buffer)) >= 0) {
                    outputStream.write(buffer, 0, n);
                }
            }
            finally {
                inputStream.close();
            }
            Image image = Toolkit.getDefaultToolkit().createImage(outputStream.getInternalBuffer(), 0, outputStream.size());
            ImageLoader.waitForImage(image);
            return image;
        }
        catch (Exception ex) {
            LOG.error(ex);
            return null;
        }
    }

    public static boolean isGoodSize(Icon icon) {
        return IconLoader.isGoodSize(icon);
    }

    public static List<Pair<String, Integer>> getFileNames(@NotNull String file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/ImageLoader", "getFileNames"));
        }
        return ImageLoader.getFileNames(file, false, false);
    }

    public static List<Pair<String, Integer>> getFileNames(@NotNull String file, boolean dark, boolean retina) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/ImageLoader", "getFileNames"));
        }
        new UnsupportedOperationException("unsupported method").printStackTrace();
        return new ArrayList<Pair<String, Integer>>();
    }

    private static class ImageConverterChain
    extends ArrayList<ImageConverter> {
        private ImageConverterChain() {
        }

        public static ImageConverterChain create() {
            return new ImageConverterChain();
        }

        public ImageConverterChain withFilter(ImageFilter[] filters) {
            ImageConverterChain chain = this;
            for (ImageFilter filter : filters) {
                chain = chain.withFilter(filter);
            }
            return chain;
        }

        public ImageConverterChain withFilter(final ImageFilter filter) {
            return this.with(new ImageConverter(){

                @Override
                public Image convert(Image source, ImageDesc desc) {
                    return ImageUtil.filter(source, filter);
                }
            });
        }

        public ImageConverterChain withRetina() {
            return this.with(new ImageConverter(){

                @Override
                public Image convert(Image source, ImageDesc desc) {
                    if (source != null && UIUtil.isJDKManagedHiDPI() && desc.scale > 1.0f) {
                        return RetinaImage.createFrom(source, (int)desc.scale, (ImageObserver)ourComponent);
                    }
                    return source;
                }
            });
        }

        public ImageConverterChain with(ImageConverter f) {
            this.add(f);
            return this;
        }

        public Image convert(Image image, ImageDesc desc) {
            for (ImageConverter f : this) {
                image = f.convert(image, desc);
            }
            return image;
        }
    }

    private static interface ImageConverter {
        public Image convert(@Nullable Image var1, ImageDesc var2);
    }

    private static class ImageDescList
    extends ArrayList<ImageDesc> {
        private ImageDescList() {
        }

        @Nullable
        public Image load() {
            return this.load(ImageConverterChain.create());
        }

        @Nullable
        public Image load(@NotNull ImageConverterChain converters) {
            if (converters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "converters", "com/intellij/util/ImageLoader$ImageDescList", "load"));
            }
            for (ImageDesc desc : this) {
                try {
                    Image image = desc.load();
                    if (image == null) continue;
                    LOG.debug("Loaded image: " + desc);
                    return converters.convert(image, desc);
                }
                catch (IOException iOException) {
                }
            }
            return null;
        }

        public static ImageDescList create(@NotNull String file, @Nullable Class cls, boolean dark, boolean retina, boolean allowFloatScaling) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/ImageLoader$ImageDescList", "create"));
            }
            return ImageDescList.create(file, cls, dark, retina, allowFloatScaling, JBUI.pixScale());
        }

        public static ImageDescList create(@NotNull String file, @Nullable Class cls, boolean dark, boolean retina, boolean allowFloatScaling, float pixScale) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/ImageLoader$ImageDescList", "create"));
            }
            ImageDescList vars = new ImageDescList();
            if (retina || dark) {
                String name = FileUtil.getNameWithoutExtension(file);
                String ext = FileUtilRt.getExtension(file);
                pixScale = ImageLoader.adjustScaleFactor(allowFloatScaling, pixScale);
                if (Registry.is("ide.svg.icon") && dark) {
                    vars.add(new ImageDesc(name + "_dark.svg", cls, pixScale, ImageDesc.Type.SVG));
                }
                if (Registry.is("ide.svg.icon")) {
                    vars.add(new ImageDesc(name + ".svg", cls, pixScale, ImageDesc.Type.SVG));
                }
                if (dark && retina) {
                    vars.add(new ImageDesc(name + "@2x_dark." + ext, cls, 2.0f, ImageDesc.Type.PNG));
                }
                if (dark) {
                    vars.add(new ImageDesc(name + "_dark." + ext, cls, 1.0f, ImageDesc.Type.PNG));
                }
                if (retina) {
                    vars.add(new ImageDesc(name + "@2x." + ext, cls, 2.0f, ImageDesc.Type.PNG));
                }
            }
            vars.add(new ImageDesc(file, cls, 1.0f, ImageDesc.Type.PNG, true));
            return vars;
        }
    }

    private static class ImageDesc {
        public final String path;
        @Nullable
        public final Class cls;
        public final float scale;
        public final Type type;
        public final boolean original;

        public ImageDesc(String path, Class cls, float scale, Type type) {
            this(path, cls, scale, type, false);
        }

        public ImageDesc(String path, Class cls, float scale, Type type, boolean original) {
            this.path = path;
            this.cls = cls;
            this.scale = scale;
            this.type = type;
            this.original = original;
        }

        @Nullable
        public Image load() throws IOException {
            Image image;
            String cacheKey = null;
            InputStream stream = null;
            URL url = null;
            if (this.cls != null && (stream = this.cls.getResourceAsStream(this.path)) == null) {
                return null;
            }
            if (stream == null) {
                cacheKey = this.path;
                image = (Image)ourCache.get(cacheKey);
                if (image != null) {
                    return image;
                }
                url = new URL(this.path);
                URLConnection connection = url.openConnection();
                if (connection instanceof HttpURLConnection) {
                    if (!this.original) {
                        return null;
                    }
                    connection.addRequestProperty("User-Agent", "IntelliJ");
                }
                stream = connection.getInputStream();
            }
            if ((image = this.type.load(url, stream, this.scale)) != null && cacheKey != null) {
                ourCache.put(cacheKey, image);
            }
            return image;
        }

        public String toString() {
            return this.path + ", scale: " + this.scale + ", type: " + (Object)((Object)this.type);
        }

        public static enum Type {
            PNG,
            SVG{

                @Override
                public Image load(URL url, InputStream is, float scale) throws IOException {
                    return SVGLoader.load(url, is, scale);
                }
            }
            ,
            UNDEFINED;


            public Image load(URL url, InputStream stream, float scale) throws IOException {
                return ImageLoader.load(stream, (int)scale);
            }
        }
    }
}

