/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.xmlb.BasePrimitiveBinding;
import com.intellij.util.xmlb.BeanBinding;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.MultiNodeBinding;
import com.intellij.util.xmlb.MutableAccessor;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlSerializerImpl;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TagBinding
extends BasePrimitiveBinding
implements MultiNodeBinding {
    private final String myTextIfEmpty;

    public TagBinding(@NotNull MutableAccessor accessor, @NotNull Tag tagAnnotation) {
        if (accessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessor", "com/intellij/util/xmlb/TagBinding", "<init>"));
        }
        if (tagAnnotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagAnnotation", "com/intellij/util/xmlb/TagBinding", "<init>"));
        }
        super(accessor, tagAnnotation.value(), null);
        this.myTextIfEmpty = tagAnnotation.textIfEmpty();
    }

    @Override
    @Nullable
    public Object serialize(@NotNull Object o, @Nullable SerializationFilter filter) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/util/xmlb/TagBinding", "serialize"));
        }
        Object value = this.myAccessor.read(o);
        Element serialized = new Element(this.myName);
        if (value == null) {
            return serialized;
        }
        if (this.myBinding == null) {
            serialized.addContent((Content)new Text(XmlSerializerImpl.convertToString(value)));
        } else {
            Object node = this.myBinding.serialize(value, serialized, filter);
            if (node != null && node != serialized) {
                JDOMUtil.addContent(serialized, node);
            }
        }
        return serialized;
    }

    @Override
    @Nullable
    public Object deserializeList(@NotNull Object context, @NotNull List<Element> elements) {
        ArrayList<Element> children;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/util/xmlb/TagBinding", "deserializeList"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/xmlb/TagBinding", "deserializeList"));
        }
        if (elements.size() == 1) {
            children = elements.get(0).getChildren();
        } else {
            String name = elements.get(0).getName();
            children = new ArrayList<Element>();
            for (Element element : elements) {
                assert (element.getName().equals(name));
                children.addAll(element.getChildren());
            }
        }
        this.deserialize(context, children);
        return context;
    }

    @Override
    public boolean isMulti() {
        return this.myBinding instanceof MultiNodeBinding && ((MultiNodeBinding)((Object)this.myBinding)).isMulti();
    }

    @Override
    @NotNull
    public Object deserialize(@NotNull Object context, @NotNull Element element) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/util/xmlb/TagBinding", "deserialize"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xmlb/TagBinding", "deserialize"));
        }
        if (this.myBinding == null) {
            String value = XmlSerializerImpl.getTextValue(element, this.myTextIfEmpty);
            XmlSerializerImpl.doSet(context, value, this.myAccessor, XmlSerializerImpl.typeToClass(this.myAccessor.getGenericType()));
        } else {
            this.deserialize(context, element.getChildren());
        }
        Object object = context;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/TagBinding", "deserialize"));
        }
        return object;
    }

    private void deserialize(@NotNull Object context, @NotNull List<Element> children) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/util/xmlb/TagBinding", "deserialize"));
        }
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/util/xmlb/TagBinding", "deserialize"));
        }
        assert (this.myBinding != null);
        if (this.myBinding instanceof BeanBinding && this.myAccessor.isFinal()) {
            ((BeanBinding)this.myBinding).deserializeInto(context, children.get(0));
        } else {
            this.myAccessor.set(context, Binding.deserializeList(this.myBinding, this.myAccessor.read(context), children));
        }
    }

    @Override
    public boolean isBoundTo(@NotNull Element node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/util/xmlb/TagBinding", "isBoundTo"));
        }
        return node.getName().equals(this.myName);
    }
}

