/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.flex.model.bc.impl;

import com.intellij.flex.model.bc.JpsFlexBuildConfiguration;
import com.intellij.flex.model.bc.JpsFlexBuildConfigurationManager;
import com.intellij.flex.model.bc.JpsFlexModuleOrProjectCompilerOptions;
import com.intellij.flex.model.bc.impl.JpsFlexBCState;
import com.intellij.flex.model.bc.impl.JpsFlexBuildConfigurationImpl;
import com.intellij.flex.model.bc.impl.JpsFlexCompilerOptionsImpl;
import com.intellij.flex.model.bc.impl.JpsFlexCompilerOptionsRole;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.JpsElementCollection;
import org.jetbrains.jps.model.ex.JpsCompositeElementBase;

public class JpsFlexBuildConfigurationManagerImpl
extends JpsCompositeElementBase<JpsFlexBuildConfigurationManagerImpl>
implements JpsFlexBuildConfigurationManager {
    private static final Logger LOG = Logger.getInstance((String)JpsFlexBuildConfigurationManagerImpl.class.getName());
    private JpsFlexBuildConfiguration myActiveConfiguration;

    public JpsFlexBuildConfigurationManagerImpl() {
        this.myContainer.setChild(JpsFlexBuildConfigurationImpl.COLLECTION_ROLE);
        this.myContainer.setChild((JpsElementChildRole)JpsFlexCompilerOptionsRole.INSTANCE);
    }

    private JpsFlexBuildConfigurationManagerImpl(JpsFlexBuildConfigurationManagerImpl original) {
        super((JpsCompositeElementBase)original);
    }

    @NotNull
    public JpsFlexBuildConfigurationManagerImpl createCopy() {
        JpsFlexBuildConfigurationManagerImpl jpsFlexBuildConfigurationManagerImpl = new JpsFlexBuildConfigurationManagerImpl(this);
        if (jpsFlexBuildConfigurationManagerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/flex/model/bc/impl/JpsFlexBuildConfigurationManagerImpl", "createCopy"));
        }
        return jpsFlexBuildConfigurationManagerImpl;
    }

    public void applyChanges(@NotNull JpsFlexBuildConfigurationManagerImpl modified) {
        if (modified == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modified", "com/intellij/flex/model/bc/impl/JpsFlexBuildConfigurationManagerImpl", "applyChanges"));
        }
        super.applyChanges((JpsCompositeElementBase)modified);
    }

    @Override
    public List<JpsFlexBuildConfiguration> getBuildConfigurations() {
        return ((JpsElementCollection)this.myContainer.getChild(JpsFlexBuildConfigurationImpl.COLLECTION_ROLE)).getElements();
    }

    @Override
    public JpsFlexBuildConfiguration getActiveConfiguration() {
        return this.myActiveConfiguration;
    }

    @Override
    @Nullable
    public JpsFlexBuildConfiguration findConfigurationByName(String name) {
        for (JpsFlexBuildConfiguration configuration : this.getBuildConfigurations()) {
            if (!configuration.getName().equals(name)) continue;
            return configuration;
        }
        return null;
    }

    @Override
    public JpsFlexModuleOrProjectCompilerOptions getModuleLevelCompilerOptions() {
        return (JpsFlexModuleOrProjectCompilerOptions)this.myContainer.getChild((JpsElementChildRole)JpsFlexCompilerOptionsRole.INSTANCE);
    }

    @Override
    public JpsFlexBuildConfiguration createCopy(@NotNull JpsFlexBuildConfiguration bc) {
        if (bc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bc", "com/intellij/flex/model/bc/impl/JpsFlexBuildConfigurationManagerImpl", "createCopy"));
        }
        JpsFlexBuildConfigurationImpl copy = ((JpsFlexBuildConfigurationImpl)bc).createCopy();
        copy.setParent(((JpsFlexBuildConfigurationImpl)bc).getParent());
        return copy;
    }

    @Override
    public JpsFlexBuildConfiguration createTemporaryCopyForCompilation(@NotNull JpsFlexBuildConfiguration bc) {
        if (bc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bc", "com/intellij/flex/model/bc/impl/JpsFlexBuildConfigurationManagerImpl", "createTemporaryCopyForCompilation"));
        }
        JpsFlexBuildConfigurationImpl copy = ((JpsFlexBuildConfigurationImpl)bc).createCopy();
        copy.setParent(((JpsFlexBuildConfigurationImpl)bc).getParent());
        copy.setTempBCForCompilation(true);
        return copy;
    }

    private void updateActiveConfiguration(@Nullable String activeBCName) {
        List<JpsFlexBuildConfiguration> bcs = this.getBuildConfigurations();
        if (bcs.isEmpty()) {
            LOG.error("No Flex build configurations");
            this.myActiveConfiguration = null;
        } else {
            JpsFlexBuildConfiguration jpsFlexBuildConfiguration = this.myActiveConfiguration = activeBCName != null ? (JpsFlexBuildConfiguration)ContainerUtil.find(bcs, bc -> bc.getName().equals(activeBCName)) : null;
            if (this.myActiveConfiguration == null) {
                this.myActiveConfiguration = bcs.get(0);
            }
        }
    }

    public State getState() {
        State state = new State();
        for (JpsFlexBuildConfiguration configuration : this.getBuildConfigurations()) {
            state.CONFIGURATIONS.add(((JpsFlexBuildConfigurationImpl)configuration).getState());
        }
        state.ACTIVE_BC_NAME = this.myActiveConfiguration != null ? this.myActiveConfiguration.getName() : null;
        state.MODULE_LEVEL_COMPILER_OPTIONS = ((JpsFlexCompilerOptionsImpl)this.getModuleLevelCompilerOptions()).getState();
        return state;
    }

    public void loadState(State state) {
        JpsElementCollection bcs = (JpsElementCollection)this.myContainer.getChild(JpsFlexBuildConfigurationImpl.COLLECTION_ROLE);
        LOG.assertTrue(bcs.getElements().size() == 0);
        for (JpsFlexBCState configurationState : state.CONFIGURATIONS) {
            JpsFlexBuildConfigurationImpl bc = new JpsFlexBuildConfigurationImpl(configurationState.NAME);
            bc.loadState(configurationState);
            bcs.addChild((JpsElement)bc);
        }
        if (bcs.getElements().isEmpty()) {
            LOG.warn("Flex build configurations not loaded from *.iml.");
            bcs.addChild((JpsElement)new JpsFlexBuildConfigurationImpl("Unnamed"));
        }
        this.updateActiveConfiguration(state.ACTIVE_BC_NAME);
        ((JpsFlexCompilerOptionsImpl)this.getModuleLevelCompilerOptions()).loadState(state.MODULE_LEVEL_COMPILER_OPTIONS);
    }

    public static class State {
        @Tag(value="configurations")
        @AbstractCollection(surroundWithTag=false, elementTag="configuration")
        public List<JpsFlexBCState> CONFIGURATIONS = new ArrayList<JpsFlexBCState>();
        @Property(surroundWithTag=false)
        public JpsFlexCompilerOptionsImpl.State MODULE_LEVEL_COMPILER_OPTIONS = new JpsFlexCompilerOptionsImpl.State();
        @Attribute(value="active")
        public String ACTIVE_BC_NAME;
    }
}

