/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.deployer.repository.wrapper;

import aQute.bnd.build.DownloadBlocker;
import aQute.bnd.osgi.repository.BaseRepository;
import aQute.bnd.osgi.resource.CapReqBuilder;
import aQute.bnd.osgi.resource.PersistentResource;
import aQute.bnd.osgi.resource.ResourceBuilder;
import aQute.bnd.service.RepositoryPlugin;
import aQute.bnd.service.repository.InfoRepository;
import aQute.bnd.service.repository.SearchableRepository;
import aQute.bnd.version.Version;
import aQute.lib.collections.MultiMap;
import aQute.lib.filter.Filter;
import aQute.lib.hex.Hex;
import aQute.lib.persistentmap.PersistentMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.osgi.framework.FrameworkUtil;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.service.indexer.Capability;
import org.osgi.service.indexer.ResourceIndexer;
import org.osgi.service.indexer.impl.KnownBundleAnalyzer;
import org.osgi.service.indexer.impl.RepoIndex;

public class InfoRepositoryWrapper
extends BaseRepository {
    final RepoIndex repoIndexer;
    final PersistentMap<PersistentResource> persistent;
    final Collection<? extends InfoRepository> repos;
    long lastTime = 0L;
    private Properties augments = new Properties();

    public InfoRepositoryWrapper(File dir, Collection<? extends InfoRepository> repos) throws Exception {
        this.repoIndexer = new RepoIndex();
        KnownBundleAnalyzer knownBundleAnalyzer = new KnownBundleAnalyzer();
        this.augments = new Properties();
        knownBundleAnalyzer.setKnownBundlesExtra(this.augments);
        this.repoIndexer.addAnalyzer(knownBundleAnalyzer, FrameworkUtil.createFilter("(name=*)"));
        this.repos = repos;
        this.persistent = new PersistentMap<PersistentResource>(dir, PersistentResource.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean init() {
        try {
            if (System.currentTimeMillis() < this.lastTime + 10000L) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.lastTime = System.currentTimeMillis();
        }
        LinkedHashSet<String> errors = new LinkedHashSet<String>();
        try {
            HashSet<String> toBeDeleted = new HashSet<String>(this.persistent.keySet());
            HashMap<String, 1> blockers = new HashMap<String, 1>();
            for (InfoRepository infoRepository : this.repos) {
                Map<String, SearchableRepository.ResourceDescriptor> map = this.collectKeys(infoRepository);
                for (Map.Entry<String, SearchableRepository.ResourceDescriptor> entry : map.entrySet()) {
                    final String id = entry.getKey();
                    toBeDeleted.remove(id);
                    if (this.persistent.containsKey(id)) continue;
                    SearchableRepository.ResourceDescriptor rd = entry.getValue();
                    DownloadBlocker blocker = new DownloadBlocker(null){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void success(File file) throws Exception {
                            ResourceIndexer.IndexResult index = null;
                            try {
                                CapReqBuilder cb;
                                index = InfoRepositoryWrapper.this.repoIndexer.indexFile(file);
                                ResourceBuilder rb = new ResourceBuilder();
                                for (Capability capability : index.capabilities) {
                                    cb = new CapReqBuilder(capability.getNamespace());
                                    cb.addAttributes(capability.getAttributes());
                                    cb.addDirectives(capability.getDirectives());
                                    rb.addCapability(cb.buildSyntheticCapability());
                                }
                                for (org.osgi.service.indexer.Requirement requirement : index.requirements) {
                                    cb = new CapReqBuilder(requirement.getNamespace());
                                    cb.addAttributes(requirement.getAttributes());
                                    cb.addDirectives(requirement.getDirectives());
                                    rb.addRequirement(cb.buildSyntheticRequirement());
                                }
                                Resource resource = rb.build();
                                PersistentResource pr = new PersistentResource(resource);
                                InfoRepositoryWrapper.this.persistent.put(id, pr);
                            }
                            finally {
                                super.success(file);
                                if (index != null) {
                                    index.resource.close();
                                }
                            }
                        }
                    };
                    blockers.put(entry.getKey(), blocker);
                    infoRepository.get(rd.bsn, rd.version, null, new RepositoryPlugin.DownloadListener[]{blocker});
                }
            }
            for (Map.Entry entry : blockers.entrySet()) {
                String key = (String)entry.getKey();
                DownloadBlocker blocker = (DownloadBlocker)entry.getValue();
                String reason = blocker.getReason();
                if (reason == null) continue;
                errors.add(key + ": " + reason);
            }
            this.persistent.keySet().removeAll(toBeDeleted);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!errors.isEmpty()) {
            throw new IllegalStateException("Cannot index " + this.repos + " due to " + errors);
        }
        return true;
    }

    public void findProviders(Map<Requirement, List<org.osgi.resource.Capability>> result, Collection<? extends Requirement> requirements) throws Exception {
        this.init();
        for (Requirement requirement : requirements) {
            String f = requirement.getDirectives().get("filter");
            if (f == null) continue;
            Filter filter = new Filter(f);
            for (PersistentResource presource : this.persistent.values()) {
                Resource resource = presource.getResource();
                List<org.osgi.resource.Capability> provided = resource.getCapabilities(requirement.getNamespace());
                if (provided == null) continue;
                for (org.osgi.resource.Capability cap : provided) {
                    if (!filter.matchMap(cap.getAttributes())) continue;
                    List<org.osgi.resource.Capability> l = result.get(requirement);
                    if (l == null) {
                        l = new ArrayList<org.osgi.resource.Capability>();
                        result.put(requirement, l);
                    }
                    l.add(cap);
                }
            }
        }
    }

    public Map<Requirement, Collection<org.osgi.resource.Capability>> findProviders(Collection<? extends Requirement> requirements) {
        MultiMap<Requirement, org.osgi.resource.Capability> result = new MultiMap<Requirement, org.osgi.resource.Capability>();
        try {
            this.findProviders(result, requirements);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, SearchableRepository.ResourceDescriptor> collectKeys(InfoRepository repo) throws Exception {
        HashMap<String, SearchableRepository.ResourceDescriptor> map = new HashMap<String, SearchableRepository.ResourceDescriptor>();
        for (String bsn : repo.list(null)) {
            for (Version version : repo.versions(bsn)) {
                SearchableRepository.ResourceDescriptor rd = repo.getDescriptor(bsn, version);
                if (rd == null) continue;
                map.put(Hex.toHexString(rd.id), rd);
            }
        }
        return map;
    }

    public String toString() {
        return "InfoRepositoryWrapper[" + this.repos.size() + "]";
    }

    public void close() throws IOException {
        this.persistent.close();
    }

    public void addAugment(Properties properties) {
        this.augments.putAll((Map<?, ?>)properties);
    }

    public void clear() {
        this.persistent.clear();
    }

    public void clear(long whenOlder) {
        this.persistent.clear(whenOlder);
    }
}

