/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.impl;

import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.JpsEncodingConfigurationService;
import org.jetbrains.jps.model.JpsEncodingProjectConfiguration;
import org.jetbrains.jps.model.JpsGlobal;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.JpsSimpleElement;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;
import org.jetbrains.jps.model.impl.JpsEncodingProjectConfigurationImpl;

public class JpsEncodingConfigurationServiceImpl
extends JpsEncodingConfigurationService {
    private static final JpsElementChildRoleBase<JpsSimpleElement<String>> ENCODING_ROLE = JpsElementChildRoleBase.create("encoding");

    @Override
    @Nullable
    public String getGlobalEncoding(@NotNull JpsGlobal global) {
        if (global == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "global", "org/jetbrains/jps/model/impl/JpsEncodingConfigurationServiceImpl", "getGlobalEncoding"));
        }
        JpsSimpleElement<String> encoding = global.getContainer().getChild(ENCODING_ROLE);
        return encoding != null ? encoding.getData() : null;
    }

    @Override
    public void setGlobalEncoding(@NotNull JpsGlobal global, @Nullable String encoding) {
        if (global == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "global", "org/jetbrains/jps/model/impl/JpsEncodingConfigurationServiceImpl", "setGlobalEncoding"));
        }
        if (encoding != null) {
            global.getContainer().setChild(ENCODING_ROLE, JpsElementFactory.getInstance().createSimpleElement(encoding));
        } else {
            global.getContainer().removeChild(ENCODING_ROLE);
        }
    }

    @Override
    @Nullable
    public String getProjectEncoding(@NotNull JpsModel model) {
        String projectEncoding;
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "org/jetbrains/jps/model/impl/JpsEncodingConfigurationServiceImpl", "getProjectEncoding"));
        }
        JpsEncodingProjectConfiguration configuration = this.getEncodingConfiguration(model.getProject());
        if (configuration != null && (projectEncoding = configuration.getProjectEncoding()) != null) {
            return projectEncoding;
        }
        return this.getGlobalEncoding(model.getGlobal());
    }

    @Override
    @Nullable
    public JpsEncodingProjectConfiguration getEncodingConfiguration(@NotNull JpsProject project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jps/model/impl/JpsEncodingConfigurationServiceImpl", "getEncodingConfiguration"));
        }
        return project.getContainer().getChild(JpsEncodingProjectConfigurationImpl.ROLE);
    }

    @Override
    @NotNull
    public JpsEncodingProjectConfiguration setEncodingConfiguration(@NotNull JpsProject project, @Nullable String projectEncoding, @NotNull Map<String, String> urlToEncoding) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jps/model/impl/JpsEncodingConfigurationServiceImpl", "setEncodingConfiguration"));
        }
        if (urlToEncoding == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urlToEncoding", "org/jetbrains/jps/model/impl/JpsEncodingConfigurationServiceImpl", "setEncodingConfiguration"));
        }
        JpsEncodingProjectConfigurationImpl configuration = new JpsEncodingProjectConfigurationImpl(urlToEncoding, projectEncoding);
        JpsEncodingProjectConfiguration jpsEncodingProjectConfiguration = project.getContainer().setChild(JpsEncodingProjectConfigurationImpl.ROLE, configuration);
        if (jpsEncodingProjectConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/impl/JpsEncodingConfigurationServiceImpl", "setEncodingConfiguration"));
        }
        return jpsEncodingProjectConfiguration;
    }
}

