/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.indexer.impl;

import java.io.PrintStream;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;

public class ConsoleLogSvc
implements LogService {
    @Override
    public void log(int level, String message) {
        this.log(null, level, message, null);
    }

    @Override
    public void log(int level, String message, Throwable exception) {
        this.log(null, level, message, exception);
    }

    @Override
    public void log(ServiceReference sr, int level, String message) {
        this.log(sr, level, message, null);
    }

    @Override
    public void log(ServiceReference sr, int level, String message, Throwable exception) {
        PrintStream out = level <= 2 ? System.err : System.out;
        StringBuilder builder = new StringBuilder();
        switch (level) {
            case 4: {
                builder.append("DEBUG");
                break;
            }
            case 3: {
                builder.append("INFO");
                break;
            }
            case 2: {
                builder.append("WARNING");
                break;
            }
            case 1: {
                builder.append("ERROR");
                break;
            }
            default: {
                builder.append("<<unknown>>");
            }
        }
        builder.append(": ");
        builder.append(message);
        if (exception != null) {
            builder.append(" [");
            builder.append(exception.getLocalizedMessage());
            builder.append("]");
        }
        out.println(builder.toString());
        if (exception != null) {
            exception.printStackTrace(out);
        }
    }
}

