/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.ant.model;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ant.model.JpsAntBuildFileOptions;
import org.jetbrains.jps.ant.model.JpsAntConfiguration;
import org.jetbrains.jps.ant.model.JpsAntInstallation;
import org.jetbrains.jps.ant.model.artifacts.JpsAntArtifactExtension;
import org.jetbrains.jps.ant.model.impl.JpsAntBuildFileOptionsImpl;
import org.jetbrains.jps.ant.model.impl.JpsAntConfigurationImpl;
import org.jetbrains.jps.ant.model.impl.JpsAntInstallationImpl;
import org.jetbrains.jps.ant.model.impl.artifacts.JpsAntArtifactExtensionImpl;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementCollection;
import org.jetbrains.jps.model.JpsGlobal;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.artifact.JpsArtifact;

public class JpsAntExtensionService {
    public static final String BUNDLED_ANT_PATH_PROPERTY = "jps.bundled.ant.path";
    private static final Logger LOG = Logger.getInstance(JpsAntExtensionService.class);

    @Nullable
    public static JpsAntArtifactExtension getPreprocessingExtension(@NotNull JpsArtifact artifact) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "org/jetbrains/jps/ant/model/JpsAntExtensionService", "getPreprocessingExtension"));
        }
        return (JpsAntArtifactExtension)artifact.getContainer().getChild(JpsAntArtifactExtensionImpl.PREPROCESSING_ROLE);
    }

    @Nullable
    public static JpsAntArtifactExtension getPostprocessingExtension(@NotNull JpsArtifact artifact) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "org/jetbrains/jps/ant/model/JpsAntExtensionService", "getPostprocessingExtension"));
        }
        return (JpsAntArtifactExtension)artifact.getContainer().getChild(JpsAntArtifactExtensionImpl.POSTPROCESSING_ROLE);
    }

    public static void addAntInstallation(JpsGlobal global, JpsAntInstallation antInstallation) {
        ((JpsElementCollection)global.getContainer().getOrSetChild(JpsAntInstallationImpl.COLLECTION_ROLE)).addChild((JpsElement)antInstallation);
    }

    @NotNull
    public static JpsAntBuildFileOptions getOptions(@NotNull JpsProject project, @NotNull String buildFileUrl) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jps/ant/model/JpsAntExtensionService", "getOptions"));
        }
        if (buildFileUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildFileUrl", "org/jetbrains/jps/ant/model/JpsAntExtensionService", "getOptions"));
        }
        JpsAntConfiguration configuration = JpsAntExtensionService.getAntConfiguration(project);
        if (configuration != null) {
            JpsAntBuildFileOptions jpsAntBuildFileOptions = configuration.getOptions(buildFileUrl);
            if (jpsAntBuildFileOptions == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/ant/model/JpsAntExtensionService", "getOptions"));
            }
            return jpsAntBuildFileOptions;
        }
        JpsAntBuildFileOptionsImpl jpsAntBuildFileOptionsImpl = new JpsAntBuildFileOptionsImpl();
        if (jpsAntBuildFileOptionsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/ant/model/JpsAntExtensionService", "getOptions"));
        }
        return jpsAntBuildFileOptionsImpl;
    }

    @Nullable
    private static JpsAntConfiguration getAntConfiguration(JpsProject project) {
        return (JpsAntConfiguration)project.getContainer().getChild(JpsAntConfigurationImpl.ROLE);
    }

    @NotNull
    public static JpsAntConfiguration getOrCreateAntConfiguration(@NotNull JpsProject project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jps/ant/model/JpsAntExtensionService", "getOrCreateAntConfiguration"));
        }
        JpsAntConfiguration configuration = JpsAntExtensionService.getAntConfiguration(project);
        if (configuration != null) {
            JpsAntConfiguration jpsAntConfiguration = configuration;
            if (jpsAntConfiguration == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/ant/model/JpsAntExtensionService", "getOrCreateAntConfiguration"));
            }
            return jpsAntConfiguration;
        }
        JpsAntConfigurationImpl antConfiguration = new JpsAntConfigurationImpl(new HashMap<String, JpsAntBuildFileOptions>(), null);
        JpsAntConfiguration jpsAntConfiguration = (JpsAntConfiguration)project.getContainer().setChild(JpsAntConfigurationImpl.ROLE, (JpsElement)antConfiguration);
        if (jpsAntConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/ant/model/JpsAntExtensionService", "getOrCreateAntConfiguration"));
        }
        return jpsAntConfiguration;
    }

    @Nullable
    private static JpsAntInstallation getBundledAntInstallation() {
        File antHome;
        String antPath = System.getProperty(BUNDLED_ANT_PATH_PROPERTY);
        if (antPath != null) {
            antHome = new File(antPath);
        } else {
            File communityAntHome;
            String appHome = PathManager.getHomePath();
            if (appHome == null) {
                LOG.debug("idea.home.path and jps.bundled.ant.path aren't specified, bundled Ant won't be configured");
                return null;
            }
            antHome = new File(appHome, "lib" + File.separator + "ant");
            if (!antHome.exists() && (communityAntHome = new File(appHome, "community" + File.separator + "lib" + File.separator + "ant")).exists()) {
                antHome = communityAntHome;
            }
        }
        if (!antHome.exists()) {
            LOG.debug("Bundled Ant not found at " + antHome.getAbsolutePath());
            return null;
        }
        String antLib = new File(antHome, "lib").getAbsolutePath();
        return new JpsAntInstallationImpl(antHome, "Bundled Ant", Collections.emptyList(), Collections.singletonList(antLib));
    }

    @Nullable
    public static JpsAntInstallation getAntInstallationForBuildFile(@NotNull JpsModel model, @NotNull String buildFileUrl) {
        JpsAntConfiguration antConfiguration;
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "org/jetbrains/jps/ant/model/JpsAntExtensionService", "getAntInstallationForBuildFile"));
        }
        if (buildFileUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildFileUrl", "org/jetbrains/jps/ant/model/JpsAntExtensionService", "getAntInstallationForBuildFile"));
        }
        JpsAntBuildFileOptions options = JpsAntExtensionService.getOptions(model.getProject(), buildFileUrl);
        String antInstallationName = options.isUseProjectDefaultAnt() ? ((antConfiguration = JpsAntExtensionService.getAntConfiguration(model.getProject())) != null ? antConfiguration.getProjectDefaultAntName() : null) : options.getAntInstallationName();
        if (antInstallationName == null) {
            return JpsAntExtensionService.getBundledAntInstallation();
        }
        return JpsAntExtensionService.findAntInstallation(model, antInstallationName);
    }

    @Nullable
    public static JpsAntInstallation findAntInstallation(@NotNull JpsModel model, @NotNull String antInstallationName) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "org/jetbrains/jps/ant/model/JpsAntExtensionService", "findAntInstallation"));
        }
        if (antInstallationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "antInstallationName", "org/jetbrains/jps/ant/model/JpsAntExtensionService", "findAntInstallation"));
        }
        JpsElementCollection antInstallations = (JpsElementCollection)model.getGlobal().getContainer().getChild(JpsAntInstallationImpl.COLLECTION_ROLE);
        if (antInstallations != null) {
            for (JpsAntInstallation installation : antInstallations.getElements()) {
                if (!antInstallationName.equals(installation.getName())) continue;
                return installation;
            }
            LOG.debug("Ant installation '" + antInstallationName + "' not found");
        } else {
            LOG.debug("Ant installations weren't loaded");
        }
        return null;
    }
}

