/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.repository.maven.provider;

import aQute.bnd.annotation.plugin.BndPlugin;
import aQute.bnd.build.Workspace;
import aQute.bnd.header.Attrs;
import aQute.bnd.header.Parameters;
import aQute.bnd.http.HttpClient;
import aQute.bnd.jpm.util.JSONRPCProxy;
import aQute.bnd.maven.PomResource;
import aQute.bnd.osgi.FileResource;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.Resource;
import aQute.bnd.osgi.repository.BaseRepository;
import aQute.bnd.repository.maven.provider.Configuration;
import aQute.bnd.repository.maven.provider.IndexFile;
import aQute.bnd.repository.maven.provider.ReleaseDTO;
import aQute.bnd.repository.maven.provider.RepoActions;
import aQute.bnd.repository.maven.provider.Tool;
import aQute.bnd.service.Actionable;
import aQute.bnd.service.Plugin;
import aQute.bnd.service.Refreshable;
import aQute.bnd.service.Registry;
import aQute.bnd.service.RegistryPlugin;
import aQute.bnd.service.RepositoryListenerPlugin;
import aQute.bnd.service.RepositoryPlugin;
import aQute.bnd.service.maven.PomOptions;
import aQute.bnd.service.maven.ToDependencyPom;
import aQute.bnd.version.Version;
import aQute.jpm.facade.repo.JpmRepo;
import aQute.lib.converter.Converter;
import aQute.lib.hex.Hex;
import aQute.lib.io.IO;
import aQute.libg.cryptography.SHA1;
import aQute.libg.glob.Glob;
import aQute.maven.api.Archive;
import aQute.maven.api.IMavenRepo;
import aQute.maven.api.IPom;
import aQute.maven.api.Program;
import aQute.maven.api.Release;
import aQute.maven.api.Revision;
import aQute.maven.provider.MavenBackingRepository;
import aQute.maven.provider.MavenRepository;
import aQute.maven.provider.PomGenerator;
import aQute.service.library.Library;
import aQute.service.reporter.Reporter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.util.promise.Failure;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.Success;

@BndPlugin(name="MavenBndRepository")
public class MavenBndRepository
extends BaseRepository
implements RepositoryPlugin,
RegistryPlugin,
Plugin,
Closeable,
Refreshable,
Actionable,
ToDependencyPom {
    private final Pattern JPM_REVISION_URL_PATTERN_P = Pattern.compile("https?://.+#!?/p/sha/(?<sha>([0-9A-F][0-9A-F]){20,20})/.*", 2);
    private static final String NONE = "NONE";
    static final String MAVEN_REPO_LOCAL = System.getProperty("maven.repo.local", "~/.m2/repository");
    private Configuration configuration;
    private Registry registry;
    private File localRepo;
    Reporter reporter;
    IMavenRepo storage;
    private boolean inited;
    private boolean ok = true;
    IndexFile index;
    private ScheduledFuture<?> indexPoller;
    private RepoActions actions = new RepoActions(this);
    private String name;
    private JpmRepo libraryx;
    private HttpClient client;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RepositoryPlugin.PutResult put(InputStream stream, RepositoryPlugin.PutOptions options) throws Exception {
        this.init();
        File binaryFile = File.createTempFile("put", ".jar");
        File pomFile = File.createTempFile("pom", ".xml");
        try {
            byte[] digest;
            RepositoryPlugin.PutResult result = new RepositoryPlugin.PutResult();
            if (options == null) {
                options = new RepositoryPlugin.PutOptions();
            }
            IO.copy(stream, binaryFile);
            if (options.digest != null && !Arrays.equals(options.digest, digest = SHA1.digest(binaryFile).digest())) {
                throw new IllegalArgumentException("The given sha-1 does not match the contents sha-1");
            }
            if (options.context == null) {
                options.context = (Processor)this.registry.getPlugin(Workspace.class);
                if (options.context == null) {
                    options.context = new Processor();
                }
            }
            ReleaseDTO instructions = this.getReleaseDTO(options.context);
            try (Jar binary = new Jar(binaryFile);){
                Archive binaryArchive;
                block101: {
                    IPom pom;
                    Resource pomResource;
                    if (instructions.pom.path != null) {
                        File f = options.context.getFile(instructions.pom.path);
                        if (!f.isFile()) {
                            throw new IllegalArgumentException("-maven-release specifies " + f + " as pom file but this file is not found");
                        }
                        pomResource = new FileResource(f);
                    } else {
                        pomResource = this.getPomResource(binary);
                        if (pomResource == null && (pomResource = this.createPomResource(binary, options.context)) == null) {
                            throw new IllegalArgumentException("No POM resource in META-INF/maven/... The Maven Bnd Repository requires this pom.");
                        }
                    }
                    IO.copy(pomResource.openInputStream(), pomFile);
                    try (FileInputStream fin = new FileInputStream(pomFile);){
                        pom = this.storage.getPom(fin);
                    }
                    binaryArchive = pom.binaryArchive();
                    this.checkRemotePossible(instructions, binaryArchive.isSnapshot());
                    if (!binaryArchive.isSnapshot() && this.storage.exists(binaryArchive)) {
                        this.reporter.trace("Already released %s to %s", new Object[]{pom.getRevision(), this});
                        result.alreadyReleased = true;
                        var12_14 = result;
                        return var12_14;
                    }
                    this.reporter.trace("Put release %s", new Object[]{pom.getRevision()});
                    try (Release releaser = this.storage.release(pom.getRevision(), options.context.getProperties());){
                        if (releaser == null) {
                            this.reporter.trace("already released %s", new Object[]{pom.getRevision()});
                            RepositoryPlugin.PutResult putResult = result;
                            return putResult;
                        }
                        if (instructions.snapshot >= 0L) {
                            releaser.setBuild(instructions.snapshot, "1");
                        }
                        if (this.isLocal(instructions)) {
                            releaser.setLocalOnly();
                        }
                        releaser.add(pom.getRevision().pomArchive(), pomFile);
                        releaser.add(binaryArchive, binaryFile);
                        URI uRI = result.artifact = this.isLocal(instructions) ? this.storage.toLocalFile(binaryArchive).toURI() : this.storage.toRemoteURI(binaryArchive);
                        if (this.isLocal(instructions)) break block101;
                        try (Tool tool = new Tool(options.context, binary);){
                            Throwable throwable;
                            Jar jar;
                            if (instructions.javadoc != null && !NONE.equals(instructions.javadoc.path)) {
                                jar = this.getJavadoc(tool, options.context, instructions.javadoc.path, instructions.javadoc.options, instructions.javadoc.packages == ReleaseDTO.JavadocPackages.EXPORT);
                                throwable = null;
                                try {
                                    this.save(releaser, pom.getRevision(), jar, "javadoc");
                                }
                                catch (Throwable x2) {
                                    throwable = x2;
                                    throw x2;
                                }
                                finally {
                                    if (jar != null) {
                                        if (throwable != null) {
                                            try {
                                                jar.close();
                                            }
                                            catch (Throwable x2) {
                                                throwable.addSuppressed(x2);
                                            }
                                        } else {
                                            jar.close();
                                        }
                                    }
                                }
                            }
                            if (instructions.sources == null || NONE.equals(instructions.sources.path)) break block101;
                            jar = this.getSource(tool, options.context, instructions.sources.path);
                            throwable = null;
                            try {
                                this.save(releaser, pom.getRevision(), jar, "sources");
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (jar != null) {
                                    if (throwable != null) {
                                        try {
                                            jar.close();
                                        }
                                        catch (Throwable x2) {
                                            throwable.addSuppressed(x2);
                                        }
                                    } else {
                                        jar.close();
                                    }
                                }
                            }
                        }
                    }
                }
                if (!binaryArchive.isSnapshot()) {
                    this.index.add(binaryArchive);
                }
            }
            RepositoryPlugin.PutResult putResult = result;
            return putResult;
        }
        finally {
            binaryFile.delete();
            pomFile.delete();
        }
    }

    void checkRemotePossible(ReleaseDTO instructions, boolean snapshot) {
        if (instructions.type == ReleaseDTO.ReleaseType.REMOTE) {
            if (snapshot) {
                if (this.storage.getSnapshotRepositories().isEmpty()) {
                    throw new IllegalArgumentException("Remote snapshot release requested but no snapshot repository set for " + this.getName());
                }
            } else if (this.storage.getReleaseRepositories().isEmpty()) {
                throw new IllegalArgumentException("Remote release requested but no release repository set for " + this.getName());
            }
        }
    }

    boolean isLocal(ReleaseDTO instructions) {
        return instructions.type == ReleaseDTO.ReleaseType.LOCAL;
    }

    private Jar getSource(Tool tool, Processor context, String path) throws Exception {
        Jar jar = this.toJar(context, path);
        if (jar == null) {
            jar = tool.doSource();
        }
        jar.ensureManifest();
        tool.addClose((Closeable)jar);
        return jar;
    }

    private Jar getJavadoc(Tool tool, Processor context, String path, Map<String, String> options, boolean exports) throws Exception {
        Jar jar = this.toJar(context, path);
        if (jar == null) {
            jar = tool.doJavadoc(options, exports);
        }
        jar.ensureManifest();
        tool.addClose((Closeable)jar);
        return jar;
    }

    private Jar toJar(Processor context, String path) throws Exception {
        if (path == null) {
            return null;
        }
        File f = context.getFile(path);
        if (f.exists()) {
            return new Jar(f);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(Release releaser, Revision revision, Jar jar, String classifier) throws Exception {
        String extension = IO.getExtension(jar.getName(), "jar");
        File tmp = File.createTempFile(classifier, extension);
        try {
            jar.write(tmp);
            releaser.add(revision.archive(extension, classifier), tmp);
        }
        finally {
            tmp.delete();
        }
    }

    private ReleaseDTO getReleaseDTO(Processor context) {
        Attrs pom;
        Attrs sources;
        ReleaseDTO release = new ReleaseDTO();
        if (context == null) {
            return release;
        }
        Parameters p = new Parameters(context.getProperty("-maven-release"));
        release.type = this.storage.isLocalOnly() ? ReleaseDTO.ReleaseType.LOCAL : ReleaseDTO.ReleaseType.REMOTE;
        Attrs attrs = p.remove("remote");
        if (attrs != null) {
            release.type = ReleaseDTO.ReleaseType.REMOTE;
            String s = attrs.get("snapshot");
            if (s != null) {
                release.snapshot = Long.parseLong(s);
            }
        } else {
            attrs = p.remove("local");
            if (attrs != null) {
                release.type = ReleaseDTO.ReleaseType.LOCAL;
            }
        }
        Attrs javadoc = p.remove("javadoc");
        if (javadoc != null) {
            release.javadoc.path = javadoc.get("path");
            if (NONE.equals(release.javadoc.path)) {
                release.javadoc = null;
            } else {
                release.javadoc.options = javadoc;
            }
        }
        if ((sources = p.remove("sources")) != null) {
            release.sources.path = sources.get("path");
            if (NONE.equals(release.sources.path)) {
                release.sources = null;
            }
        }
        if ((pom = p.remove("pom")) != null) {
            release.pom.path = pom.get("path");
        }
        if (!p.isEmpty()) {
            this.reporter.warning("The -maven-release instruction contains unrecognized options: %s", new Object[]{p});
        }
        return release;
    }

    private Resource getPomResource(Jar jar) {
        for (Map.Entry e : jar.getResources().entrySet()) {
            String path = (String)e.getKey();
            if (!path.startsWith("META-INF/maven/") || !path.endsWith("/pom.xml")) continue;
            return (Resource)e.getValue();
        }
        return null;
    }

    private Resource createPomResource(Jar binary, Processor context) throws Exception {
        Manifest manifest = binary.getManifest();
        if (manifest == null) {
            return null;
        }
        try (Processor scoped = context == null ? new Processor() : new Processor(context);){
            if (scoped.getProperty("-groupid") == null) {
                scoped.setProperty("-groupid", "osgi-bundle");
            }
            PomResource pomResource = new PomResource(scoped, manifest);
            return pomResource;
        }
    }

    public File get(String bsn, Version version, Map<String, String> properties, final RepositoryPlugin.DownloadListener ... listeners) throws Exception {
        this.init();
        IndexFile.BundleDescriptor descriptor = this.index.getDescriptor(bsn, version);
        if (descriptor == null) {
            return null;
        }
        Archive archive = descriptor.archive;
        if (archive != null) {
            final File file = this.storage.toLocalFile(archive);
            File withSources = new File(file.getParentFile(), "+" + file.getName());
            if (withSources.isFile() && withSources.lastModified() > file.lastModified()) {
                if (listeners.length == 0) {
                    return withSources;
                }
                for (RepositoryPlugin.DownloadListener dl : listeners) {
                    dl.success(withSources);
                }
                return withSources;
            }
            Promise<File> promise = this.index.updateAsync(descriptor, this.storage.get(archive));
            if (listeners.length == 0) {
                return (File)promise.getValue();
            }
            promise.then((Success)new Success<File, Void>(){

                public Promise<Void> call(Promise<File> resolved) throws Exception {
                    File value = (File)resolved.getValue();
                    for (RepositoryPlugin.DownloadListener dl : listeners) {
                        try {
                            dl.success(value);
                        }
                        catch (Exception e) {
                            MavenBndRepository.this.reporter.exception((Throwable)e, "Download listener failed in success callback %s", new Object[]{dl});
                        }
                    }
                    return null;
                }
            }, new Failure(){

                public void fail(Promise<?> resolved) throws Exception {
                    String reason = resolved.getFailure().toString();
                    for (RepositoryPlugin.DownloadListener dl : listeners) {
                        try {
                            dl.failure(file, reason);
                        }
                        catch (Exception e) {
                            MavenBndRepository.this.reporter.exception((Throwable)e, "Download listener failed in failure callback %s", new Object[]{dl});
                        }
                    }
                }
            });
            return file;
        }
        return null;
    }

    public boolean canWrite() {
        return !this.configuration.readOnly();
    }

    public List<String> list(String pattern) throws Exception {
        this.init();
        Glob g = pattern == null ? null : new Glob(pattern);
        ArrayList<String> bsns = new ArrayList<String>();
        for (String bsn : this.index.list()) {
            if (g != null && !g.matcher(bsn).matches()) continue;
            bsns.add(bsn);
        }
        return bsns;
    }

    public SortedSet<Version> versions(String bsn) throws Exception {
        this.init();
        TreeSet<Version> versions = new TreeSet<Version>();
        for (Version version : this.index.list(bsn)) {
            versions.add(version);
        }
        return versions;
    }

    public String getName() {
        this.init();
        return this.name;
    }

    private synchronized void init() {
        try {
            Workspace ws;
            if (this.inited) {
                return;
            }
            this.client = (HttpClient)this.registry.getPlugin(HttpClient.class);
            this.inited = true;
            this.name = this.configuration.name("Maven");
            this.localRepo = IO.getFile(this.configuration.local(MAVEN_REPO_LOCAL));
            List<MavenBackingRepository> release = MavenBackingRepository.create(this.configuration.releaseUrl(), this.reporter, this.localRepo, this.client);
            List<MavenBackingRepository> snapshot = MavenBackingRepository.create(this.configuration.snapshotUrl(), this.reporter, this.localRepo, this.client);
            this.storage = new MavenRepository(this.localRepo, this.getName(), release, snapshot, Processor.getExecutor(), this.reporter, this.getRefreshCallback());
            File base = IO.work;
            if (this.registry != null && (ws = (Workspace)this.registry.getPlugin(Workspace.class)) != null) {
                base = ws.getBuildDir();
            }
            File indexFile = IO.getFile(base, this.configuration.index(this.name.toLowerCase() + ".mvn"));
            IndexFile ixf = new IndexFile(this.reporter, indexFile, this.storage);
            ixf.open();
            this.index = ixf;
            this.startPoll(this.index);
            this.reporter.trace("Maven Bnd repository initing %s", new Object[]{this});
        }
        catch (Exception e) {
            this.reporter.exception((Throwable)e, "Init for maven repo failed %s", new Object[]{this.configuration});
            throw new RuntimeException(e);
        }
    }

    private void startPoll(IndexFile index) {
        Workspace ws = (Workspace)this.registry.getPlugin(Workspace.class);
        if (ws != null && (ws.getGestalt().containsKey("batch") || ws.getGestalt().containsKey("ci") || ws.getGestalt().containsKey("offline"))) {
            return;
        }
        final AtomicBoolean busy = new AtomicBoolean();
        this.indexPoller = Processor.getScheduledExecutor().scheduleAtFixedRate(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (busy.getAndSet(true)) {
                    return;
                }
                try {
                    MavenBndRepository.this.poll();
                }
                catch (Exception e) {
                    MavenBndRepository.this.reporter.error("Error when polling index for %s for change", new Object[]{this});
                }
                finally {
                    busy.set(false);
                }
            }
        }, 5000L, 5000L, TimeUnit.MILLISECONDS);
    }

    void poll() throws Exception {
        if (this.index.refresh()) {
            for (RepositoryListenerPlugin listener : this.registry.getPlugins(RepositoryListenerPlugin.class)) {
                listener.repositoryRefreshed((RepositoryPlugin)this);
            }
        }
    }

    public String getLocation() {
        return this.configuration.releaseUrl() == null ? this.configuration.local(MAVEN_REPO_LOCAL) : this.configuration.releaseUrl();
    }

    public void setProperties(Map<String, String> map) throws Exception {
        this.configuration = Converter.cnv(Configuration.class, map);
    }

    public void setReporter(Reporter reporter) {
        this.reporter = reporter;
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    @Override
    public void close() throws IOException {
        if (this.storage != null) {
            this.storage.close();
        }
        if (this.indexPoller != null) {
            this.indexPoller.cancel(true);
        }
    }

    private Callable<Boolean> getRefreshCallback() {
        return new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                for (RepositoryListenerPlugin rp : MavenBndRepository.this.registry.getPlugins(RepositoryListenerPlugin.class)) {
                    try {
                        rp.repositoryRefreshed((RepositoryPlugin)MavenBndRepository.this);
                    }
                    catch (Exception e) {
                        MavenBndRepository.this.reporter.exception((Throwable)e, "Updating listener plugin %s", new Object[]{rp});
                    }
                }
                return MavenBndRepository.this.ok;
            }
        };
    }

    public boolean refresh() throws Exception {
        return this.index.refresh();
    }

    public File getRoot() throws Exception {
        return this.localRepo;
    }

    public IndexFile.BundleDescriptor getDescriptor(String bsn, Version version) throws Exception {
        return this.index.getDescriptor(bsn, version);
    }

    public String toString() {
        return "MavenBndRepository [localRepo=" + this.localRepo + ", storage=" + this.getName() + ", inited=" + this.inited + "]";
    }

    public Map<String, Runnable> actions(Object ... target) throws Exception {
        switch (target.length) {
            case 0: {
                return null;
            }
            case 1: {
                return this.actions.getProgramActions((String)target[0]);
            }
            case 2: {
                IndexFile.BundleDescriptor bd = this.getBundleDescriptor(target);
                return this.actions.getRevisionActions(bd);
            }
        }
        return null;
    }

    public String tooltip(Object ... target) throws Exception {
        switch (target.length) {
            case 0: {
                try (Formatter f = new Formatter();){
                    f.format("%s\n", this.getName());
                    f.format("Revisions %s\n", this.index.descriptors.size());
                    for (MavenBackingRepository mbr : this.storage.getReleaseRepositories()) {
                        f.format("Release %s  (%s)\n", mbr, this.getUser(mbr));
                    }
                    for (MavenBackingRepository mbr : this.storage.getSnapshotRepositories()) {
                        f.format("Snapshot %s (%s)\n", mbr, this.getUser(mbr));
                    }
                    f.format("Storage %s\n", this.localRepo);
                    f.format("Index %s\n", this.index.indexFile);
                    f.format("Index Cache %s\n", this.index.cacheDir);
                    String i$ = f.toString();
                    return i$;
                }
            }
            case 1: {
                try (Formatter f = new Formatter();){
                    String name = (String)target[0];
                    Set<Program> programs = this.index.getProgramsForBsn(name);
                    String string = programs.toString();
                    return string;
                }
            }
            case 2: {
                IndexFile.BundleDescriptor bd = this.getBundleDescriptor(target);
                try (Formatter f = new Formatter();){
                    f.format("%s\n", bd.archive);
                    f.format("Bundle-Version %s\n", bd.version);
                    f.format("Last Modified %s\n", new Date(bd.lastModified));
                    f.format("URL %s\n", bd.url);
                    f.format("SHA-1 %s\n", Hex.toHexString(bd.id).toLowerCase());
                    f.format("SHA-256 %s\n", Hex.toHexString(bd.sha256).toLowerCase());
                    File localFile = this.storage.toLocalFile(bd.archive);
                    f.format("Local %s%s\n", localFile, localFile.isFile() ? "" : " ?");
                    if (bd.description != null) {
                        f.format("Description\n%s", bd.description);
                    }
                    String string = f.toString();
                    return string;
                }
            }
        }
        return null;
    }

    private Object getUser(MavenBackingRepository remote) {
        if (remote == null) {
            return "";
        }
        try {
            return remote.getUser();
        }
        catch (Exception e) {
            return "error: " + e.toString();
        }
    }

    IndexFile.BundleDescriptor getBundleDescriptor(Object ... target) throws Exception {
        String bsn = (String)target[0];
        Version version = (Version)target[1];
        IndexFile.BundleDescriptor bd = this.getDescriptor(bsn, version);
        return bd;
    }

    public String title(Object ... target) throws Exception {
        switch (target.length) {
            case 0: {
                String name = this.getName();
                int n = this.index.getErrors(null);
                if (n > 0) {
                    name = name + " [" + n + "!]";
                    return name;
                }
                return name;
            }
            case 1: {
                String name = (String)target[0];
                int n = this.index.getErrors(name);
                if (n > 0) {
                    name = name + " [!]";
                }
                return name;
            }
            case 2: {
                IndexFile.BundleDescriptor bd = this.getBundleDescriptor(target);
                if (bd.error != null) {
                    return bd.version + " [" + bd.error + "]";
                }
                if (this.isLocal(bd.archive)) {
                    return bd.version.toString();
                }
                return bd.version.toString() + " [?]";
            }
        }
        return null;
    }

    private boolean isLocal(Archive archive) {
        return this.storage.toLocalFile(archive).isFile();
    }

    public boolean dropTarget(URI uri) throws Exception {
        String t = uri.toString().trim();
        int n = t.indexOf(10);
        if (n > 0) {
            uri = new URI(t.substring(0, n));
            this.reporter.trace("dropTarget cleaned up from %s to %s", new Object[]{t, uri});
        }
        if ("search.maven.org".equals(uri.getHost()) && "/remotecontent".equals(uri.getPath())) {
            return this.doSearchMaven(uri);
        }
        if (uri.getPath() != null && uri.getPath().endsWith(".pom")) {
            return this.addPom(uri);
        }
        return this.doJpm(uri);
    }

    public boolean dropTarget(File file) throws Exception {
        if (file.getName().equals("pom.xml")) {
            return this.addPom(file.toURI());
        }
        return false;
    }

    private boolean addPom(URI uri) throws Exception {
        try {
            IPom pom = this.storage.getPom(this.client.connect(uri.toURL()));
            Archive binaryArchive = pom.binaryArchive();
            this.index.add(binaryArchive);
            return true;
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (Exception e) {
            this.reporter.trace("Failure to parse %s: %s", new Object[]{uri, e});
            return false;
        }
    }

    boolean doSearchMaven(URI uri) throws UnsupportedEncodingException, Exception {
        Archive archive;
        Map<String, String> map = this.getMapFromQuery(uri);
        String filePath = map.get("filepath");
        if (filePath != null && (archive = Archive.fromFilepath(filePath)) != null) {
            if (archive.extension.equals("pom")) {
                archive = archive.revision.archive("jar", null);
            }
            this.index.add(archive);
            return true;
        }
        return false;
    }

    Map<String, String> getMapFromQuery(URI uri) throws UnsupportedEncodingException {
        String rawQuery = uri.getRawQuery();
        HashMap<String, String> map = new HashMap<String, String>();
        if (rawQuery != null) {
            String[] parts;
            for (String part : parts = rawQuery.split("&")) {
                String value;
                String[] kv = part.split("=");
                String key = URLDecoder.decode(kv[0], "UTF-8");
                String previous = map.put(key, value = kv.length > 1 ? URLDecoder.decode(kv[1], "UTF-8") : "");
                if (previous == null) continue;
                map.put(key, previous + "," + value);
            }
        }
        return map;
    }

    JpmRepo getLibrary() throws Exception {
        if (this.libraryx == null) {
            HttpClient client = (HttpClient)this.registry.getPlugin(HttpClient.class);
            this.libraryx = JSONRPCProxy.createRPC(JpmRepo.class, client, new URI("http://repo.jpm4j.org/jsonrpc/2.0/jpm"));
        }
        return this.libraryx;
    }

    boolean doJpm(URI uri) {
        Matcher m = this.JPM_REVISION_URL_PATTERN_P.matcher(uri.toString());
        if (m.matches()) {
            try {
                byte[] sha1 = Hex.toByteArray(m.group("sha"));
                Library.Revision revision = this.getLibrary().getRevision(sha1);
                if (revision != null) {
                    Archive a = Program.valueOf(revision.groupId, revision.artifactId).version(revision.version).archive("jar", revision.classifier);
                    this.index.add(a);
                    return true;
                }
            }
            catch (Exception e) {
                this.reporter.exception((Throwable)e, "Cannot drop JPM %s", new Object[]{uri});
            }
        }
        return false;
    }

    public void toPom(OutputStream out, PomOptions options) throws Exception {
        this.init();
        PomGenerator pg = new PomGenerator(this.index.getArchives());
        pg.name(Revision.valueOf(options.gav)).parent(Revision.valueOf(options.parent)).dependencyManagement(options.dependencyManagement).out(out);
    }

    public Map<Requirement, Collection<Capability>> findProviders(Collection<? extends Requirement> requirements) {
        this.init();
        return this.index.findProviders(requirements);
    }
}

