/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gwt.model.impl.sdk;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.VersionComparatorUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.gwt.model.GwtSdkPaths;
import org.jetbrains.jps.gwt.model.impl.sdk.GwtSdkPathUtil;
import org.jetbrains.jps.util.JpsPathUtil;

public class GwtMavenSdkPaths
implements GwtSdkPaths {
    @NonNls
    public static final String TYPE_ID = "maven";
    private final String myBasePath;
    private final String myVersion;
    private final String myDevDirPath;
    private final String myRepositoryPath;

    public GwtMavenSdkPaths(String homeDirectoryPath, String version) {
        this.myDevDirPath = homeDirectoryPath;
        this.myBasePath = PathUtilRt.getParentPath((String)PathUtilRt.getParentPath((String)homeDirectoryPath));
        this.myVersion = version;
        this.myRepositoryPath = PathUtilRt.getParentPath((String)PathUtilRt.getParentPath((String)PathUtilRt.getParentPath((String)this.myBasePath)));
    }

    public static String getPlatformId() {
        return SystemInfo.isMac ? "mac" : (SystemInfo.isLinux ? "linux" : "windows");
    }

    @Override
    @NotNull
    public String getDevJarPath(boolean systemIndependent) {
        String platformSuffix = VersionComparatorUtil.compare((String)this.myVersion, (String)"2.0") >= 0 ? "" : "-" + GwtMavenSdkPaths.getPlatformId();
        String string = new File(this.myDevDirPath, "gwt-dev-" + this.myVersion + platformSuffix + ".jar").getAbsolutePath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/model/impl/sdk/GwtMavenSdkPaths", "getDevJarPath"));
        }
        return string;
    }

    @Override
    public String getCodeServerJarPath() {
        return this.getJarPath("gwt-codeserver");
    }

    @Override
    @NotNull
    public String getHomeDirectoryUrl() {
        String string = JpsPathUtil.pathToUrl((String)this.myDevDirPath);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/model/impl/sdk/GwtMavenSdkPaths", "getHomeDirectoryUrl"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getServletJarPath() {
        String string = this.getJarPath("gwt-servlet");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/model/impl/sdk/GwtMavenSdkPaths", "getServletJarPath"));
        }
        return string;
    }

    private String getJarPath(String name) {
        return new File(this.myBasePath, name + "/" + this.myVersion + "/" + name + "-" + this.myVersion + ".jar").getAbsolutePath();
    }

    @Override
    @NotNull
    public String getUserJarPath() {
        String string = this.getJarPath("gwt-user");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/model/impl/sdk/GwtMavenSdkPaths", "getUserJarPath"));
        }
        return string;
    }

    public String getVersion() {
        return this.myVersion;
    }

    @Override
    @NotNull
    public List<String> getAdditionalCompilerJars() {
        String preferredVersion;
        ArrayList<String> additionalJars = new ArrayList<String>();
        additionalJars.addAll(GwtSdkPathUtil.findValidationJarsInMavenRepo(this.myRepositoryPath));
        if (VersionComparatorUtil.compare((String)this.myVersion, (String)"2.7.0") >= 0) {
            for (String[] dependency : GwtSdkPathUtil.DEFAULT_ADDITIONAL_2_7_DEPENDENCIES) {
                preferredVersion = dependency.length > 2 ? dependency[2] : null;
                ContainerUtil.addIfNotNull(additionalJars, (Object)this.getArtifactPath(dependency[0], dependency[1], preferredVersion));
            }
        }
        if (VersionComparatorUtil.compare((String)this.myVersion, (String)"2.8.0-beta1") > 0) {
            for (String[] dependency : GwtSdkPathUtil.DEFAULT_ADDITIONAL_2_8_DEPENDENCIES) {
                preferredVersion = dependency.length > 2 ? dependency[2] : null;
                ContainerUtil.addIfNotNull(additionalJars, (Object)this.getArtifactPath(dependency[0], dependency[1], preferredVersion));
            }
        }
        ArrayList<String> arrayList = additionalJars;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/model/impl/sdk/GwtMavenSdkPaths", "getAdditionalCompilerJars"));
        }
        return arrayList;
    }

    @Nullable
    public String getArtifactPath(@NotNull String groupId, @NotNull String artifactId, @Nullable String preferredVersion) {
        String version;
        File jar;
        if (groupId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupId", "org/jetbrains/jps/gwt/model/impl/sdk/GwtMavenSdkPaths", "getArtifactPath"));
        }
        if (artifactId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactId", "org/jetbrains/jps/gwt/model/impl/sdk/GwtMavenSdkPaths", "getArtifactPath"));
        }
        File dir = new File(FileUtil.toSystemDependentName((String)(this.myRepositoryPath + "/" + groupId.replace('.', '/') + "/" + artifactId)));
        String[] dirNames = dir.list();
        if (dirNames != null && dirNames.length > 0 && (jar = new File(dir, (version = StringUtil.isNotEmpty((String)preferredVersion) && ArrayUtil.contains((String)preferredVersion, (String[])dirNames) ? preferredVersion : Collections.max(Arrays.asList(dirNames), VersionComparatorUtil.COMPARATOR)) + "/" + artifactId + "-" + version + ".jar")).isFile()) {
            return jar.getAbsolutePath();
        }
        return null;
    }
}

