/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac;

import com.sun.tools.javac.file.BaseFileObject;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.file.RelativePath;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;

class OptimizedFileManager17
extends JavacFileManager {
    private boolean myUseZipFileIndex;
    private final Map<File, JavacFileManager.Archive> myArchives;
    private final Map<File, Boolean> myIsFile = new HashMap<File, Boolean>();
    private final Map<File, File[]> myDirectoryCache = new HashMap<File, File[]>();
    public static final File[] NULL_FILE_ARRAY = new File[0];
    private static final String _OS_NAME = System.getProperty("os.name").toLowerCase(Locale.US);
    private static final boolean isWindows = _OS_NAME.startsWith("windows");
    private static final boolean isOS2 = _OS_NAME.startsWith("os/2") || _OS_NAME.startsWith("os2");
    private static final boolean isMac = _OS_NAME.startsWith("mac");
    private static final boolean isFileSystemCaseSensitive = !isWindows && !isOS2 && !isMac;
    private static final boolean ourUseContentCache = Boolean.valueOf(System.getProperty("javac.use.content.cache", "false"));

    public OptimizedFileManager17() throws Throwable {
        super(new Context(), true, null);
        Field archivesField = JavacFileManager.class.getDeclaredField("archives");
        archivesField.setAccessible(true);
        this.myArchives = (Map)archivesField.get(this);
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromFiles(Iterable<? extends File> files) {
        ArrayList<InputFileObject> result = files instanceof Collection ? new ArrayList(((Collection)files).size()) : new ArrayList<InputFileObject>();
        for (File file : files) {
            result.add(new InputFileObject(this, file));
        }
        return result;
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        Iterable<? extends File> locationRoots = this.getLocation(location);
        if (locationRoots == null) {
            return List.nil();
        }
        RelativePath.RelativeDirectory subdirectory = new RelativePath.RelativeDirectory(packageName.replace('.', '/'));
        ListBuffer<JavaFileObject> results = new ListBuffer<JavaFileObject>();
        for (File file : locationRoots) {
            JavacFileManager.Archive archive = this.myArchives.get(file);
            boolean isFile = archive != null ? true : this.isFile(file);
            if (isFile) {
                try {
                    if (archive == null) {
                        archive = this.openArchive(file);
                    }
                    OptimizedFileManager17.listArchive(archive, subdirectory, kinds, recurse, results);
                }
                catch (IOException ex) {
                    this.log.error("error.reading.file", file, OptimizedFileManager17.getMessage(ex));
                }
                continue;
            }
            File dir = subdirectory.getFile(file);
            if (recurse) {
                this.listDirectoryRecursively(dir, kinds, results, true);
                continue;
            }
            this.listDirectory(dir, kinds, results);
        }
        return results.toList();
    }

    private static void listArchive(JavacFileManager.Archive archive, RelativePath.RelativeDirectory subdirectory, Set<JavaFileObject.Kind> fileKinds, boolean recurse, ListBuffer<JavaFileObject> resultList) {
        List files = archive.getFiles(subdirectory);
        if (files != null) {
            while (!files.isEmpty()) {
                String file = (String)files.head;
                if (OptimizedFileManager17.isValidFile(file, fileKinds)) {
                    resultList.append(archive.getFileObject(subdirectory, file));
                }
                files = files.tail;
            }
        }
        if (recurse) {
            for (RelativePath.RelativeDirectory s : archive.getSubdirectories()) {
                if (!OptimizedFileManager17.contains(subdirectory, s)) continue;
                OptimizedFileManager17.listArchive(archive, s, fileKinds, false, resultList);
            }
        }
    }

    private void listDirectory(File directory, Set<JavaFileObject.Kind> fileKinds, ListBuffer<JavaFileObject> resultList) {
        File[] files = this.listChildren(directory);
        if (files != null) {
            if (this.sortFiles != null) {
                Arrays.sort(files, this.sortFiles);
            }
            boolean acceptUnknownFiles = fileKinds.contains((Object)JavaFileObject.Kind.OTHER);
            for (File f : files) {
                String fileName = f.getName();
                if (!OptimizedFileManager17.isValidFile(fileName, fileKinds) || acceptUnknownFiles && !this.isFile(f)) continue;
                InputFileObject fe = new InputFileObject(this, f);
                resultList.append((JavaFileObject)((Object)fe));
            }
        }
    }

    private void listDirectoryRecursively(File file, Set<JavaFileObject.Kind> fileKinds, ListBuffer<JavaFileObject> resultList, boolean isRootCall) {
        File[] children = this.listChildren(file);
        String fileName = file.getName();
        if (children != null) {
            if (isRootCall || SourceVersion.isIdentifier(fileName)) {
                if (this.sortFiles != null) {
                    Arrays.sort(children, this.sortFiles);
                }
                for (File child : children) {
                    this.listDirectoryRecursively(child, fileKinds, resultList, false);
                }
            }
        } else if (OptimizedFileManager17.isValidFile(fileName, fileKinds)) {
            InputFileObject fe = new InputFileObject(this, file);
            resultList.append((JavaFileObject)((Object)fe));
        }
    }

    private File[] listChildren(File file) {
        File[] cached = this.myDirectoryCache.get(file);
        if (cached == null) {
            cached = file.listFiles();
            this.myDirectoryCache.put(file, cached != null ? cached : NULL_FILE_ARRAY);
        }
        return cached == NULL_FILE_ARRAY ? null : cached;
    }

    public void fileGenerated(File file) {
        File parent = file.getParentFile();
        if (parent != null) {
            this.myDirectoryCache.remove(parent);
        }
    }

    private boolean isFile(File root) {
        Boolean cachedIsFile = this.myIsFile.get(root);
        if (cachedIsFile == null) {
            cachedIsFile = root.isFile();
            this.myIsFile.put(root, cachedIsFile);
        }
        return cachedIsFile;
    }

    private static boolean contains(RelativePath.RelativeDirectory subdirectory, RelativePath.RelativeDirectory other) {
        String subdirPath = subdirectory.getPath();
        String otherPath = other.getPath();
        return otherPath.length() > subdirPath.length() && otherPath.startsWith(subdirPath);
    }

    private static boolean isValidFile(String name, Set<JavaFileObject.Kind> fileKinds) {
        return fileKinds.contains((Object)OptimizedFileManager17.getKind(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            super.close();
        }
        finally {
            this.myDirectoryCache.clear();
            this.myIsFile.clear();
        }
    }

    private static class InputFileObject
    extends BaseFileObject {
        private static final JavaFileObject.Kind[] ourAvailableKinds = JavaFileObject.Kind.values();
        private final String name;
        private final File file;
        private final JavaFileObject.Kind kind;
        private Reference<File> absFileRef;

        public InputFileObject(JavacFileManager fileManager, File f) {
            this(fileManager, f.getName(), f);
        }

        public InputFileObject(JavacFileManager fileManager, String name, File f) {
            super(fileManager);
            this.name = name;
            this.file = f;
            this.kind = InputFileObject.findKind(name);
        }

        public URI toUri() {
            try {
                return InputFileObject.convertToURI(this.file.getPath());
            }
            catch (Throwable e) {
                return this.file.toURI().normalize();
            }
        }

        private static URI convertToURI(String localPath) throws URISyntaxException {
            String p = localPath.replace('\\', '/');
            if (!p.startsWith("/")) {
                p = "/" + p;
            }
            if (!p.startsWith("//")) {
                p = "//" + p;
            }
            return new URI("file", null, p, null);
        }

        public String getName() {
            return this.file.getPath();
        }

        public String getShortName() {
            return this.name;
        }

        public JavaFileObject.Kind getKind() {
            return this.kind;
        }

        private static JavaFileObject.Kind findKind(String name) {
            for (JavaFileObject.Kind kind : ourAvailableKinds) {
                if (kind == JavaFileObject.Kind.OTHER || !name.endsWith(kind.extension)) continue;
                return kind;
            }
            return JavaFileObject.Kind.OTHER;
        }

        public InputStream openInputStream() throws IOException {
            return new FileInputStream(this.file);
        }

        public OutputStream openOutputStream() throws IOException {
            throw new UnsupportedOperationException();
        }

        public Writer openWriter() throws IOException {
            throw new UnsupportedOperationException();
        }

        public long getLastModified() {
            return this.file.lastModified();
        }

        public boolean delete() {
            return this.file.delete();
        }

        protected CharsetDecoder getDecoder(boolean ignoreEncodingErrors) {
            return this.fileManager.getDecoder(this.fileManager.getEncodingName(), ignoreEncodingErrors);
        }

        protected String inferBinaryName(Iterable<? extends File> path) {
            String fPath = this.file.getPath();
            for (File file : path) {
                int separatorIdx;
                String dirPath = file.getPath();
                if (dirPath.length() == 0) {
                    dirPath = System.getProperty("user.dir");
                }
                if (!fPath.regionMatches(!isFileSystemCaseSensitive, 0, dirPath, 0, dirPath.length())) continue;
                int pathLength = fPath.length();
                boolean endsWithSeparator = dirPath.endsWith(File.separator);
                if (!endsWithSeparator && (pathLength <= (separatorIdx = dirPath.length()) || fPath.charAt(separatorIdx) != File.separatorChar)) continue;
                int startIndex = endsWithSeparator ? dirPath.length() : dirPath.length() + 1;
                int endIndex = fPath.lastIndexOf(46);
                if (endIndex <= startIndex) {
                    endIndex = fPath.length();
                }
                int length = endIndex - startIndex;
                StringBuilder buf = new StringBuilder(length).append(fPath, startIndex, endIndex);
                for (int idx = 0; idx < length; ++idx) {
                    if (buf.charAt(idx) != File.separatorChar) continue;
                    buf.setCharAt(idx, '.');
                }
                return buf.toString();
            }
            return null;
        }

        public boolean isNameCompatible(String cn, JavaFileObject.Kind kind) {
            cn.getClass();
            if (kind == JavaFileObject.Kind.OTHER && this.getKind() != kind) {
                return false;
            }
            String n = cn + kind.extension;
            if (this.name.equals(n)) {
                return true;
            }
            if (this.name.equalsIgnoreCase(n)) {
                try {
                    return n.equals(this.file.toPath().toRealPath(LinkOption.NOFOLLOW_LINKS).getFileName().toString());
                }
                catch (IOException ignored) {
                    // empty catch block
                }
            }
            return false;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof InputFileObject)) {
                return false;
            }
            InputFileObject o = (InputFileObject)((Object)other);
            return this.getAbsoluteFile().equals(o.getAbsoluteFile());
        }

        public int hashCode() {
            return this.getAbsoluteFile().hashCode();
        }

        private File getAbsoluteFile() {
            File absFile;
            File file = absFile = this.absFileRef == null ? null : this.absFileRef.get();
            if (absFile == null) {
                absFile = this.file.getAbsoluteFile();
                this.absFileRef = new SoftReference<File>(absFile);
            }
            return absFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CharBuffer getCharContent(boolean ignoreEncodingErrors) throws IOException {
            CharBuffer cb;
            CharBuffer charBuffer = cb = ourUseContentCache ? this.fileManager.getCachedContent((JavaFileObject)((Object)this)) : null;
            if (cb == null) {
                FileInputStream in = new FileInputStream(this.file);
                try {
                    ByteBuffer bb = this.fileManager.makeByteBuffer(in);
                    JavaFileObject prev = this.fileManager.log.useSource((JavaFileObject)((Object)this));
                    try {
                        cb = this.fileManager.decode(bb, ignoreEncodingErrors);
                    }
                    finally {
                        this.fileManager.log.useSource(prev);
                    }
                    this.fileManager.recycleByteBuffer(bb);
                    if (ourUseContentCache && !ignoreEncodingErrors) {
                        this.fileManager.cache((JavaFileObject)((Object)this), cb);
                    }
                }
                finally {
                    ((InputStream)in).close();
                }
            }
            return cb;
        }
    }
}

