/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.bundlor.blint.support.contributors;

import com.springsource.bundlor.blint.support.Validator;
import com.springsource.bundlor.util.BundleManifestUtils;
import com.springsource.util.osgi.manifest.BundleManifest;
import com.springsource.util.osgi.manifest.ImportedPackage;
import com.springsource.util.parser.manifest.ManifestContents;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VersionedImportsValidator
implements Validator {
    private static final String MESSAGE = "The import of package %s does not specify a version";

    @Override
    public Set<String> validate(ManifestContents manifest) {
        BundleManifest bundleManifest = BundleManifestUtils.createBundleManifest(manifest);
        HashSet<String> warnings = new HashSet<String>();
        for (ImportedPackage packageImport : bundleManifest.getImportPackage().getImportedPackages()) {
            if (packageImport.getAttributes().get("version") != null) continue;
            warnings.add(String.format(MESSAGE, packageImport.getPackageName()));
        }
        return warnings;
    }
}

