/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.osgi.jps.model.impl;

import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.ex.JpsElementBase;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.osgi.jps.model.JpsOsmorcExtensionService;
import org.jetbrains.osgi.jps.model.JpsOsmorcModuleExtension;
import org.jetbrains.osgi.jps.model.JpsOsmorcProjectExtension;
import org.jetbrains.osgi.jps.model.ManifestGenerationMode;
import org.jetbrains.osgi.jps.model.OsmorcJarContentEntry;
import org.jetbrains.osgi.jps.model.OutputPathType;
import org.jetbrains.osgi.jps.model.impl.JpsOsmorcProjectExtensionImpl;
import org.jetbrains.osgi.jps.model.impl.OsmorcModuleExtensionProperties;
import org.jetbrains.osgi.jps.util.OsgiBuildUtil;

public class JpsOsmorcModuleExtensionImpl
extends JpsElementBase<JpsOsmorcModuleExtensionImpl>
implements JpsOsmorcModuleExtension {
    private final OsmorcModuleExtensionProperties myProperties;
    private final NullableLazyValue<File> myDescriptorFile = new NullableLazyValue<File>(){

        protected File compute() {
            if (((JpsOsmorcModuleExtensionImpl)JpsOsmorcModuleExtensionImpl.this).myProperties.myManifestGenerationMode == ManifestGenerationMode.Bnd) {
                return OsgiBuildUtil.findFileInModuleContentRoots(JpsOsmorcModuleExtensionImpl.this.getModule(), JpsOsmorcModuleExtensionImpl.this.getBndFileLocation());
            }
            if (((JpsOsmorcModuleExtensionImpl)JpsOsmorcModuleExtensionImpl.this).myProperties.myManifestGenerationMode == ManifestGenerationMode.Bundlor) {
                return OsgiBuildUtil.findFileInModuleContentRoots(JpsOsmorcModuleExtensionImpl.this.getModule(), JpsOsmorcModuleExtensionImpl.this.getBundlorFileLocation());
            }
            if (((JpsOsmorcModuleExtensionImpl)JpsOsmorcModuleExtensionImpl.this).myProperties.myManifestGenerationMode == ManifestGenerationMode.Manually) {
                return OsgiBuildUtil.findFileInModuleContentRoots(JpsOsmorcModuleExtensionImpl.this.getModule(), JpsOsmorcModuleExtensionImpl.this.getManifestLocation());
            }
            return null;
        }
    };

    public JpsOsmorcModuleExtensionImpl(OsmorcModuleExtensionProperties properties) {
        this.myProperties = properties;
    }

    public OsmorcModuleExtensionProperties getProperties() {
        return this.myProperties;
    }

    @NotNull
    public JpsOsmorcModuleExtensionImpl createCopy() {
        JpsOsmorcModuleExtensionImpl jpsOsmorcModuleExtensionImpl = new JpsOsmorcModuleExtensionImpl((OsmorcModuleExtensionProperties)XmlSerializerUtil.createCopy((Object)this.myProperties));
        if (jpsOsmorcModuleExtensionImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/osgi/jps/model/impl/JpsOsmorcModuleExtensionImpl", "createCopy"));
        }
        return jpsOsmorcModuleExtensionImpl;
    }

    public void applyChanges(@NotNull JpsOsmorcModuleExtensionImpl modified) {
        if (modified == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modified", "org/jetbrains/osgi/jps/model/impl/JpsOsmorcModuleExtensionImpl", "applyChanges"));
        }
        XmlSerializerUtil.copyBean((Object)modified.myProperties, (Object)this.myProperties);
    }

    @Override
    @NotNull
    public String getJarFileLocation() {
        String nullSafeLocation;
        String jarFileLocation = this.myProperties.myJarFileLocation;
        OutputPathType outputPathType = this.myProperties.myOutputPathType;
        String string = nullSafeLocation = jarFileLocation != null ? jarFileLocation : "";
        if (outputPathType == null) {
            String string2 = nullSafeLocation;
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/osgi/jps/model/impl/JpsOsmorcModuleExtensionImpl", "getJarFileLocation"));
            }
            return string2;
        }
        switch (outputPathType) {
            case CompilerOutputPath: {
                File outputDir = JpsJavaExtensionService.getInstance().getOutputDirectory(this.getModule(), false);
                String string3 = outputDir != null ? new File(outputDir.getParent(), nullSafeLocation).getAbsolutePath() : nullSafeLocation;
                if (string3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/osgi/jps/model/impl/JpsOsmorcModuleExtensionImpl", "getJarFileLocation"));
                }
                return string3;
            }
            case OsgiOutputPath: {
                String bundlesOutputPath;
                JpsOsmorcProjectExtension projectExtension = this.getProjectExtension();
                if (projectExtension != null && !StringUtil.isEmptyOrSpaces((String)(bundlesOutputPath = projectExtension.getBundlesOutputPath()))) {
                    String string4 = bundlesOutputPath + "/" + nullSafeLocation;
                    if (string4 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/osgi/jps/model/impl/JpsOsmorcModuleExtensionImpl", "getJarFileLocation"));
                    }
                    return string4;
                }
                String string5 = JpsOsmorcProjectExtensionImpl.getDefaultBundlesOutputPath(this.getModule().getProject()) + "/" + nullSafeLocation;
                if (string5 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/osgi/jps/model/impl/JpsOsmorcModuleExtensionImpl", "getJarFileLocation"));
                }
                return string5;
            }
        }
        String string6 = nullSafeLocation;
        if (string6 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/osgi/jps/model/impl/JpsOsmorcModuleExtensionImpl", "getJarFileLocation"));
        }
        return string6;
    }

    @Override
    @Nullable
    public File getBundleDescriptorFile() {
        return (File)this.myDescriptorFile.getValue();
    }

    @Override
    public boolean isUseBndFile() {
        return this.myProperties.myManifestGenerationMode == ManifestGenerationMode.Bnd;
    }

    @Override
    public boolean isUseBundlorFile() {
        return this.myProperties.myManifestGenerationMode == ManifestGenerationMode.Bundlor;
    }

    @Override
    public boolean isManifestManuallyEdited() {
        return this.myProperties.myManifestGenerationMode == ManifestGenerationMode.Manually;
    }

    @Override
    public boolean isOsmorcControlsManifest() {
        return this.myProperties.myManifestGenerationMode == ManifestGenerationMode.OsmorcControlled;
    }

    @Override
    @NotNull
    public String getBndFileLocation() {
        String string = StringUtil.notNullize((String)this.myProperties.myBndFileLocation);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/osgi/jps/model/impl/JpsOsmorcModuleExtensionImpl", "getBndFileLocation"));
        }
        return string;
    }

    @Override
    @NotNull
    public Map<String, String> getAdditionalProperties() {
        Map<String, String> map = Collections.unmodifiableMap(this.myProperties.myAdditionalProperties);
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/osgi/jps/model/impl/JpsOsmorcModuleExtensionImpl", "getAdditionalProperties"));
        }
        return map;
    }

    @Override
    @NotNull
    public String getBundleSymbolicName() {
        String string = StringUtil.notNullize((String)this.myProperties.myBundleSymbolicName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/osgi/jps/model/impl/JpsOsmorcModuleExtensionImpl", "getBundleSymbolicName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getBundleVersion() {
        String string = StringUtil.notNullize((String)this.myProperties.myBundleVersion, (String)"1.0.0");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/osgi/jps/model/impl/JpsOsmorcModuleExtensionImpl", "getBundleVersion"));
        }
        return string;
    }

    @Override
    @Nullable
    public String getBundleActivator() {
        return this.myProperties.myBundleActivator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public File getManifestFile() {
        if (!this.isOsmorcControlsManifest()) {
            if (!this.isManifestManuallyEdited()) return null;
            return OsgiBuildUtil.findFileInModuleContentRoots(this.getModule(), this.getManifestLocation());
        }
        String pathToJar = this.getJarFileLocation();
        if (pathToJar.isEmpty()) {
            return null;
        }
        File jarFile = new File(pathToJar);
        if (!jarFile.exists()) {
            return null;
        }
        try (JarFile jar = new JarFile(jarFile);){
            JarEntry manifestEntry = jar.getJarEntry("META-INF/MANIFEST.MF");
            if (manifestEntry == null) {
                File file = null;
                return file;
            }
            File file = new File(jarFile, manifestEntry.getName());
            return file;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    @NotNull
    public String getManifestLocation() {
        if (this.myProperties.myUseProjectDefaultManifestFileLocation) {
            JpsOsmorcProjectExtension projectExtension = this.getProjectExtension();
            String string = projectExtension == null ? "META-INF/MANIFEST.MF" : projectExtension.getDefaultManifestFileLocation();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/osgi/jps/model/impl/JpsOsmorcModuleExtensionImpl", "getManifestLocation"));
            }
            return string;
        }
        String string = StringUtil.notNullize((String)this.myProperties.myManifestLocation);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/osgi/jps/model/impl/JpsOsmorcModuleExtensionImpl", "getManifestLocation"));
        }
        return string;
    }

    @Override
    public boolean isAlwaysRebuildBundleJar() {
        return this.myProperties.myAlwaysRebuildBundleJar;
    }

    @Override
    @NotNull
    public List<OsmorcJarContentEntry> getAdditionalJarContents() {
        List<OsmorcJarContentEntry> list = Collections.unmodifiableList(this.myProperties.myAdditionalJARContents);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/osgi/jps/model/impl/JpsOsmorcModuleExtensionImpl", "getAdditionalJarContents"));
        }
        return list;
    }

    @Override
    @Nullable
    public String getIgnoreFilePattern() {
        return this.myProperties.myIgnoreFilePattern;
    }

    @Override
    @NotNull
    public String getBundlorFileLocation() {
        String string = StringUtil.notNullize((String)this.myProperties.myBundlorFileLocation);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/osgi/jps/model/impl/JpsOsmorcModuleExtensionImpl", "getBundlorFileLocation"));
        }
        return string;
    }

    private JpsModule getModule() {
        return (JpsModule)this.getParent();
    }

    private JpsOsmorcProjectExtension getProjectExtension() {
        return JpsOsmorcExtensionService.getExtension(this.getModule().getProject());
    }
}

