/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java.dependencyView;

import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import gnu.trove.THashSet;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.java.dependencyView.DependencyContext;
import org.jetbrains.jps.builders.java.dependencyView.Difference;
import org.jetbrains.jps.builders.java.dependencyView.ElemType;
import org.jetbrains.jps.builders.java.dependencyView.FieldRepr;
import org.jetbrains.jps.builders.java.dependencyView.MethodRepr;
import org.jetbrains.jps.builders.java.dependencyView.Proto;
import org.jetbrains.jps.builders.java.dependencyView.RW;
import org.jetbrains.jps.builders.java.dependencyView.TypeRepr;
import org.jetbrains.jps.builders.java.dependencyView.UsageRepr;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;

public class ClassRepr
extends Proto {
    private final DependencyContext myContext;
    private final int myFileName;
    private final TypeRepr.ClassType mySuperClass;
    private final Set<TypeRepr.AbstractType> myInterfaces;
    private final Set<ElemType> myAnnotationTargets;
    private final RetentionPolicy myRetentionPolicy;
    private final Set<FieldRepr> myFields;
    private final Set<MethodRepr> myMethods;
    private final Set<UsageRepr.Usage> myUsages;
    private final int myOuterClassName;
    private final boolean myIsLocal;
    private final boolean myIsAnonymous;
    private static final int LOCAL_MASK = 1;
    private static final int ANONYMOUS_MASK = 2;

    public Set<MethodRepr> getMethods() {
        return this.myMethods;
    }

    public Set<FieldRepr> getFields() {
        return this.myFields;
    }

    public int getOuterClassName() {
        return this.myOuterClassName;
    }

    public boolean isLocal() {
        return this.myIsLocal;
    }

    public boolean isAnonymous() {
        return this.myIsAnonymous;
    }

    public TypeRepr.ClassType getSuperClass() {
        return this.mySuperClass;
    }

    public RetentionPolicy getRetentionPolicy() {
        return this.myRetentionPolicy;
    }

    public Set<UsageRepr.Usage> getUsages() {
        return this.myUsages;
    }

    public boolean addUsage(UsageRepr.Usage usage) {
        return this.myUsages.add(usage);
    }

    public boolean isInterface() {
        return (this.access & 0x200) != 0;
    }

    @Override
    public Diff difference(final Proto past) {
        final ClassRepr pastClass = (ClassRepr)past;
        final Difference diff = super.difference(past);
        int base = diff.base();
        if (!this.mySuperClass.equals(pastClass.mySuperClass)) {
            base |= 0x10;
        }
        if (!this.myUsages.equals(pastClass.myUsages)) {
            base |= 0x20;
        }
        final int d = base;
        return new Diff(){

            @Override
            public boolean extendsAdded() {
                if ((d & 0x10) <= 0) {
                    return false;
                }
                String pastSuperName = ClassRepr.this.myContext.getValue(((ClassRepr)((ClassRepr)past)).mySuperClass.className);
                return "java/lang/Object".equals(pastSuperName);
            }

            @Override
            public boolean packageLocalOn() {
                return diff.packageLocalOn();
            }

            @Override
            public int addedModifiers() {
                return diff.addedModifiers();
            }

            @Override
            public int removedModifiers() {
                return diff.removedModifiers();
            }

            @Override
            public Difference.Specifier<TypeRepr.AbstractType, Difference> interfaces() {
                return Difference.make(pastClass.myInterfaces, ClassRepr.this.myInterfaces);
            }

            @Override
            public Difference.Specifier<FieldRepr, Difference> fields() {
                return Difference.make(pastClass.myFields, ClassRepr.this.myFields);
            }

            @Override
            public Difference.Specifier<MethodRepr, MethodRepr.Diff> methods() {
                return Difference.make(pastClass.myMethods, ClassRepr.this.myMethods);
            }

            @Override
            public Difference.Specifier<ElemType, Difference> targets() {
                return Difference.make(pastClass.myAnnotationTargets, ClassRepr.this.myAnnotationTargets);
            }

            @Override
            public Difference.Specifier<TypeRepr.ClassType, Difference> annotations() {
                return diff.annotations();
            }

            @Override
            public boolean retentionChanged() {
                return !(ClassRepr.this.myRetentionPolicy == null && pastClass.myRetentionPolicy == RetentionPolicy.CLASS || ClassRepr.this.myRetentionPolicy == RetentionPolicy.CLASS && pastClass.myRetentionPolicy == null || ClassRepr.this.myRetentionPolicy == pastClass.myRetentionPolicy);
            }

            @Override
            public int base() {
                return d;
            }

            @Override
            public boolean hadValue() {
                return false;
            }

            @Override
            public boolean weakedAccess() {
                return diff.weakedAccess();
            }
        };
    }

    @NotNull
    public int[] getSupers() {
        int[] result = new int[this.myInterfaces.size() + 1];
        result[0] = this.mySuperClass.className;
        int i = 1;
        for (TypeRepr.AbstractType t : this.myInterfaces) {
            result[i++] = ((TypeRepr.ClassType)t).className;
        }
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/java/dependencyView/ClassRepr", "getSupers"));
        }
        return result;
    }

    public void updateClassUsages(DependencyContext context, Set<UsageRepr.Usage> s) {
        this.mySuperClass.updateClassUsages(context, this.name, s);
        for (TypeRepr.AbstractType t : this.myInterfaces) {
            t.updateClassUsages(context, this.name, s);
        }
        for (MethodRepr m : this.myMethods) {
            m.updateClassUsages(context, this.name, s);
        }
        for (FieldRepr f : this.myFields) {
            f.updateClassUsages(context, this.name, s);
        }
    }

    public ClassRepr(DependencyContext context, int access, int fileName, int name, int sig, int superClass, String[] interfaces, Set<FieldRepr> fields, Set<MethodRepr> methods, Set<TypeRepr.ClassType> annotations, Set<ElemType> annotationTargets, RetentionPolicy policy, int outerClassName, boolean localClassFlag, boolean anonymousClassFlag, Set<UsageRepr.Usage> usages) {
        super(access, sig, name, annotations);
        this.myContext = context;
        this.myFileName = fileName;
        this.mySuperClass = TypeRepr.createClassType(context, superClass);
        this.myInterfaces = (Set)TypeRepr.createClassType(context, interfaces, (Collection<TypeRepr.AbstractType>)new THashSet(1));
        this.myFields = fields;
        this.myMethods = methods;
        this.myAnnotationTargets = annotationTargets;
        this.myRetentionPolicy = policy;
        this.myOuterClassName = outerClassName;
        this.myIsLocal = localClassFlag;
        this.myIsAnonymous = anonymousClassFlag;
        this.myUsages = usages;
    }

    public ClassRepr(DependencyContext context, DataInput in) {
        super(context, in);
        try {
            this.myContext = context;
            this.myFileName = DataInputOutputUtil.readINT((DataInput)in);
            this.mySuperClass = (TypeRepr.ClassType)TypeRepr.externalizer(context).read(in);
            this.myInterfaces = (Set)RW.read(TypeRepr.externalizer(context), new THashSet(1), in);
            this.myFields = (Set)RW.read(FieldRepr.externalizer(context), new THashSet(), in);
            this.myMethods = (Set)RW.read(MethodRepr.externalizer(context), new THashSet(), in);
            this.myAnnotationTargets = (Set)RW.read(UsageRepr.AnnotationUsage.elementTypeExternalizer, EnumSet.noneOf(ElemType.class), in);
            String s = RW.readUTF(in);
            this.myRetentionPolicy = s.length() == 0 ? null : RetentionPolicy.valueOf(s);
            this.myOuterClassName = DataInputOutputUtil.readINT((DataInput)in);
            int flags = DataInputOutputUtil.readINT((DataInput)in);
            this.myIsLocal = (flags & 1) != 0;
            this.myIsAnonymous = (flags & 2) != 0;
            this.myUsages = (Set)RW.read(UsageRepr.externalizer(context), new THashSet(), in);
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void save(DataOutput out) {
        try {
            super.save(out);
            DataInputOutputUtil.writeINT((DataOutput)out, (int)this.myFileName);
            this.mySuperClass.save(out);
            RW.save(this.myInterfaces, out);
            RW.save(this.myFields, out);
            RW.save(this.myMethods, out);
            RW.save(this.myAnnotationTargets, UsageRepr.AnnotationUsage.elementTypeExternalizer, out);
            RW.writeUTF(out, this.myRetentionPolicy == null ? "" : this.myRetentionPolicy.toString());
            DataInputOutputUtil.writeINT((DataOutput)out, (int)this.myOuterClassName);
            DataInputOutputUtil.writeINT((DataOutput)out, (int)((this.myIsLocal ? 1 : 0) | (this.myIsAnonymous ? 2 : 0)));
            RW.save(this.myUsages, UsageRepr.externalizer(this.myContext), out);
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassRepr classRepr = (ClassRepr)o;
        if (this.myFileName != classRepr.myFileName) {
            return false;
        }
        return this.name == classRepr.name;
    }

    public int hashCode() {
        return 31 * this.myFileName + this.name;
    }

    public UsageRepr.Usage createUsage() {
        return UsageRepr.createClassUsage(this.myContext, this.name);
    }

    public String getPackageName() {
        String strValue = this.myContext.getValue(this.name);
        return strValue != null ? ClassRepr.getPackageName(strValue) : null;
    }

    public String getShortName() {
        String strValue = this.myContext.getValue(this.name);
        return strValue != null ? ClassRepr.getShortName(strValue) : null;
    }

    @NotNull
    public static String getPackageName(@NotNull String raw) {
        if (raw == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "raw", "org/jetbrains/jps/builders/java/dependencyView/ClassRepr", "getPackageName"));
        }
        int index = raw.lastIndexOf(47);
        if (index == -1) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/java/dependencyView/ClassRepr", "getPackageName"));
            }
            return "";
        }
        String string = raw.substring(0, index);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/java/dependencyView/ClassRepr", "getPackageName"));
        }
        return string;
    }

    @NotNull
    public static String getShortName(@NotNull String fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jps/builders/java/dependencyView/ClassRepr", "getShortName"));
        }
        int index = fqName.lastIndexOf(47);
        if (index == -1) {
            String string = fqName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/java/dependencyView/ClassRepr", "getShortName"));
            }
            return string;
        }
        String string = fqName.substring(index + 1);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/java/dependencyView/ClassRepr", "getShortName"));
        }
        return string;
    }

    @Nullable
    public FieldRepr findField(int name) {
        for (FieldRepr f : this.myFields) {
            if (f.name != name) continue;
            return f;
        }
        return null;
    }

    @NotNull
    public Collection<MethodRepr> findMethods(MethodRepr.Predicate p) {
        LinkedList<MethodRepr> result = new LinkedList<MethodRepr>();
        for (MethodRepr mm : this.myMethods) {
            if (!p.satisfy(mm)) continue;
            result.add(mm);
        }
        LinkedList<MethodRepr> linkedList = result;
        if (linkedList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/java/dependencyView/ClassRepr", "findMethods"));
        }
        return linkedList;
    }

    public static DataExternalizer<ClassRepr> externalizer(final DependencyContext context) {
        return new DataExternalizer<ClassRepr>(){

            public void save(@NotNull DataOutput out, ClassRepr value) throws IOException {
                if (out == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "org/jetbrains/jps/builders/java/dependencyView/ClassRepr$2", "save"));
                }
                value.save(out);
            }

            public ClassRepr read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "org/jetbrains/jps/builders/java/dependencyView/ClassRepr$2", "read"));
                }
                return new ClassRepr(context, in);
            }
        };
    }

    @Override
    public void toStream(DependencyContext context, PrintStream stream) {
        super.toStream(context, stream);
        stream.print("      Filename   : ");
        stream.println(context.getValue(this.myFileName));
        stream.print("      Superclass : ");
        stream.println(this.mySuperClass == null ? "<null>" : this.mySuperClass.getDescr(context));
        stream.print("      Interfaces : ");
        TypeRepr.AbstractType[] is = this.myInterfaces.toArray(new TypeRepr.AbstractType[this.myInterfaces.size()]);
        Arrays.sort(is, Comparator.comparing(o -> o.getDescr(context)));
        for (TypeRepr.AbstractType t : is) {
            stream.print(t.getDescr(context));
            stream.print(" ");
        }
        stream.println();
        stream.print("      Targets    : ");
        ElemType[] es = this.myAnnotationTargets.toArray(new ElemType[this.myAnnotationTargets.size()]);
        Arrays.sort((Object[])es);
        for (ElemType e : es) {
            stream.print((Object)e);
            stream.print("; ");
        }
        stream.println();
        stream.print("      Policy     : ");
        stream.println((Object)this.myRetentionPolicy);
        stream.print("      Outer class: ");
        stream.println(context.getValue(this.myOuterClassName));
        stream.print("      Local class: ");
        stream.println(this.myIsLocal);
        stream.print("      Anonymous class: ");
        stream.println(this.myIsAnonymous);
        stream.println("      Fields:");
        FieldRepr[] fs = this.myFields.toArray(new FieldRepr[this.myFields.size()]);
        Arrays.sort(fs, (o1, o2) -> {
            if (o1.name == o2.name) {
                return o1.myType.getDescr(context).compareTo(o2.myType.getDescr(context));
            }
            return context.getValue(o1.name).compareTo(context.getValue(o2.name));
        });
        for (FieldRepr f : fs) {
            f.toStream(context, stream);
        }
        stream.println("      End Of Fields");
        stream.println("      Methods:");
        MethodRepr[] ms = this.myMethods.toArray(new MethodRepr[this.myMethods.size()]);
        Arrays.sort(ms, (o1, o2) -> {
            if (o1.name == o2.name) {
                String d2;
                String d1 = o1.myType.getDescr(context);
                int c = d1.compareTo(d2 = o2.myType.getDescr(context));
                if (c == 0) {
                    int l1 = o1.myArgumentTypes.length;
                    int l2 = o2.myArgumentTypes.length;
                    if (l1 == l2) {
                        for (int i = 0; i < l1; ++i) {
                            String d22;
                            String d11 = o1.myArgumentTypes[i].getDescr(context);
                            int cc = d11.compareTo(d22 = o2.myArgumentTypes[i].getDescr(context));
                            if (cc == 0) continue;
                            return cc;
                        }
                        return 0;
                    }
                    return l1 - l2;
                }
                return c;
            }
            return context.getValue(o1.name).compareTo(context.getValue(o2.name));
        });
        for (MethodRepr m : ms) {
            m.toStream(context, stream);
        }
        stream.println("      End Of Methods");
        stream.println("      Usages:");
        LinkedList<String> usages = new LinkedList<String>();
        for (UsageRepr.Usage u : this.myUsages) {
            ByteArrayOutputStream bas = new ByteArrayOutputStream();
            u.toStream(this.myContext, new PrintStream(bas));
            try {
                bas.close();
            }
            catch (IOException e) {
                throw new BuildDataCorruptedException(e);
            }
            usages.add(bas.toString());
        }
        Collections.sort(usages);
        for (String s : usages) {
            stream.println(s);
        }
        stream.println("      End Of Usages");
    }

    public static abstract class Diff
    extends Difference {
        public abstract Difference.Specifier<TypeRepr.AbstractType, Difference> interfaces();

        public abstract Difference.Specifier<FieldRepr, Difference> fields();

        public abstract Difference.Specifier<MethodRepr, MethodRepr.Diff> methods();

        public abstract Difference.Specifier<ElemType, Difference> targets();

        public abstract boolean retentionChanged();

        public abstract boolean extendsAdded();

        @Override
        public boolean no() {
            return this.base() == 0 && this.interfaces().unchanged() && this.fields().unchanged() && this.methods().unchanged() && this.targets().unchanged() && !this.retentionChanged();
        }
    }
}

