/*
 * Decompiled with CFR 0.152.
 */
package aQute.maven.provider;

import aQute.bnd.http.HttpClient;
import aQute.bnd.http.HttpRequestException;
import aQute.bnd.service.url.State;
import aQute.bnd.service.url.TaggedData;
import aQute.libg.cryptography.MD5;
import aQute.libg.cryptography.SHA1;
import aQute.maven.api.Program;
import aQute.maven.api.Revision;
import aQute.maven.provider.MavenBackingRepository;
import aQute.maven.provider.MetadataParser;
import aQute.service.reporter.Reporter;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class MavenRemoteRepository
extends MavenBackingRepository {
    final HttpClient client;
    final Map<Revision, MetadataParser.RevisionMetadata> revisions = new ConcurrentHashMap<Revision, MetadataParser.RevisionMetadata>();
    final Map<Program, MetadataParser.ProgramMetadata> programs = new ConcurrentHashMap<Program, MetadataParser.ProgramMetadata>();
    final String base;
    static final long DEFAULT_MAX_STALE = TimeUnit.HOURS.toMillis(1L);

    public MavenRemoteRepository(File root, HttpClient client, String base, Reporter reporter) throws Exception {
        super(root, base, reporter);
        this.client = client;
        this.base = base;
    }

    @Override
    public TaggedData fetch(String path, File file) throws Exception {
        URL url = new URL(this.base + path);
        int n = 0;
        while (true) {
            try {
                this.reporter.trace("Fetching %s", new Object[]{path});
                TaggedData tag = (TaggedData)this.client.build().headers("User-Agent", "Bnd").useCache(file, DEFAULT_MAX_STALE).asTag().go(url);
                this.reporter.trace("Fetched %s", new Object[]{tag});
                if (tag.getState() == State.UPDATED && !path.endsWith("/maven-metadata.xml")) {
                    URL shaUrl = new URL(this.base + path + ".sha1");
                    URL md5Url = new URL(this.base + path + ".md5");
                    String sha = (String)this.client.build().asString().timeout(15000L).go(shaUrl);
                    if (sha != null) {
                        String fileSha = SHA1.digest(file).asHex();
                        this.checkDigest(fileSha, sha, file);
                    } else {
                        String md5 = (String)this.client.build().asString().timeout(15000L).go(md5Url);
                        if (md5 != null) {
                            String fileMD5 = MD5.digest(file).asHex();
                            this.checkDigest(fileMD5, md5, file);
                        }
                    }
                }
                return tag;
            }
            catch (Exception e) {
                if (++n > 3) {
                    throw e;
                }
                Thread.sleep(1000 * n);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void store(File file, String path) throws Exception {
        boolean n = false;
        URL url = new URL(this.base + path);
        SHA1 sha1 = SHA1.digest(file);
        MD5 md5 = MD5.digest(file);
        try (TaggedData go = (TaggedData)this.client.build().put().upload((Object)file).updateTag().asTag().go(url);){
            switch (go.getState()) {
                case NOT_FOUND: 
                case OTHER: {
                    throw new IOException("Could not store " + path + " from " + file + " with " + go);
                }
            }
        }
        TaggedData tag = (TaggedData)this.client.build().put().upload((Object)sha1.asHex()).asTag().go(new URL(this.base + path + ".sha1"));
        var8_8 = null;
        if (tag != null) {
            if (var8_8 != null) {
                try {
                    tag.close();
                }
                catch (Throwable x2) {
                    var8_8.addSuppressed(x2);
                }
            } else {
                tag.close();
            }
        }
        tag = (TaggedData)this.client.build().put().upload((Object)md5.asHex()).asTag().go(new URL(this.base + path + ".md5"));
        var8_8 = null;
        if (tag == null) return;
        if (var8_8 == null) {
            tag.close();
            return;
        }
        try {
            tag.close();
            return;
        }
        catch (Throwable x2) {
            var8_8.addSuppressed(x2);
            return;
        }
    }

    @Override
    public boolean delete(String path) throws Exception {
        URL url = new URL(this.base + path);
        TaggedData go = (TaggedData)this.client.build().put().delete().get(TaggedData.class).go(url);
        if (go == null) {
            return false;
        }
        if (go.getResponseCode() == 200 || go.getResponseCode() == 204) {
            this.client.build().delete().async(new URL(this.base + path + ".sha1"));
            this.client.build().delete().async(new URL(this.base + path + ".md5"));
            return true;
        }
        throw new HttpRequestException(go);
    }

    @Override
    public void close() {
    }

    @Override
    public String toString() {
        return "RemoteRepo [base=" + this.base + ", id=" + this.id + "]";
    }

    @Override
    public String getUser() throws Exception {
        return this.client.getUserFor(this.base);
    }

    @Override
    public URI toURI(String remotePath) throws Exception {
        return new URI(this.base + remotePath);
    }

    @Override
    public boolean isFile() {
        return false;
    }
}

