/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.artifact.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementCollection;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.artifact.JpsArtifact;
import org.jetbrains.jps.model.artifact.JpsArtifactReference;
import org.jetbrains.jps.model.artifact.JpsArtifactService;
import org.jetbrains.jps.model.artifact.JpsArtifactType;
import org.jetbrains.jps.model.artifact.elements.JpsCompositePackagingElement;
import org.jetbrains.jps.model.artifact.impl.JpsArtifactImpl;
import org.jetbrains.jps.model.artifact.impl.JpsArtifactReferenceImpl;
import org.jetbrains.jps.model.artifact.impl.JpsArtifactRole;

public class JpsArtifactServiceImpl
extends JpsArtifactService {
    @Override
    public List<JpsArtifact> getArtifacts(@NotNull JpsProject project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jps/model/artifact/impl/JpsArtifactServiceImpl", "getArtifacts"));
        }
        JpsElementCollection collection = (JpsElementCollection)((Object)project.getContainer().getChild(JpsArtifactRole.ARTIFACT_COLLECTION_ROLE));
        return collection != null ? collection.getElements() : Collections.emptyList();
    }

    @Override
    public List<JpsArtifact> getSortedArtifacts(@NotNull JpsProject project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jps/model/artifact/impl/JpsArtifactServiceImpl", "getSortedArtifacts"));
        }
        ArrayList<JpsArtifact> artifacts = new ArrayList<JpsArtifact>(this.getArtifacts(project));
        artifacts.sort((o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName()));
        return artifacts;
    }

    @Override
    public <P extends JpsElement> JpsArtifact addArtifact(@NotNull JpsProject project, @NotNull String name, @NotNull JpsCompositePackagingElement rootElement, @NotNull JpsArtifactType<P> type, @NotNull P properties) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jps/model/artifact/impl/JpsArtifactServiceImpl", "addArtifact"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jps/model/artifact/impl/JpsArtifactServiceImpl", "addArtifact"));
        }
        if (rootElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElement", "org/jetbrains/jps/model/artifact/impl/JpsArtifactServiceImpl", "addArtifact"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jps/model/artifact/impl/JpsArtifactServiceImpl", "addArtifact"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/jps/model/artifact/impl/JpsArtifactServiceImpl", "addArtifact"));
        }
        JpsArtifact artifact = this.createArtifact(name, rootElement, type, properties);
        return ((JpsElementCollection)project.getContainer().getOrSetChild(JpsArtifactRole.ARTIFACT_COLLECTION_ROLE)).addChild(artifact);
    }

    @Override
    public <P extends JpsElement> JpsArtifact createArtifact(@NotNull String name, @NotNull JpsCompositePackagingElement rootElement, @NotNull JpsArtifactType<P> type, @NotNull P properties) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jps/model/artifact/impl/JpsArtifactServiceImpl", "createArtifact"));
        }
        if (rootElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElement", "org/jetbrains/jps/model/artifact/impl/JpsArtifactServiceImpl", "createArtifact"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jps/model/artifact/impl/JpsArtifactServiceImpl", "createArtifact"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/jps/model/artifact/impl/JpsArtifactServiceImpl", "createArtifact"));
        }
        return new JpsArtifactImpl<P>(name, rootElement, type, properties);
    }

    @Override
    public JpsArtifactReference createReference(@NotNull String artifactName) {
        if (artifactName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactName", "org/jetbrains/jps/model/artifact/impl/JpsArtifactServiceImpl", "createReference"));
        }
        return new JpsArtifactReferenceImpl(artifactName);
    }
}

