/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.indexer.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.osgi.service.indexer.Resource;
import org.osgi.service.indexer.impl.FlatStreamResource;

public class JarResource
implements Resource {
    private final File file;
    private final JarFile jarFile;
    private final String location;
    private final Dictionary<String, Object> properties = new Hashtable<String, Object>();
    private final Map<String, List<JarEntry>> prefixMap = new HashMap<String, List<JarEntry>>();
    private final Map<String, JarEntry> paths = new HashMap<String, JarEntry>();
    private Manifest manifest;

    public JarResource(File file) throws IOException {
        this.file = file;
        this.location = file.getPath().replace(File.separatorChar, '/');
        this.jarFile = new JarFile(file);
        this.properties.put("name", file.getName());
        this.properties.put("location", this.location);
        this.properties.put("size", file.length());
        this.properties.put("lastmodified", file.lastModified());
        Enumeration<JarEntry> entries = this.jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String path = entry.getName();
            this.paths.put(path, entry);
            String parentPath = JarResource.getParentPath(path);
            List<JarEntry> list = this.getOrCreatePrefix(parentPath);
            list.add(entry);
        }
    }

    private static String getParentPath(String path) {
        int index = path.endsWith("/") ? path.substring(0, path.length() - 1).lastIndexOf("/") : path.lastIndexOf("/");
        String parentPath = index == -1 ? "" : path.substring(0, index + 1);
        return parentPath;
    }

    private synchronized List<JarEntry> getOrCreatePrefix(String prefix) {
        List<JarEntry> list = this.prefixMap.get(prefix);
        if (list == null) {
            list = new LinkedList<JarEntry>();
            this.prefixMap.put(prefix, list);
        }
        return list;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public Dictionary<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public long getSize() {
        return this.file.length();
    }

    @Override
    public InputStream getStream() throws IOException {
        return new FileInputStream(this.file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Manifest getManifest() throws IOException {
        JarResource jarResource = this;
        synchronized (jarResource) {
            Resource manifestResource;
            if (this.manifest == null && (manifestResource = this.getChild("META-INF/MANIFEST.MF")) != null) {
                try {
                    this.manifest = new Manifest(manifestResource.getStream());
                }
                finally {
                    manifestResource.close();
                }
            }
            return this.manifest;
        }
    }

    @Override
    public List<String> listChildren(String prefix) throws IOException {
        List<JarEntry> entries = this.prefixMap.get(prefix);
        if (entries == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>(entries.size());
        for (JarEntry entry : entries) {
            String unprefixedPath = entry.getName().substring(prefix.length());
            result.add(unprefixedPath);
        }
        return result;
    }

    @Override
    public Resource getChild(String path) throws IOException {
        String childLocation = this.getLocation() + "#" + path;
        JarEntry entry = this.paths.get(path);
        if (entry == null) {
            return null;
        }
        return new FlatStreamResource(path, childLocation, this.jarFile.getInputStream(entry));
    }

    @Override
    public void close() {
        try {
            this.jarFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

