/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gradle.build;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Base64;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.artifacts.ArtifactBuildTaskProvider;
import org.jetbrains.jps.gradle.model.JpsGradleExtensionService;
import org.jetbrains.jps.gradle.model.artifacts.JpsGradleArtifactExtension;
import org.jetbrains.jps.gradle.model.impl.artifacts.GradleArtifactExtensionProperties;
import org.jetbrains.jps.incremental.BuildTask;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.model.artifact.JpsArtifact;
import org.jetbrains.jps.model.artifact.elements.JpsArtifactRootElement;

public class GradleArtifactBuildTaskProvider
extends ArtifactBuildTaskProvider {
    @NotNull
    public List<? extends BuildTask> createArtifactBuildTasks(@NotNull JpsArtifact artifact, @NotNull ArtifactBuildTaskProvider.ArtifactBuildPhase buildPhase) {
        JpsGradleArtifactExtension extension;
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "org/jetbrains/jps/gradle/build/GradleArtifactBuildTaskProvider", "createArtifactBuildTasks"));
        }
        if (buildPhase == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildPhase", "org/jetbrains/jps/gradle/build/GradleArtifactBuildTaskProvider", "createArtifactBuildTasks"));
        }
        String artifactName = artifact.getName();
        if (buildPhase == ArtifactBuildTaskProvider.ArtifactBuildPhase.PRE_PROCESSING && artifactName.endsWith(" (exploded)") && artifact.getRootElement() instanceof JpsArtifactRootElement && (extension = GradleArtifactBuildTaskProvider.getArtifactExtension(artifact, buildPhase)) != null && extension.getProperties() != null) {
            List list = ContainerUtil.list((Object[])new GradleGenerationBuildTask[]{new GradleManifestGenerationBuildTask(artifact, extension.getProperties()), new GradleAdditionalFilesGenerationBuildTask(artifact, extension.getProperties())});
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gradle/build/GradleArtifactBuildTaskProvider", "createArtifactBuildTasks"));
            }
            return list;
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gradle/build/GradleArtifactBuildTaskProvider", "createArtifactBuildTasks"));
        }
        return list;
    }

    @Nullable
    private static JpsGradleArtifactExtension getArtifactExtension(JpsArtifact artifact, ArtifactBuildTaskProvider.ArtifactBuildPhase buildPhase) {
        switch (buildPhase) {
            case PRE_PROCESSING: {
                return JpsGradleExtensionService.getArtifactExtension(artifact);
            }
        }
        return null;
    }

    private static class GradleAdditionalFilesGenerationBuildTask
    extends GradleGenerationBuildTask {
        private static final Logger LOG = Logger.getInstance(GradleAdditionalFilesGenerationBuildTask.class);

        public GradleAdditionalFilesGenerationBuildTask(@NotNull JpsArtifact artifact, @NotNull GradleArtifactExtensionProperties properties) {
            if (artifact == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "org/jetbrains/jps/gradle/build/GradleArtifactBuildTaskProvider$GradleAdditionalFilesGenerationBuildTask", "<init>"));
            }
            if (properties == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/jps/gradle/build/GradleArtifactBuildTaskProvider$GradleAdditionalFilesGenerationBuildTask", "<init>"));
            }
            super(artifact, properties);
        }

        public void build(CompileContext context) throws ProjectBuildException {
            if (this.myProperties.additionalFiles != null) {
                for (Map.Entry<String, String> entry : this.myProperties.additionalFiles.entrySet()) {
                    try {
                        File output = new File(entry.getKey());
                        FileUtil.writeToFile((File)output, (byte[])Base64.decode((String)entry.getValue()));
                    }
                    catch (Exception e) {
                        LOG.debug((Throwable)e);
                    }
                }
            }
        }
    }

    private static class GradleManifestGenerationBuildTask
    extends GradleGenerationBuildTask {
        private static final Logger LOG = Logger.getInstance(GradleManifestGenerationBuildTask.class);

        public GradleManifestGenerationBuildTask(@NotNull JpsArtifact artifact, @NotNull GradleArtifactExtensionProperties properties) {
            if (artifact == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "org/jetbrains/jps/gradle/build/GradleArtifactBuildTaskProvider$GradleManifestGenerationBuildTask", "<init>"));
            }
            if (properties == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/jps/gradle/build/GradleArtifactBuildTaskProvider$GradleManifestGenerationBuildTask", "<init>"));
            }
            super(artifact, properties);
        }

        public void build(CompileContext context) throws ProjectBuildException {
            if (this.myProperties.manifest != null) {
                try {
                    File output = new File(this.myArtifact.getOutputPath(), "META-INF/MANIFEST.MF");
                    FileUtil.writeToFile((File)output, (byte[])Base64.decode((String)this.myProperties.manifest));
                }
                catch (Exception e) {
                    LOG.debug((Throwable)e);
                }
            }
        }
    }

    private static abstract class GradleGenerationBuildTask
    extends BuildTask {
        protected final JpsArtifact myArtifact;
        protected final GradleArtifactExtensionProperties myProperties;

        public GradleGenerationBuildTask(@NotNull JpsArtifact artifact, @NotNull GradleArtifactExtensionProperties properties) {
            if (artifact == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "org/jetbrains/jps/gradle/build/GradleArtifactBuildTaskProvider$GradleGenerationBuildTask", "<init>"));
            }
            if (properties == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/jps/gradle/build/GradleArtifactBuildTaskProvider$GradleGenerationBuildTask", "<init>"));
            }
            this.myArtifact = artifact;
            this.myProperties = properties;
        }
    }
}

