/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.repository.maven.provider;

import aQute.bnd.osgi.Domain;
import aQute.bnd.osgi.resource.ResourceBuilder;
import aQute.bnd.osgi.resource.ResourceUtils;
import aQute.bnd.service.repository.Phase;
import aQute.bnd.service.repository.SearchableRepository;
import aQute.bnd.version.Version;
import aQute.lib.collections.MultiMap;
import aQute.lib.io.IO;
import aQute.lib.json.JSONCodec;
import aQute.lib.strings.Strings;
import aQute.libg.cryptography.SHA1;
import aQute.libg.cryptography.SHA256;
import aQute.maven.api.Archive;
import aQute.maven.api.IMavenRepo;
import aQute.maven.api.Program;
import aQute.service.reporter.Reporter;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.util.function.Function;
import org.osgi.util.promise.Failure;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.Promises;

class IndexFile {
    private static final JSONCodec CODEC = new JSONCodec();
    private final ConcurrentMap<Archive, Promise<File>> promises = new ConcurrentHashMap<Archive, Promise<File>>();
    final ConcurrentMap<Archive, BundleDescriptor> descriptors = new ConcurrentHashMap<Archive, BundleDescriptor>();
    final File indexFile;
    final File cacheDir;
    private final IMavenRepo repo;
    private final Reporter reporter;
    private long lastModified;
    private AtomicBoolean refresh = new AtomicBoolean();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    long last = 0L;

    IndexFile(Reporter reporter, File file, IMavenRepo repo) throws Exception {
        this.reporter = reporter;
        this.indexFile = file;
        this.repo = repo;
        this.cacheDir = new File(this.indexFile.getParentFile(), this.indexFile.getName() + ".info");
    }

    void open() throws Exception {
        this.loadIndexFile();
        this.sync();
    }

    private void sync() throws Exception {
        ArrayList<Promise> sync = new ArrayList<Promise>(this.promises.size());
        Iterator i = this.promises.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            final Archive archive = (Archive)entry.getKey();
            Promise promise = (Promise)entry.getValue();
            i.remove();
            sync.add(promise.then(null, new Failure(){

                public void fail(Promise<?> resolved) throws Exception {
                    IndexFile.this.reporter.exception(resolved.getFailure(), "Failed to sync %s", new Object[]{archive});
                }
            }));
        }
        Promises.all(sync).getFailure();
    }

    BundleDescriptor add(Archive archive) throws Exception {
        BundleDescriptor old = this.descriptors.putIfAbsent(archive, this.createInitialDescriptor(archive));
        BundleDescriptor descriptor = (BundleDescriptor)((Object)this.descriptors.get(archive));
        this.updateDescriptor(descriptor, (File)this.repo.get(archive).getValue());
        if (old == null || !Arrays.equals(descriptor.id, old.id)) {
            this.saveIndexFile();
            return descriptor;
        }
        return null;
    }

    BundleDescriptor remove(Archive archive) throws Exception {
        BundleDescriptor descriptor = (BundleDescriptor)((Object)this.descriptors.remove(archive));
        if (descriptor != null) {
            this.saveIndexFile();
        }
        return descriptor;
    }

    public void remove(String bsn) throws Exception {
        Iterator bd = this.descriptors.values().iterator();
        while (bd.hasNext()) {
            if (!this.isBsn(bsn, (BundleDescriptor)((Object)bd.next()))) continue;
            bd.remove();
        }
        this.saveIndexFile();
    }

    Collection<String> list() {
        HashSet<String> result = new HashSet<String>();
        for (BundleDescriptor descriptor : this.descriptors.values()) {
            result.add(descriptor.bsn);
        }
        return result;
    }

    Collection<Version> list(String bsn) {
        HashSet<Version> result = new HashSet<Version>();
        for (BundleDescriptor descriptor : this.descriptors.values()) {
            if (!this.isBsn(bsn, descriptor)) continue;
            result.add(descriptor.version);
        }
        return result;
    }

    boolean isBsn(String bsn, BundleDescriptor descriptor) {
        return bsn.equals(descriptor.bsn) || bsn.equals(descriptor.archive.getWithoutVersion());
    }

    public synchronized BundleDescriptor getDescriptor(String bsn, Version version) throws Exception {
        this.sync();
        for (BundleDescriptor descriptor : this.descriptors.values()) {
            if (!this.isBsn(bsn, descriptor) || !version.equals((Object)descriptor.version)) continue;
            return descriptor;
        }
        return null;
    }

    int getErrors(String name) {
        int errors = 0;
        for (BundleDescriptor bd : this.descriptors.values()) {
            if (name != null && !name.equals(bd.bsn) || bd.error == null) continue;
            ++errors;
        }
        return errors;
    }

    Set<Program> getProgramsForBsn(String name) {
        HashSet<Program> set = new HashSet<Program>();
        for (BundleDescriptor bd : this.descriptors.values()) {
            if (name != null && !name.equals(bd.bsn)) continue;
            set.add(bd.archive.revision.program);
        }
        return set;
    }

    boolean refresh() throws Exception {
        this.refresh.getAndSet(false);
        if (this.indexFile.lastModified() != this.lastModified && this.last + 10000L < System.currentTimeMillis()) {
            this.loadIndexFile();
            this.last = System.currentTimeMillis();
            return true;
        }
        boolean refreshed = false;
        for (BundleDescriptor bd : this.descriptors.values()) {
            File f;
            if (bd.promise == null || !bd.promise.isDone() || bd.promise.getFailure() != null || !(f = (File)bd.promise.getValue()).isFile() || f.lastModified() == bd.lastModified) continue;
            this.updateDescriptor(bd, f);
            refreshed = true;
        }
        return refreshed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadIndexFile() throws Exception {
        this.lastModified = this.indexFile.lastModified();
        HashSet toBeDeleted = new HashSet(this.descriptors.keySet());
        if (this.indexFile.isFile()) {
            this.lock.readLock().lock();
            try (BufferedReader rdr = IO.reader(this.indexFile);){
                String line;
                while ((line = rdr.readLine()) != null) {
                    if ((line = Strings.trim(line)).startsWith("#") || line.isEmpty()) continue;
                    Archive a = Archive.valueOf(line);
                    if (a == null) {
                        this.reporter.error("MavenBndRepository: invalid entry %s in file %s", new Object[]{line, this.indexFile});
                        continue;
                    }
                    toBeDeleted.remove(a);
                    this.loadDescriptorAsync(a);
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
            this.descriptors.keySet().removeAll(toBeDeleted);
            this.promises.keySet().removeAll(toBeDeleted);
        }
    }

    void updateDescriptor(Archive archive, File file) {
        BundleDescriptor descriptor = (BundleDescriptor)((Object)this.descriptors.get(archive));
        this.updateDescriptor(descriptor, file);
    }

    void updateDescriptor(BundleDescriptor descriptor, File file) {
        try {
            if (file == null || !file.isFile()) {
                File descriptorFile = this.getDescriptorFile(descriptor.archive);
                descriptorFile.delete();
                this.reporter.error("Could not find file %s", new Object[]{descriptor.archive});
                descriptor.error = "File not found";
            } else {
                if (descriptor.lastModified != file.lastModified()) {
                    Map.Entry bsn;
                    Domain m = Domain.domain((File)file);
                    if (m == null) {
                        m = Domain.domain(Collections.emptyMap());
                    }
                    descriptor.bsn = (bsn = m.getBundleSymbolicName()) != null ? (String)bsn.getKey() : null;
                    Version version = descriptor.version = m.getBundleVersion() == null ? null : Version.parseVersion((String)m.getBundleVersion());
                    if (descriptor.bsn == null) {
                        descriptor.bsn = descriptor.archive.getWithoutVersion();
                        descriptor.version = descriptor.archive.revision.version.getOSGiVersion();
                    } else if (descriptor.version == null) {
                        descriptor.version = Version.LOWEST;
                    }
                    descriptor.description = m.getBundleDescription();
                    descriptor.id = SHA1.digest(file).digest();
                    descriptor.included = false;
                    descriptor.lastModified = file.lastModified();
                    descriptor.sha256 = SHA256.digest(file).digest();
                    this.saveDescriptor(descriptor);
                    this.refresh.set(true);
                }
                if (descriptor.promise == null && file != null) {
                    descriptor.promise = Promises.resolved((Object)file);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            descriptor.error = e.toString();
            this.refresh.set(true);
        }
    }

    private void saveDescriptor(BundleDescriptor descriptor) throws IOException, Exception {
        File df = this.getDescriptorFile(descriptor.archive);
        df.getParentFile().mkdirs();
        CODEC.enc().to(df).put((Object)descriptor);
    }

    private void loadDescriptorAsync(Archive archive) throws Exception {
        if (this.updateLocal(archive)) {
            return;
        }
        this.updateAsync(archive);
    }

    private boolean updateLocal(Archive archive) {
        File descriptorFile;
        File archiveFile = this.repo.toLocalFile(archive);
        if (archiveFile.isFile() && (descriptorFile = this.getDescriptorFile(archive)).isFile()) {
            try {
                BundleDescriptor descriptor = CODEC.dec().from(descriptorFile).get(BundleDescriptor.class);
                descriptor.promise = Promises.resolved((Object)archiveFile);
                descriptor.resource = null;
                this.descriptors.put(archive, descriptor);
                return true;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return false;
    }

    Promise<File> updateAsync(Archive archive) throws Exception {
        Promise<File> promise = this.repo.get(archive);
        return this.updateAsync(archive, promise);
    }

    private Promise<File> updateAsync(Archive archive, Promise<File> promise) throws Exception {
        BundleDescriptor descriptor = this.createInitialDescriptor(archive);
        promise = this.updateAsync(descriptor, promise);
        this.descriptors.put(archive, descriptor);
        return promise;
    }

    Promise<File> updateAsync(final BundleDescriptor descriptor, Promise<File> promise) throws Exception {
        descriptor.promise = promise.map((Function)new Function<File, File>(){

            public File apply(File file) {
                IndexFile.this.updateDescriptor(descriptor, file);
                return file;
            }
        });
        descriptor.resource = null;
        this.promises.put(descriptor.archive, descriptor.promise);
        return descriptor.promise;
    }

    File getDescriptorFile(Archive archive) {
        File dir = new File(this.repo.toLocalFile(archive).getParentFile(), ".bnd");
        return new File(dir, archive.getName());
    }

    private BundleDescriptor createInitialDescriptor(Archive archive) throws Exception {
        BundleDescriptor descriptor = new BundleDescriptor();
        descriptor.archive = archive;
        descriptor.phase = archive.isSnapshot() ? Phase.STAGING : Phase.MASTER;
        descriptor.url = this.repo.toRemoteURI(archive);
        descriptor.bsn = archive.getWithoutVersion();
        descriptor.version = archive.revision.version.getOSGiVersion();
        return descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveIndexFile() throws Exception {
        this.lock.writeLock().lock();
        try {
            File tmp = File.createTempFile("index", null);
            try (PrintWriter pw = new PrintWriter(tmp);){
                ArrayList archives = new ArrayList(this.descriptors.keySet());
                Collections.sort(archives);
                for (Archive archive : archives) {
                    pw.println(archive);
                }
            }
            Files.move(tmp.toPath(), this.indexFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.lastModified = this.indexFile.lastModified();
    }

    public void save() throws Exception {
        this.saveIndexFile();
    }

    public Collection<Archive> getArchives() {
        return this.descriptors.keySet();
    }

    public Map<Requirement, Collection<Capability>> findProviders(Collection<? extends Requirement> requirements) {
        MultiMap<Requirement, Capability> providers = new MultiMap<Requirement, Capability>();
        for (BundleDescriptor bd : this.descriptors.values()) {
            Resource r = bd.getResource();
            if (r == null) continue;
            for (Requirement requirement : requirements) {
                for (Capability cap : r.getCapabilities(requirement.getNamespace())) {
                    if (!ResourceUtils.matches(requirement, cap)) continue;
                    providers.add(requirement, cap);
                }
            }
        }
        return providers;
    }

    public class BundleDescriptor
    extends SearchableRepository.ResourceDescriptor {
        public long lastModified;
        public Archive archive;
        public boolean merged;
        String error;
        Promise<File> promise;
        Resource resource;

        public synchronized Resource getResource() {
            if (this.resource == null) {
                try {
                    File f = (File)this.promise.getValue();
                    ResourceBuilder rb = new ResourceBuilder();
                    rb.addFile(f, f.toURI());
                    this.resource = rb.build();
                }
                catch (Exception e) {
                    IndexFile.this.reporter.exception((Throwable)e, "Failed to get file for %s", new Object[]{this.archive});
                    this.resource = ResourceUtils.DUMMY_RESOURCE;
                }
            }
            return this.resource;
        }
    }
}

