/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.osgi.jps.build;

import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildTargetLoader;
import org.jetbrains.jps.builders.ModuleBasedBuildTargetType;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.osgi.jps.build.OsmorcBuildTarget;
import org.jetbrains.osgi.jps.model.JpsOsmorcExtensionService;
import org.jetbrains.osgi.jps.model.JpsOsmorcModuleExtension;

public class OsmorcBuildTargetType
extends ModuleBasedBuildTargetType<OsmorcBuildTarget> {
    public static final OsmorcBuildTargetType INSTANCE = new OsmorcBuildTargetType();

    private OsmorcBuildTargetType() {
        super("osmorc");
    }

    @NotNull
    public List<OsmorcBuildTarget> computeAllTargets(@NotNull JpsModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "org/jetbrains/osgi/jps/build/OsmorcBuildTargetType", "computeAllTargets"));
        }
        ArrayList targets = ContainerUtil.newArrayList();
        for (JpsModule module : model.getProject().getModules()) {
            JpsOsmorcModuleExtension extension = JpsOsmorcExtensionService.getExtension(module);
            if (extension == null) continue;
            targets.add(new OsmorcBuildTarget(extension, module));
        }
        ArrayList arrayList = targets;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/osgi/jps/build/OsmorcBuildTargetType", "computeAllTargets"));
        }
        return arrayList;
    }

    @NotNull
    public BuildTargetLoader<OsmorcBuildTarget> createLoader(@NotNull JpsModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "org/jetbrains/osgi/jps/build/OsmorcBuildTargetType", "createLoader"));
        }
        Loader loader = new Loader(model);
        if (loader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/osgi/jps/build/OsmorcBuildTargetType", "createLoader"));
        }
        return loader;
    }

    private static class Loader
    extends BuildTargetLoader<OsmorcBuildTarget> {
        private Map<String, OsmorcBuildTarget> myTargets = ContainerUtil.newHashMap();

        public Loader(JpsModel model) {
            for (JpsModule module : model.getProject().getModules()) {
                JpsOsmorcModuleExtension extension = JpsOsmorcExtensionService.getExtension(module);
                if (extension == null) continue;
                this.myTargets.put(module.getName(), new OsmorcBuildTarget(extension, module));
            }
        }

        @Nullable
        public OsmorcBuildTarget createTarget(@NotNull String targetId) {
            if (targetId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetId", "org/jetbrains/osgi/jps/build/OsmorcBuildTargetType$Loader", "createTarget"));
            }
            return this.myTargets.get(targetId);
        }
    }
}

