/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gwt.build;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.CompileContext;

public class GwtBuilderParameters {
    @NonNls
    public static final String GWT_COMPILE_REPORT_PARAMETER = "GWT_COMPILE_REPORT_SOURCE";

    @NotNull
    public static String generateCompileReportParameter(@NotNull String moduleName, @NotNull String gwtModuleQualifiedName) {
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "org/jetbrains/jps/gwt/build/GwtBuilderParameters", "generateCompileReportParameter"));
        }
        if (gwtModuleQualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gwtModuleQualifiedName", "org/jetbrains/jps/gwt/build/GwtBuilderParameters", "generateCompileReportParameter"));
        }
        String string = moduleName + ":" + gwtModuleQualifiedName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/build/GwtBuilderParameters", "generateCompileReportParameter"));
        }
        return string;
    }

    @Nullable
    public static String getCompileReportModuleName(CompileContext context) {
        String compileReportParameter = context.getBuilderParameter(GWT_COMPILE_REPORT_PARAMETER);
        if (compileReportParameter == null) {
            return null;
        }
        return compileReportParameter.substring(0, compileReportParameter.indexOf(58));
    }

    @Nullable
    public static String getCompileReportGwtModuleQualifiedName(CompileContext context) {
        String compileReportParameter = context.getBuilderParameter(GWT_COMPILE_REPORT_PARAMETER);
        if (compileReportParameter == null) {
            return null;
        }
        return compileReportParameter.substring(compileReportParameter.indexOf(58) + 1);
    }
}

