/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.osgi;

import aQute.bnd.osgi.FileResource;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Resource;
import aQute.lib.zip.ZipUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class ZipResource
implements Resource {
    ZipFile zip;
    ZipEntry entry;
    long lastModified;
    String extra;

    ZipResource(ZipFile zip, ZipEntry entry) throws UnsupportedEncodingException {
        this.zip = zip;
        this.entry = entry;
        this.lastModified = -11L;
        byte[] data = entry.getExtra();
        if (data != null) {
            this.extra = new String(data, "UTF-8");
        }
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return this.zip.getInputStream(this.entry);
    }

    public String toString() {
        return ":" + this.zip.getName() + "(" + this.entry.getName() + "):";
    }

    public static ZipFile build(Jar jar, File file) throws ZipException, IOException {
        return ZipResource.build(jar, file, null);
    }

    public static ZipFile build(Jar jar, File file, Pattern pattern) throws ZipException, IOException {
        try {
            ZipFile zip = new ZipFile(file);
            Enumeration<? extends ZipEntry> e = zip.entries();
            while (e.hasMoreElements()) {
                Matcher m;
                ZipEntry entry = e.nextElement();
                if (pattern != null && !(m = pattern.matcher(entry.getName())).matches() || entry.isDirectory()) continue;
                jar.putResource(entry.getName(), new ZipResource(zip, entry), true);
            }
            return zip;
        }
        catch (ZipException e) {
            ZipException ze = new ZipException("The JAR/ZIP file (" + file.getAbsolutePath() + ") seems corrupted, error: " + e.getMessage());
            ze.initCause(e);
            throw ze;
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("Problem opening JAR: " + file.getAbsolutePath());
        }
    }

    @Override
    public void write(OutputStream out) throws Exception {
        FileResource.copy(this, out);
    }

    @Override
    public long lastModified() {
        try {
            if (this.lastModified == -11L) {
                this.lastModified = ZipUtil.getModifiedTime(this.entry);
            }
            return this.lastModified;
        }
        catch (IOException e) {
            this.lastModified = -1L;
            return -1L;
        }
    }

    @Override
    public String getExtra() {
        return this.extra;
    }

    @Override
    public void setExtra(String extra) {
        this.extra = extra;
    }

    @Override
    public long size() {
        return this.entry.getSize();
    }
}

