/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.deployer.repository;

import aQute.bnd.service.progress.ProgressPlugin;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ProgressWrappingStream
extends InputStream {
    private InputStream delegate;
    private ProgressPlugin.Task task;

    public ProgressWrappingStream(InputStream delegate, String name, int size, ProgressPlugin progressPlugin) {
        this(delegate, name, size, ProgressWrappingStream.safeList(progressPlugin));
    }

    public ProgressWrappingStream(InputStream delegate, String name, int size, List<ProgressPlugin> progressPlugins) {
        this.delegate = delegate;
        if (progressPlugins != null && progressPlugins.size() > 1) {
            final ArrayList<ProgressPlugin.Task> multiplexedTasks = new ArrayList<ProgressPlugin.Task>();
            for (ProgressPlugin progressPlugin : progressPlugins) {
                multiplexedTasks.add(progressPlugin.startTask(name, size));
            }
            this.task = new ProgressPlugin.Task(){

                public void worked(int units) {
                    for (ProgressPlugin.Task task : multiplexedTasks) {
                        task.worked(units);
                    }
                }

                public void done(String message, Throwable e) {
                    for (ProgressPlugin.Task task : multiplexedTasks) {
                        task.done(message, e);
                    }
                }

                public boolean isCanceled() {
                    for (ProgressPlugin.Task task : multiplexedTasks) {
                        if (!task.isCanceled()) continue;
                        return true;
                    }
                    return false;
                }
            };
        } else {
            this.task = progressPlugins != null && progressPlugins.size() == 1 ? progressPlugins.get(0).startTask(name, size) : new ProgressPlugin.Task(){

                public void worked(int units) {
                }

                public void done(String message, Throwable e) {
                }

                public boolean isCanceled() {
                    return Thread.currentThread().isInterrupted();
                }
            };
        }
    }

    private static <T> List<T> safeList(T o) {
        if (o == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(o);
    }

    @Override
    public int read() throws IOException {
        int data = this.delegate.read();
        if (data == -1) {
            this.task.done("Completed", null);
        } else {
            this.task.worked(1);
        }
        return data;
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        int count = this.delegate.read(buffer);
        if (count == -1) {
            this.task.done("Completed", null);
        } else {
            this.task.worked(count);
        }
        return count;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        int count = this.delegate.read(buffer, offset, length);
        if (count == -1) {
            this.task.done("Completed", null);
        } else {
            this.task.worked(count);
        }
        return count;
    }
}

