/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.groovy;

import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.lang.UrlClassLoader;
import gnu.trove.THashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.cmdline.ClasspathBootstrap;
import org.jetbrains.jps.incremental.ExternalProcessUtil;
import org.jetbrains.jps.incremental.groovy.GroovyBuilder;
import org.jetbrains.jps.incremental.groovy.GroovycContinuation;
import org.jetbrains.jps.incremental.groovy.GroovycFlavor;
import org.jetbrains.jps.incremental.groovy.GroovycOutputParser;
import org.jetbrains.jps.incremental.groovy.JpsGroovySettings;
import org.jetbrains.jps.model.JpsDummyElement;
import org.jetbrains.jps.model.java.JpsJavaSdkType;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.service.SharedThreadPool;

class ForkedGroovyc
implements GroovycFlavor {
    private final boolean myOptimizeClassLoading;
    private final ModuleChunk myChunk;

    ForkedGroovyc(boolean optimizeClassLoading, ModuleChunk chunk) {
        this.myOptimizeClassLoading = optimizeClassLoading;
        this.myChunk = chunk;
    }

    @Override
    public GroovycContinuation runGroovyc(Collection<String> compilationClassPath, boolean forStubs, JpsGroovySettings settings, File tempFile, final GroovycOutputParser parser) throws Exception {
        String grapeRoot;
        String configScript;
        ArrayList<String> classpath = new ArrayList<String>();
        if (this.myOptimizeClassLoading) {
            classpath.addAll(GroovyBuilder.getGroovyRtRoots());
            classpath.add(ClasspathBootstrap.getResourcePath(Function.class));
            classpath.add(ClasspathBootstrap.getResourcePath(UrlClassLoader.class));
            classpath.add(ClasspathBootstrap.getResourceFile(THashMap.class).getPath());
        } else {
            classpath.addAll(compilationClassPath);
        }
        ArrayList vmParams = ContainerUtilRt.newArrayList();
        vmParams.add("-Xmx" + System.getProperty("groovyc.heap.size", settings.heapSize) + "m");
        vmParams.add("-Dfile.encoding=" + System.getProperty("file.encoding"));
        if ("false".equals(System.getProperty("groovyc.asm.resolving.only"))) {
            vmParams.add("-Dgroovyc.asm.resolving.only=false");
        }
        if (StringUtil.isNotEmpty((String)(configScript = settings.configScript))) {
            vmParams.add("-Dgroovyc.config.script=" + configScript);
        }
        if ((grapeRoot = System.getProperty("grape.root")) != null) {
            vmParams.add("-Dgrape.root=" + grapeRoot);
        }
        List cmd = ExternalProcessUtil.buildJavaCommandLine((String)ForkedGroovyc.getJavaExecutable(this.myChunk), (String)"org.jetbrains.groovy.compiler.rt.GroovycRunner", Collections.emptyList(), classpath, (List)vmParams, this.getProgramParams(tempFile, settings, forStubs));
        Process process = Runtime.getRuntime().exec(ArrayUtil.toStringArray((Collection)cmd));
        BaseOSProcessHandler handler = new BaseOSProcessHandler(process, StringUtil.join((Collection)cmd, (String)" "), null){

            @NotNull
            protected Future<?> executeOnPooledThread(@NotNull Runnable task) {
                if (task == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/jps/incremental/groovy/ForkedGroovyc$1", "executeOnPooledThread"));
                }
                Future future = SharedThreadPool.getInstance().executeOnPooledThread(task);
                if (future == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/groovy/ForkedGroovyc$1", "executeOnPooledThread"));
                }
                return future;
            }

            public void notifyTextAvailable(String text, Key outputType) {
                parser.notifyTextAvailable(text, outputType);
            }
        };
        handler.startNotify();
        handler.waitFor();
        parser.notifyFinished(process.exitValue());
        return null;
    }

    private List<String> getProgramParams(File tempFile, JpsGroovySettings settings, boolean forStubs) {
        ArrayList programParams = ContainerUtilRt.newArrayList((Object[])new String[]{this.myOptimizeClassLoading ? "optimize" : "do_not_optimize", forStubs ? "stubs" : "groovyc", tempFile.getPath()});
        if (settings.invokeDynamic) {
            programParams.add("--indy");
        }
        return programParams;
    }

    private static String getJavaExecutable(ModuleChunk chunk) {
        JpsSdk<JpsDummyElement> sdk = GroovyBuilder.getJdk(chunk);
        return sdk != null ? JpsJavaSdkType.getJavaExecutable(sdk) : SystemProperties.getJavaHome() + "/bin/java";
    }
}

