/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android;

import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.jps.AndroidTargetBuilder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.compiler.tools.AndroidApt;
import org.jetbrains.android.util.AndroidCompilerMessageKind;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.android.AndroidJpsBundle;
import org.jetbrains.jps.android.AndroidJpsUtil;
import org.jetbrains.jps.android.AndroidPlatform;
import org.jetbrains.jps.android.builder.AndroidResourceCachingBuildTarget;
import org.jetbrains.jps.android.model.JpsAndroidModuleExtension;
import org.jetbrains.jps.builders.BuildOutputConsumer;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.StopBuildException;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.model.module.JpsModule;

public class AndroidResourceCachingBuilder
extends AndroidTargetBuilder<BuildRootDescriptor, AndroidResourceCachingBuildTarget> {
    @NonNls
    private static final String BUILDER_NAME = "Android Resource Caching";

    protected AndroidResourceCachingBuilder() {
        super(Collections.singletonList(AndroidResourceCachingBuildTarget.MyTargetType.INSTANCE));
    }

    @Override
    protected void buildTarget(@NotNull AndroidResourceCachingBuildTarget target, @NotNull DirtyFilesHolder<BuildRootDescriptor, AndroidResourceCachingBuildTarget> holder, @NotNull BuildOutputConsumer outputConsumer, @NotNull CompileContext context) throws ProjectBuildException, IOException {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/jps/android/AndroidResourceCachingBuilder", "buildTarget"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/jps/android/AndroidResourceCachingBuilder", "buildTarget"));
        }
        if (outputConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputConsumer", "org/jetbrains/jps/android/AndroidResourceCachingBuilder", "buildTarget"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jps/android/AndroidResourceCachingBuilder", "buildTarget"));
        }
        if (AndroidJpsUtil.isLightBuild(context) || !holder.hasDirtyFiles() && !holder.hasRemovedFiles()) {
            return;
        }
        if (!AndroidResourceCachingBuilder.runPngCaching(target, context, outputConsumer)) {
            throw new StopBuildException();
        }
    }

    private static boolean runPngCaching(AndroidResourceCachingBuildTarget target, CompileContext context, BuildOutputConsumer outputConsumer) throws IOException {
        JpsModule module = target.getModule();
        JpsAndroidModuleExtension extension = AndroidJpsUtil.getExtension(module);
        assert (extension != null);
        context.processMessage((BuildMessage)new CompilerMessage(BUILDER_NAME, BuildMessage.Kind.INFO, AndroidJpsBundle.message("android.jps.progress.res.caching", module.getName())));
        AndroidPlatform platform = AndroidJpsUtil.getAndroidPlatform(module, context, BUILDER_NAME);
        if (platform == null) {
            return false;
        }
        final File resCacheDir = target.getOutputDir(context);
        if (context.getScope().isBuildForced((BuildTarget)target) && resCacheDir.exists() && !FileUtil.delete((File)resCacheDir)) {
            context.processMessage((BuildMessage)new CompilerMessage(BUILDER_NAME, BuildMessage.Kind.ERROR, AndroidJpsBundle.message("android.jps.cannot.create.directory", resCacheDir.getPath())));
            return false;
        }
        if (!resCacheDir.exists() && !resCacheDir.mkdirs()) {
            context.processMessage((BuildMessage)new CompilerMessage(BUILDER_NAME, BuildMessage.Kind.ERROR, AndroidJpsBundle.message("android.jps.cannot.create.directory", resCacheDir.getPath())));
            return false;
        }
        IAndroidTarget androidTarget = platform.getTarget();
        List roots = context.getProjectDescriptor().getBuildRootIndex().getTargetRoots((BuildTarget)target, context);
        if (roots.size() == 0) {
            return true;
        }
        ArrayList<String> inputDirs = new ArrayList<String>();
        for (BuildRootDescriptor root : roots) {
            File f = root.getRootFile();
            if (!f.exists()) continue;
            inputDirs.add(f.getPath());
        }
        Map<AndroidCompilerMessageKind, List<String>> messages = AndroidApt.crunch(androidTarget, inputDirs, resCacheDir.getPath());
        AndroidJpsUtil.addMessages(context, messages, BUILDER_NAME, module.getName());
        boolean success = messages.get((Object)AndroidCompilerMessageKind.ERROR).isEmpty();
        if (success) {
            HashMap outputFiles = new HashMap();
            FileUtil.processFilesRecursively((File)resCacheDir, (Processor)new Processor<File>((Map)outputFiles){
                final /* synthetic */ Map val$outputFiles;
                {
                    this.val$outputFiles = map;
                }

                public boolean process(File file) {
                    String relativePath;
                    if (file.isFile() && (relativePath = FileUtil.getRelativePath((File)resCacheDir, (File)file)) != null) {
                        this.val$outputFiles.put(relativePath, file);
                    }
                    return true;
                }
            });
            for (Map.Entry entry : outputFiles.entrySet()) {
                String relativePath = (String)entry.getKey();
                File outputFile = (File)entry.getValue();
                for (String inputDir : inputDirs) {
                    File srcFile = new File(inputDir, relativePath);
                    outputConsumer.registerOutputFile(outputFile, Collections.singletonList(srcFile.getPath()));
                }
            }
        }
        return success;
    }

    @NotNull
    public String getPresentableName() {
        if (BUILDER_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/AndroidResourceCachingBuilder", "getPresentableName"));
        }
        return BUILDER_NAME;
    }
}

