/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac;

import java.io.File;
import java.lang.reflect.Method;
import javax.tools.StandardJavaFileManager;

public class OptimizedFileManagerUtil {
    public static Class<StandardJavaFileManager> getManagerClass() {
        Class<StandardJavaFileManager> aClass = OptimizedFileManagerClassHolder.managerClass;
        if (aClass != null) {
            return aClass;
        }
        return OptimizedFileManager17ClassHolder.managerClass;
    }

    public static Method getCacheClearMethod() {
        Method method = OptimizedFileManagerClassHolder.directoryCacheClearMethod;
        if (method != null) {
            return method;
        }
        return OptimizedFileManager17ClassHolder.directoryCacheClearMethod;
    }

    public static String getLoadError() {
        StringBuilder builder = new StringBuilder();
        if (OptimizedFileManagerClassHolder.initError != null) {
            builder.append(OptimizedFileManagerClassHolder.initError);
        }
        if (OptimizedFileManager17ClassHolder.initError != null) {
            if (builder.length() > 0) {
                builder.append("\n");
            }
            builder.append(OptimizedFileManager17ClassHolder.initError);
        }
        return builder.toString();
    }

    private static class OptimizedFileManager17ClassHolder {
        static final String CLASS_NAME = "org.jetbrains.jps.javac.OptimizedFileManager17";
        static final Class<StandardJavaFileManager> managerClass;
        static final Method directoryCacheClearMethod;
        static final String initError;

        private OptimizedFileManager17ClassHolder() {
        }

        static {
            Class<?> aClass;
            Method cacheClearMethod = null;
            String error = null;
            try {
                Class<?> c;
                aClass = c = Class.forName(CLASS_NAME);
                try {
                    cacheClearMethod = c.getMethod("fileGenerated", File.class);
                    cacheClearMethod.setAccessible(true);
                }
                catch (NoSuchMethodException noSuchMethodException) {}
            }
            catch (Throwable ex) {
                aClass = null;
                error = ex.getClass().getName() + ": " + ex.getMessage();
            }
            managerClass = aClass;
            directoryCacheClearMethod = cacheClearMethod;
            initError = error;
        }
    }

    private static class OptimizedFileManagerClassHolder {
        static final String CLASS_NAME = "org.jetbrains.jps.javac.OptimizedFileManager";
        static final Class<StandardJavaFileManager> managerClass;
        static final Method directoryCacheClearMethod;
        static final String initError;

        private OptimizedFileManagerClassHolder() {
        }

        static {
            Class<?> aClass = null;
            Method cacheClearMethod = null;
            String error = null;
            try {
                Class<?> c;
                aClass = c = Class.forName(CLASS_NAME);
                try {
                    cacheClearMethod = c.getMethod("fileGenerated", File.class);
                    cacheClearMethod.setAccessible(true);
                }
                catch (NoSuchMethodException noSuchMethodException) {}
            }
            catch (Throwable ex) {
                aClass = null;
                error = ex.getClass().getName() + ": " + ex.getMessage();
            }
            managerClass = aClass;
            directoryCacheClearMethod = cacheClearMethod;
            initError = error;
        }
    }
}

