/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.deployer.http;

import aQute.bnd.deployer.http.HttpsUtil;
import aQute.bnd.deployer.repository.ProgressWrappingStream;
import aQute.bnd.service.Plugin;
import aQute.bnd.service.Registry;
import aQute.bnd.service.RegistryPlugin;
import aQute.bnd.service.progress.ProgressPlugin;
import aQute.bnd.service.url.TaggedData;
import aQute.bnd.service.url.URLConnector;
import aQute.service.reporter.Reporter;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.GeneralSecurityException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultURLConnector
implements URLConnector,
Plugin,
RegistryPlugin {
    private static final String HEADER_IF_NONE_MATCH = "If-None-Match";
    private static final String HEADER_ETAG = "ETag";
    private static final String HEADER_LOCATION = "Location";
    private static final int RESPONSE_NOT_MODIFIED = 304;
    private boolean disableServerVerify = false;
    private Reporter reporter = null;
    private Registry registry = null;

    public InputStream connect(URL url) throws IOException {
        if (url == null) {
            throw new IOException("Can't connect to null URL");
        }
        TaggedData data = this.connectTagged(url);
        return data.getInputStream();
    }

    public void setProperties(Map<String, String> map) {
        this.disableServerVerify = "true".equalsIgnoreCase(map.get("disableServerVerify"));
    }

    public void setReporter(Reporter reporter) {
        this.reporter = reporter;
    }

    public TaggedData connectTagged(URL url) throws IOException {
        return this.connectTagged(url, null);
    }

    public TaggedData connectTagged(URL url, String tag) throws IOException {
        return this.connectTagged(url, tag, new HashSet<String>());
    }

    public TaggedData connectTagged(URL url, String tag, Set<String> loopDetect) throws IOException {
        try {
            TaggedData result;
            loopDetect.add(url.toString());
            URLConnection connection = url.openConnection();
            try {
                if (this.disableServerVerify) {
                    HttpsUtil.disableServerVerification(connection);
                }
            }
            catch (GeneralSecurityException e) {
                if (this.reporter != null) {
                    this.reporter.error("Error attempting to disable SSL server certificate verification: %s", new Object[]{e});
                }
                throw new IOException("Error attempting to disable SSL server certificate verification.");
            }
            if (connection instanceof HttpURLConnection) {
                HttpURLConnection httpConnection = (HttpURLConnection)connection;
                httpConnection.setUseCaches(true);
                if (tag != null) {
                    httpConnection.setRequestProperty(HEADER_IF_NONE_MATCH, tag);
                }
                httpConnection.setInstanceFollowRedirects(false);
                httpConnection.connect();
                int responseCode = httpConnection.getResponseCode();
                if (responseCode == 304) {
                    result = null;
                    httpConnection.disconnect();
                } else if (responseCode >= 300 && responseCode < 400) {
                    String location = httpConnection.getHeaderField(HEADER_LOCATION);
                    if (location == null) {
                        throw new IOException("HTTP server returned redirect status but Location header was missing.");
                    }
                    try {
                        URL resolved = url.toURI().resolve(location).toURL();
                        if (this.reporter != null) {
                            this.reporter.warning("HTTP address redirected from %s to %s", new Object[]{url.toString(), resolved.toString()});
                        }
                        if (loopDetect.contains(resolved.toString())) {
                            throw new IOException(String.format("Detected loop in HTTP redirect from '%s' to '%s'.", url, resolved));
                        }
                        if (Thread.currentThread().isInterrupted()) {
                            throw new IOException("Interrupted");
                        }
                        result = this.connectTagged(resolved, tag, loopDetect);
                    }
                    catch (URISyntaxException e) {
                        throw new IOException(String.format("Failed to resolve location '%s' against origin URL: %s", location, url), e);
                    }
                } else {
                    String responseTag = httpConnection.getHeaderField(HEADER_ETAG);
                    InputStream stream = this.createProgressWrappedStream(connection.getInputStream(), "Downloading " + url, -1);
                    result = new TaggedData(connection, stream);
                }
            } else {
                InputStream stream = this.createProgressWrappedStream(connection.getInputStream(), "Downloading " + url, -1);
                result = new TaggedData(connection, stream);
            }
            return result;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private InputStream createProgressWrappedStream(InputStream inputStream, String name, int size) {
        if (this.registry == null) {
            return inputStream;
        }
        List progressPlugins = this.registry.getPlugins(ProgressPlugin.class);
        if (progressPlugins == null || progressPlugins.size() == 0) {
            return inputStream;
        }
        return new ProgressWrappingStream(inputStream, name, size, progressPlugins);
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    static @interface Config {
        public boolean disableServerVerify();
    }
}

