/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.impl.AbstractForwardIndex;
import com.intellij.util.indexing.impl.InputDataDiffBuilder;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.PersistentHashMap;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class MapBasedForwardIndex<Key, Value, MapValueType>
extends AbstractForwardIndex<Key, Value> {
    @NotNull
    private volatile PersistentHashMap<Integer, MapValueType> myInputsIndex = this.createMap();

    protected MapBasedForwardIndex(IndexExtension<Key, Value, ?> indexExtension) throws IOException {
        super(indexExtension);
    }

    @NotNull
    public abstract PersistentHashMap<Integer, MapValueType> createMap() throws IOException;

    @Override
    @NotNull
    public InputDataDiffBuilder<Key, Value> getDiffBuilder(int inputId) throws IOException {
        InputDataDiffBuilder<Key, Value> inputDataDiffBuilder = this.getDiffBuilder(inputId, this.getInput(inputId));
        if (inputDataDiffBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/impl/MapBasedForwardIndex", "getDiffBuilder"));
        }
        return inputDataDiffBuilder;
    }

    protected abstract InputDataDiffBuilder<Key, Value> getDiffBuilder(int var1, MapValueType var2) throws IOException;

    protected abstract MapValueType convertToMapValueType(int var1, Map<Key, Value> var2) throws IOException;

    public MapValueType getInput(int inputId) throws IOException {
        return this.myInputsIndex.get(inputId);
    }

    @Override
    public void putInputData(int inputId, @NotNull Map<Key, Value> data) throws IOException {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/util/indexing/impl/MapBasedForwardIndex", "putInputData"));
        }
        if (!data.isEmpty()) {
            this.myInputsIndex.put(inputId, this.convertToMapValueType(inputId, data));
        } else {
            this.myInputsIndex.remove(inputId);
        }
    }

    @Override
    public void flush() {
        if (this.myInputsIndex.isDirty()) {
            this.myInputsIndex.force();
        }
    }

    @Override
    public void close() throws IOException {
        this.myInputsIndex.close();
    }

    @Override
    public void clear() throws IOException {
        File baseFile = this.myInputsIndex.getBaseFile();
        try {
            this.myInputsIndex.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (baseFile != null) {
            IOUtil.deleteAllFilesStartingWith(baseFile);
        }
        this.myInputsIndex = this.createMap();
    }
}

