/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.aether;

import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.util.filter.DependencyFilterUtils;
import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionConstraint;
import org.eclipse.aether.version.VersionRange;
import org.eclipse.aether.version.VersionScheme;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.aether.ArtifactKind;
import org.jetbrains.idea.maven.aether.ProgressConsumer;

public class ArtifactRepositoryManager {
    private static final VersionScheme ourVersioning = new GenericVersionScheme();
    private final DefaultRepositorySystemSession mySession;
    public static final RemoteRepository MAVEN_CENTRAL_REPOSITORY = ArtifactRepositoryManager.createRemoteRepository("central", "http://repo1.maven.org/maven2/");
    public static final RemoteRepository JBOSS_COMMUNITY_REPOSITORY = ArtifactRepositoryManager.createRemoteRepository("jboss.community", "https://repository.jboss.org/nexus/content/repositories/public/");
    public static final List<RemoteRepository> PREDEFINED_REMOTE_REPOSITORIES = Collections.unmodifiableList(Arrays.asList(MAVEN_CENTRAL_REPOSITORY, JBOSS_COMMUNITY_REPOSITORY));
    private static final RepositorySystem ourSystem;
    private List<RemoteRepository> myRemoteRepositories;

    public ArtifactRepositoryManager(@NotNull File localRepositoryPath) {
        if (localRepositoryPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localRepositoryPath", "org/jetbrains/idea/maven/aether/ArtifactRepositoryManager", "<init>"));
        }
        this(localRepositoryPath, ProgressConsumer.DEAF);
    }

    public ArtifactRepositoryManager(@NotNull File localRepositoryPath, @NotNull ProgressConsumer progressConsumer) {
        if (localRepositoryPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localRepositoryPath", "org/jetbrains/idea/maven/aether/ArtifactRepositoryManager", "<init>"));
        }
        if (progressConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressConsumer", "org/jetbrains/idea/maven/aether/ArtifactRepositoryManager", "<init>"));
        }
        this(localRepositoryPath, PREDEFINED_REMOTE_REPOSITORIES, progressConsumer);
    }

    public ArtifactRepositoryManager(@NotNull File localRepositoryPath, List<RemoteRepository> remoteRepositories, final @NotNull ProgressConsumer progressConsumer) {
        if (localRepositoryPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localRepositoryPath", "org/jetbrains/idea/maven/aether/ArtifactRepositoryManager", "<init>"));
        }
        if (progressConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressConsumer", "org/jetbrains/idea/maven/aether/ArtifactRepositoryManager", "<init>"));
        }
        this.myRemoteRepositories = new ArrayList<RemoteRepository>();
        this.myRemoteRepositories.addAll(remoteRepositories);
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        if (progressConsumer != ProgressConsumer.DEAF) {
            session.setTransferListener((TransferListener)Proxy.newProxyInstance(session.getClass().getClassLoader(), new Class[]{TransferListener.class}, new InvocationHandler(){
                private final EnumSet<TransferEvent.EventType> checkCancelEvents = EnumSet.of(TransferEvent.EventType.INITIATED, TransferEvent.EventType.STARTED, TransferEvent.EventType.PROGRESSED);

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    Object event = args[0];
                    if (event instanceof TransferEvent) {
                        TransferEvent.EventType type = ((TransferEvent)event).getType();
                        if (this.checkCancelEvents.contains(type) && progressConsumer.isCanceled()) {
                            throw new TransferCancelledException();
                        }
                        progressConsumer.consume(event.toString());
                    }
                    return null;
                }
            }));
        }
        session.setLocalRepositoryManager(ourSystem.newLocalRepositoryManager((RepositorySystemSession)session, new LocalRepository(localRepositoryPath)));
        session.setReadOnly();
        this.mySession = session;
    }

    public void addRemoteRepository(String id, String url) {
        this.myRemoteRepositories.add(ArtifactRepositoryManager.createRemoteRepository(id, url));
    }

    public Collection<File> resolveDependency(String groupId, String artifactId, String version) throws Exception {
        ArrayList<File> files = new ArrayList<File>();
        for (Artifact artifact : this.resolveDependencyAsArtifact(groupId, artifactId, version, EnumSet.of(ArtifactKind.ARTIFACT))) {
            files.add(artifact.getFile());
        }
        return files;
    }

    @NotNull
    public Collection<Artifact> resolveDependencyAsArtifact(String groupId, String artifactId, String versionConstraint, Set<ArtifactKind> artifactKinds) throws Exception {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        Set<VersionConstraint> constraints = Collections.singleton(ArtifactRepositoryManager.asVersionConstraint(versionConstraint));
        for (ArtifactKind kind : artifactKinds) {
            try {
                DependencyRequest dependencyRequest = new DependencyRequest(this.createCollectRequest(groupId, artifactId, constraints, EnumSet.of(kind)), DependencyFilterUtils.classpathFilter((String[])new String[]{"compile"}));
                DependencyResult result = ourSystem.resolveDependencies((RepositorySystemSession)this.mySession, dependencyRequest);
                for (ArtifactResult artifactResult : result.getArtifactResults()) {
                    artifacts.add(artifactResult.getArtifact());
                }
            }
            catch (DependencyResolutionException e) {
                if (kind != ArtifactKind.ARTIFACT) continue;
                throw e;
            }
        }
        ArrayList<Artifact> arrayList = artifacts;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/aether/ArtifactRepositoryManager", "resolveDependencyAsArtifact"));
        }
        return arrayList;
    }

    public List<Version> getAvailableVersions(String groupId, String artifactId, String versionConstraint, ArtifactKind artifactKind) throws Exception {
        VersionRangeResult result = ourSystem.resolveVersionRange((RepositorySystemSession)this.mySession, this.createVersionRangeRequest(groupId, artifactId, ArtifactRepositoryManager.asVersionConstraint(versionConstraint), artifactKind));
        return result.getVersions();
    }

    public static RemoteRepository createRemoteRepository(String id, String url) {
        return new RemoteRepository.Builder(id, "default", url).build();
    }

    private CollectRequest createCollectRequest(String groupId, String artifactId, Collection<VersionConstraint> versions, Set<ArtifactKind> kinds) {
        CollectRequest request = new CollectRequest();
        for (Artifact artifact : ArtifactRepositoryManager.toArtifacts(groupId, artifactId, versions, kinds)) {
            request.addDependency(new Dependency(artifact, "compile"));
        }
        return request.setRepositories(Collections.unmodifiableList(this.myRemoteRepositories));
    }

    private VersionRangeRequest createVersionRangeRequest(String groupId, String artifactId, VersionConstraint versioning, ArtifactKind artifactKind) {
        VersionRangeRequest request = new VersionRangeRequest();
        for (Artifact artifact : ArtifactRepositoryManager.toArtifacts(groupId, artifactId, Collections.singleton(versioning), EnumSet.of(artifactKind))) {
            request.setArtifact(artifact);
        }
        return request.setRepositories(Collections.unmodifiableList(this.myRemoteRepositories));
    }

    public static Version asVersion(@Nullable String str) throws InvalidVersionSpecificationException {
        return ourVersioning.parseVersion(str == null ? "" : str);
    }

    public static VersionRange asVersionRange(@Nullable String str) throws InvalidVersionSpecificationException {
        return ourVersioning.parseVersionRange(str == null ? "" : str);
    }

    public static VersionConstraint asVersionConstraint(@Nullable String str) throws InvalidVersionSpecificationException {
        return ourVersioning.parseVersionConstraint(str == null ? "" : str);
    }

    private static List<Artifact> toArtifacts(String groupId, String artifactId, Collection<VersionConstraint> constraints, Set<ArtifactKind> kinds) {
        if (constraints.isEmpty() || kinds.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Artifact> result = new ArrayList<Artifact>(kinds.size() * constraints.size());
        for (ArtifactKind kind : kinds) {
            for (VersionConstraint constr : constraints) {
                result.add((Artifact)new DefaultArtifact(groupId, artifactId, kind.getClassifier(), kind.getExtension(), constr.toString()));
            }
        }
        return result;
    }

    static {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        locator.setErrorHandler(new DefaultServiceLocator.ErrorHandler(){

            public void serviceCreationFailed(Class<?> type, Class<?> impl, Throwable exception) {
                if (exception != null) {
                    throw new RuntimeException(exception);
                }
            }
        });
        ourSystem = (RepositorySystem)locator.getService(RepositorySystem.class);
    }
}

