/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.signing;

import aQute.bnd.osgi.EmbeddedResource;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.Resource;
import aQute.lib.base64.Base64;
import aQute.lib.io.IO;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.util.Map;
import java.util.jar.Manifest;
import java.util.regex.Pattern;

public class Signer
extends Processor {
    static final int BUFFER_SIZE = 4096;
    static Pattern METAINFDIR = Pattern.compile("META-INF/[^/]*");
    String[] digestNames = new String[]{"MD5"};
    File keystoreFile = new File("keystore");
    String password;
    String alias;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signJar(Jar jar) {
        if (this.digestNames == null || this.digestNames.length == 0) {
            this.error("Need at least one digest algorithm name, none are specified", new Object[0]);
        }
        if (this.keystoreFile == null || !this.keystoreFile.getAbsoluteFile().exists()) {
            this.error("No such keystore file: %s", this.keystoreFile);
            return;
        }
        if (this.alias == null) {
            this.error("Private key alias not set for signing", new Object[0]);
            return;
        }
        MessageDigest[] digestAlgorithms = new MessageDigest[this.digestNames.length];
        this.getAlgorithms(this.digestNames, digestAlgorithms);
        try {
            Manifest manifest = jar.getManifest();
            manifest.getMainAttributes().putValue("Signed-By", "Bnd");
            ByteArrayOutputStream o = new ByteArrayOutputStream();
            manifest.write(o);
            this.doManifest(jar, this.digestNames, digestAlgorithms, o);
            o.flush();
            byte[] newManifestBytes = o.toByteArray();
            jar.putResource("META-INF/MANIFEST.MF", new EmbeddedResource(newManifestBytes, 0L));
            byte[] signatureFileBytes = this.doSignatureFile(this.digestNames, digestAlgorithms, newManifestBytes);
            jar.putResource("META-INF/BND.SF", new EmbeddedResource(signatureFileBytes, 0L));
            KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            KeyStore.PrivateKeyEntry privateKeyEntry = null;
            FileInputStream keystoreInputStream = null;
            try {
                keystoreInputStream = new FileInputStream(this.keystoreFile);
                char[] pw = this.password == null ? new char[]{} : this.password.toCharArray();
                keystore.load(keystoreInputStream, pw);
                keystoreInputStream.close();
                privateKeyEntry = (KeyStore.PrivateKeyEntry)keystore.getEntry(this.alias, new KeyStore.PasswordProtection(pw));
            }
            catch (Exception e) {
                try {
                    this.exception(e, "Not able to load the private key from the given keystore(%s) with alias %s", this.keystoreFile.getAbsolutePath(), this.alias);
                }
                catch (Throwable throwable) {
                    IO.close(keystoreInputStream);
                    throw throwable;
                }
                IO.close(keystoreInputStream);
                return;
            }
            IO.close(keystoreInputStream);
            PrivateKey privateKey = privateKeyEntry.getPrivateKey();
            Signature signature = Signature.getInstance("MD5withRSA");
            signature.initSign(privateKey);
            signature.update(signatureFileBytes);
            signature.sign();
            ByteArrayOutputStream tmpStream = new ByteArrayOutputStream();
            jar.putResource("META-INF/BND.RSA", new EmbeddedResource(tmpStream.toByteArray(), 0L));
        }
        catch (Exception e) {
            this.exception(e, "During signing: %s", e);
        }
    }

    private byte[] doSignatureFile(String[] digestNames, MessageDigest[] algorithms, byte[] manbytes) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintWriter ps = IO.writer(out);
        ps.print("Signature-Version: 1.0\r\n");
        for (int a = 0; a < algorithms.length; ++a) {
            if (algorithms[a] == null) continue;
            byte[] digest = algorithms[a].digest(manbytes);
            ps.print(digestNames[a] + "-Digest-Manifest: ");
            ps.print(new Base64(digest));
            ps.print("\r\n");
        }
        return out.toByteArray();
    }

    private void doManifest(Jar jar, String[] digestNames, MessageDigest[] algorithms, OutputStream out) throws Exception {
        for (Map.Entry<String, Resource> entry : jar.getResources().entrySet()) {
            String name = entry.getKey();
            if (METAINFDIR.matcher(name).matches()) continue;
            out.write("\r\n".getBytes("UTF-8"));
            out.write("Name: ".getBytes("UTF-8"));
            out.write(name.getBytes("UTF-8"));
            out.write("\r\n".getBytes("UTF-8"));
            this.digest(algorithms, entry.getValue());
            for (int a = 0; a < algorithms.length; ++a) {
                if (algorithms[a] == null) continue;
                byte[] digest = algorithms[a].digest();
                String header = digestNames[a] + "-Digest: " + new Base64(digest) + "\r\n";
                out.write(header.getBytes("UTF-8"));
            }
        }
    }

    private void digest(MessageDigest[] algorithms, Resource r) throws Exception {
        InputStream in = r.openInputStream();
        byte[] data = new byte[4096];
        int size = in.read(data);
        while (size > 0) {
            for (int a = 0; a < algorithms.length; ++a) {
                if (algorithms[a] == null) continue;
                algorithms[a].update(data, 0, size);
            }
            size = in.read(data);
        }
    }

    private void getAlgorithms(String[] digestNames, MessageDigest[] algorithms) {
        for (int i = 0; i < algorithms.length; ++i) {
            String name = digestNames[i];
            try {
                algorithms[i] = MessageDigest.getInstance(name);
                continue;
            }
            catch (NoSuchAlgorithmException e) {
                this.exception(e, "Specified digest algorithm %s, but not such algorithm was found", digestNames[i]);
            }
        }
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setKeystore(File keystore) {
        this.keystoreFile = keystore;
    }

    public void setAlias(String string) {
        this.alias = string;
    }
}

