/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.indexer.impl;

import java.util.List;
import java.util.jar.Manifest;
import org.osgi.service.indexer.Builder;
import org.osgi.service.indexer.Capability;
import org.osgi.service.indexer.Requirement;
import org.osgi.service.indexer.Resource;
import org.osgi.service.indexer.ResourceAnalyzer;
import org.osgi.service.log.LogService;

public class BlueprintAnalyzer
implements ResourceAnalyzer {
    private static final String BUNDLE_BLUEPRINT_HEADER = "Bundle-Blueprint";
    private LogService log;

    public BlueprintAnalyzer(LogService log) {
        this.log = log;
    }

    @Override
    public void analyzeResource(Resource resource, List<Capability> capabilities, List<Requirement> requirements) throws Exception {
        boolean blueprintEnabled = false;
        String header = null;
        Manifest manifest = resource.getManifest();
        if (manifest != null) {
            header = manifest.getMainAttributes().getValue(BUNDLE_BLUEPRINT_HEADER);
        }
        if (header != null) {
            blueprintEnabled = true;
        } else {
            List<String> children = resource.listChildren("OSGI-INF/blueprint/");
            if (children != null) {
                for (String child : children) {
                    if (!child.toLowerCase().endsWith(".xml")) continue;
                    blueprintEnabled = true;
                    break;
                }
            }
        }
        if (blueprintEnabled) {
            requirements.add(this.createRequirement());
        }
    }

    private Requirement createRequirement() {
        Builder builder = new Builder().setNamespace("osgi.extender");
        String filter = String.format("(&(%s=%s)(version>=1.0.0)(!(version>=2.0.0)))", "osgi.extender", "osgi.blueprint");
        builder.addDirective("filter", filter).addDirective("effective", "active");
        return builder.buildRequirement();
    }
}

