/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.impl.java;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import javax.tools.JavaCompiler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.java.CannotCreateJavaCompilerException;
import org.jetbrains.jps.builders.java.JavaCompilingTool;

public class EclipseCompilerTool
extends JavaCompilingTool {
    private static final String JAR_FILE_NAME_PREFIX = "ecj-";
    private static final String JAR_FILE_NAME_SUFFIX = ".jar";
    private String myVersion;

    @NotNull
    public String getId() {
        if ("Eclipse" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/impl/java/EclipseCompilerTool", "getId"));
        }
        return "Eclipse";
    }

    @Nullable
    public String getAlternativeId() {
        return "EclipseEmbedded";
    }

    @NotNull
    public String getDescription() {
        String version = this.myVersion;
        if (version == null) {
            String name;
            File file;
            version = "";
            JavaCompiler compiler = EclipseCompilerTool.findCompiler();
            String path = compiler != null ? PathManager.getJarPathForClass(compiler.getClass()) : null;
            File file2 = file = path != null ? new File(path) : null;
            if (file != null && (name = file.getName()).startsWith(JAR_FILE_NAME_PREFIX) && name.endsWith(JAR_FILE_NAME_SUFFIX)) {
                version = " " + name.substring(JAR_FILE_NAME_PREFIX.length(), name.length() - JAR_FILE_NAME_SUFFIX.length());
            }
            this.myVersion = version;
        }
        String string = "Eclipse compiler" + version;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/impl/java/EclipseCompilerTool", "getDescription"));
        }
        return string;
    }

    @NotNull
    public JavaCompiler createCompiler() throws CannotCreateJavaCompilerException {
        JavaCompiler javaCompiler = EclipseCompilerTool.findCompiler();
        if (javaCompiler == null) {
            throw new CannotCreateJavaCompilerException("Eclipse Batch Compiler was not found in classpath");
        }
        JavaCompiler javaCompiler2 = javaCompiler;
        if (javaCompiler2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/impl/java/EclipseCompilerTool", "createCompiler"));
        }
        return javaCompiler2;
    }

    @Nullable
    private static JavaCompiler findCompiler() {
        for (JavaCompiler javaCompiler : ServiceLoader.load(JavaCompiler.class)) {
            if (!"EclipseCompiler".equals(StringUtil.getShortName(javaCompiler.getClass()))) continue;
            return javaCompiler;
        }
        return null;
    }

    @NotNull
    public List<File> getAdditionalClasspath() {
        List list = ContainerUtil.createMaybeSingletonList((Object)EclipseCompilerTool.findEcjJarFile());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/impl/java/EclipseCompilerTool", "getAdditionalClasspath"));
        }
        return list;
    }

    @Nullable
    public static File findEcjJarFile() {
        File[] libs;
        for (File lib : libs = new File[]{new File(PathManager.getHomePath(), "lib"), new File(PathManager.getHomePath(), "community/lib")}) {
            File[] children = lib.listFiles((dir, name) -> name.startsWith(JAR_FILE_NAME_PREFIX) && name.endsWith(JAR_FILE_NAME_SUFFIX));
            if (children == null || children.length <= 0) continue;
            return children[0];
        }
        return null;
    }

    public List<String> getDefaultCompilerOptions() {
        return Collections.singletonList("-noExit");
    }
}

