/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.osgi.jps.build;

import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetRegistry;
import org.jetbrains.jps.builders.ModuleBasedBuildTargetType;
import org.jetbrains.jps.builders.ModuleBasedTarget;
import org.jetbrains.jps.builders.TargetOutputIndex;
import org.jetbrains.jps.builders.impl.BuildRootDescriptorImpl;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.indices.IgnoredFileIndex;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.osgi.jps.build.BndWrapper;
import org.jetbrains.osgi.jps.build.OsmorcBuildTargetType;
import org.jetbrains.osgi.jps.model.JpsOsmorcExtensionService;
import org.jetbrains.osgi.jps.model.JpsOsmorcModuleExtension;
import org.jetbrains.osgi.jps.util.OsgiBuildUtil;

public class OsmorcBuildTarget
extends ModuleBasedTarget<BuildRootDescriptor> {
    private final JpsOsmorcModuleExtension myExtension;
    private List<File> myOutputRoots;

    public OsmorcBuildTarget(@NotNull JpsOsmorcModuleExtension extension, @NotNull JpsModule module) {
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "org/jetbrains/osgi/jps/build/OsmorcBuildTarget", "<init>"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/osgi/jps/build/OsmorcBuildTarget", "<init>"));
        }
        super((ModuleBasedBuildTargetType)OsmorcBuildTargetType.INSTANCE, module);
        this.myOutputRoots = null;
        this.myExtension = extension;
    }

    public JpsOsmorcModuleExtension getExtension() {
        return this.myExtension;
    }

    public String getId() {
        return this.myModule.getName();
    }

    public Collection<BuildTarget<?>> computeDependencies(BuildTargetRegistry targetRegistry, TargetOutputIndex outputIndex) {
        BuildTargetRegistry.ModuleTargetSelector selector = BuildTargetRegistry.ModuleTargetSelector.PRODUCTION;
        return Collections.unmodifiableCollection(targetRegistry.getModuleBasedTargets(this.getModule(), selector));
    }

    @NotNull
    public List<BuildRootDescriptor> computeRootDescriptors(JpsModel model, ModuleExcludeIndex index, IgnoredFileIndex ignoredFileIndex, BuildDataPaths dataPaths) {
        File file;
        ArrayList rootDescriptors = ContainerUtil.newArrayList();
        JpsOsmorcModuleExtension extension = JpsOsmorcExtensionService.getExtension(this.getModule());
        if (extension != null && (file = extension.getBundleDescriptorFile()) != null) {
            rootDescriptors.add(new BuildRootDescriptorImpl((BuildTarget)this, file, true));
        }
        JpsJavaExtensionService.dependencies((JpsModule)this.getModule()).recursively().productionOnly().processModules(module -> {
            File root;
            if ((module == this.getModule() || JpsOsmorcExtensionService.getExtension(module) == null) && (root = JpsJavaExtensionService.getInstance().getOutputDirectory(this.myModule, false)) != null) {
                rootDescriptors.add(new BuildRootDescriptorImpl((BuildTarget)this, root, true));
            }
        });
        ArrayList arrayList = rootDescriptors;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/osgi/jps/build/OsmorcBuildTarget", "computeRootDescriptors"));
        }
        return arrayList;
    }

    @Nullable
    public BuildRootDescriptor findRootDescriptor(String rootId, BuildRootIndex rootIndex) {
        return (BuildRootDescriptor)ContainerUtil.find((Iterable)rootIndex.getTargetRoots((BuildTarget)this, null), descriptor -> descriptor.getRootId().equals(rootId));
    }

    @NotNull
    public String getPresentableName() {
        String string = "OSGi in module '" + this.getModule().getName() + "'";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/osgi/jps/build/OsmorcBuildTarget", "getPresentableName"));
        }
        return string;
    }

    @NotNull
    public Collection<File> getOutputRoots(CompileContext context) {
        if (this.myOutputRoots == null) {
            String location = this.myExtension.getJarFileLocation();
            if (!location.isEmpty()) {
                List<String> bundleNames;
                File bndFile;
                this.myOutputRoots = ContainerUtil.newArrayList();
                if (this.myExtension.isUseBndFile() && (bndFile = OsgiBuildUtil.findFileInModuleContentRoots(this.myModule, this.myExtension.getBndFileLocation())) != null && bndFile.isFile() && !(bundleNames = BndWrapper.getBundleNames(bndFile)).isEmpty()) {
                    String bundleDir = new File(location).getParent();
                    bundleNames.stream().map(name -> new File(bundleDir, (String)name)).forEach(this.myOutputRoots::add);
                }
                if (this.myOutputRoots.isEmpty()) {
                    this.myOutputRoots.add(new File(location));
                }
            } else {
                this.myOutputRoots = Collections.emptyList();
            }
        }
        List<File> list = this.myOutputRoots;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/osgi/jps/build/OsmorcBuildTarget", "getOutputRoots"));
        }
        return list;
    }

    public boolean isTests() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        OsmorcBuildTarget target = (OsmorcBuildTarget)((Object)o);
        return this.myExtension.equals(target.myExtension);
    }

    public int hashCode() {
        return this.myExtension.hashCode();
    }
}

