/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.indexer.impl.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.osgi.service.indexer.impl.util.AddOnlyIterator;
import org.osgi.service.indexer.impl.util.AddOnlyListIterator;

public class AddOnlyList<T>
implements List<T> {
    static final String ERROR_REMOVE = "Removal of items is not permitted.";
    static final String ERROR_REPLACE = "Replacement of items is not permitted.";
    private final List<T> delegate;

    public AddOnlyList(List<T> list) {
        this.delegate = list;
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException(ERROR_REMOVE);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException(ERROR_REMOVE);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException(ERROR_REMOVE);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException(ERROR_REMOVE);
    }

    @Override
    public T set(int index, T element) {
        throw new UnsupportedOperationException(ERROR_REPLACE);
    }

    @Override
    public T remove(int index) {
        throw new UnsupportedOperationException(ERROR_REMOVE);
    }

    @Override
    public Iterator<T> iterator() {
        return new AddOnlyIterator<T>(this.delegate.iterator());
    }

    @Override
    public ListIterator<T> listIterator() {
        return new AddOnlyListIterator<T>(this.delegate.listIterator());
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return new AddOnlyListIterator<T>(this.delegate.listIterator(index));
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return new AddOnlyList<T>(this.delegate.subList(fromIndex, toIndex));
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        return this.delegate.toArray(a);
    }

    @Override
    public boolean add(T e) {
        return this.delegate.add(e);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.delegate.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.delegate.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        return this.delegate.addAll(index, c);
    }

    @Override
    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public T get(int index) {
        return this.delegate.get(index);
    }

    @Override
    public void add(int index, T element) {
        this.delegate.add(index, element);
    }

    @Override
    public int indexOf(Object o) {
        return this.delegate.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.delegate.lastIndexOf(o);
    }
}

